/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.api;

import com.netflix.spectator.api.BasicTag;
import com.netflix.spectator.api.Tag;
import com.netflix.spectator.api.TagList;
import com.netflix.spectator.impl.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.SortedMap;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiPredicate;
import java.util.function.Predicate;

final class ArrayTagSet
implements TagList {
    static final ArrayTagSet EMPTY = new ArrayTagSet(new String[0]);
    private final String[] tags;
    private final int length;
    private int cachedHashCode;

    static ArrayTagSet create(String ... tags) {
        return EMPTY.addAll(tags);
    }

    static ArrayTagSet create(Tag ... tags) {
        return EMPTY.addAll(tags);
    }

    static ArrayTagSet create(Iterable<Tag> tags) {
        return tags instanceof ArrayTagSet ? (ArrayTagSet)tags : EMPTY.addAll(tags);
    }

    static ArrayTagSet create(Map<String, String> tags) {
        return EMPTY.addAll(tags);
    }

    static ArrayTagSet unsafeCreate(String[] tags, int length) {
        ArrayTagSet.insertionSort(tags, length);
        int len = ArrayTagSet.dedupInPlace(tags, length);
        return new ArrayTagSet(tags, len);
    }

    private ArrayTagSet(String[] tags) {
        this(tags, tags.length);
    }

    private ArrayTagSet(String[] tags, int length) {
        if (tags.length % 2 != 0) {
            throw new IllegalArgumentException("length of tags array must be even");
        }
        if (length > tags.length) {
            throw new IllegalArgumentException("length cannot be larger than tags array");
        }
        this.tags = tags;
        this.length = length;
        this.cachedHashCode = 0;
    }

    boolean isEmpty() {
        return this.length == 0;
    }

    ArrayTagSet add(String k, String v) {
        int idx;
        Preconditions.checkNotNull(k, "key");
        Preconditions.checkNotNull(v, "value");
        if (this.length == 0) {
            return new ArrayTagSet(new String[]{k, v});
        }
        int cmp = -1;
        for (idx = 0; idx < this.length && (cmp = this.tags[idx].compareTo(k)) < 0; idx += 2) {
        }
        if (cmp == 0) {
            if (this.tags[idx + 1].equals(v)) {
                return this;
            }
            String[] newTags = Arrays.copyOf(this.tags, this.length);
            newTags[idx + 1] = v;
            return new ArrayTagSet(newTags);
        }
        String[] newTags = new String[this.length + 2];
        newTags[idx] = k;
        newTags[idx + 1] = v;
        System.arraycopy(this.tags, 0, newTags, 0, idx);
        System.arraycopy(this.tags, idx, newTags, idx + 2, this.length - idx);
        return new ArrayTagSet(newTags);
    }

    ArrayTagSet add(Tag tag) {
        return this.add(tag.key(), tag.value());
    }

    ArrayTagSet addAll(Iterable<Tag> ts) {
        if (ts instanceof Collection) {
            Collection data = (Collection)ts;
            if (data.isEmpty()) {
                return this;
            }
            String[] newTags = new String[2 * data.size()];
            int i = 0;
            for (Tag t : data) {
                newTags[i++] = t.key();
                newTags[i++] = t.value();
            }
            this.checkForNullValues(newTags);
            return this.addAll(newTags, newTags.length);
        }
        if (ts instanceof TagList) {
            if (ts instanceof ArrayTagSet) {
                return this.addAll((ArrayTagSet)ts);
            }
            return this.addAll((TagList)ts);
        }
        ArrayList<Tag> data = new ArrayList<Tag>();
        for (Tag t : ts) {
            data.add(t);
        }
        return this.addAll(data);
    }

    ArrayTagSet addAll(Map<String, String> ts) {
        if (ts.isEmpty()) {
            return this;
        }
        if (ts instanceof ConcurrentMap) {
            ArrayList<Tag> data = new ArrayList<Tag>(ts.size());
            for (Map.Entry<String, String> entry : ts.entrySet()) {
                data.add(new BasicTag(entry.getKey(), entry.getValue()));
            }
            return this.addAll(data);
        }
        String[] newTags = new String[2 * ts.size()];
        int i = 0;
        for (Map.Entry<String, String> entry : ts.entrySet()) {
            newTags[i++] = Objects.requireNonNull(entry.getKey(), "tag keys cannot be null");
            newTags[i++] = Objects.requireNonNull(entry.getValue(), "tag values cannot be null");
        }
        boolean sorted = ts instanceof SortedMap && ArrayTagSet.isNaturallyOrdered((SortedMap)ts);
        return this.addAll(newTags, newTags.length, sorted, true);
    }

    ArrayTagSet addAll(String[] ts) {
        if (ts.length % 2 != 0) {
            throw new IllegalArgumentException("array length must be even, (length=" + ts.length + ")");
        }
        this.checkForNullValues(ts);
        String[] copy = Arrays.copyOf(ts, ts.length);
        return this.addAll(copy, copy.length);
    }

    private ArrayTagSet addAll(String[] ts, int tsLength) {
        return this.addAll(ts, tsLength, false, false);
    }

    private ArrayTagSet addAll(String[] ts, int tsLength, boolean sorted, boolean distinct) {
        if (tsLength == 0) {
            return this;
        }
        if (this.length == 0) {
            if (!sorted) {
                ArrayTagSet.insertionSort(ts, tsLength);
            }
            int len = tsLength;
            if (!distinct) {
                len = ArrayTagSet.dedup(ts, 0, ts, 0, tsLength);
            }
            return new ArrayTagSet(ts, len);
        }
        String[] newTags = new String[this.length + tsLength];
        if (!sorted) {
            ArrayTagSet.insertionSort(ts, tsLength);
        }
        int newLength = ArrayTagSet.merge(newTags, this.tags, this.length, ts, tsLength);
        return new ArrayTagSet(newTags, newLength);
    }

    private ArrayTagSet addAll(ArrayTagSet ts) {
        if (ts == this || ts.isEmpty()) {
            return this;
        }
        if (this.isEmpty()) {
            return ts;
        }
        String[] newTags = new String[this.length + ts.length];
        int newLength = ArrayTagSet.merge(newTags, this.tags, this.length, ts.tags, ts.length);
        return new ArrayTagSet(newTags, newLength);
    }

    private ArrayTagSet addAll(TagList ts) {
        int size = ts.size();
        if (size == 0) {
            return this;
        }
        String[] newTags = new String[size * 2];
        int j = 0;
        for (int i = 0; i < size; ++i) {
            newTags[j++] = Objects.requireNonNull(ts.getKey(i), "tag keys cannot be null");
            newTags[j++] = Objects.requireNonNull(ts.getValue(i), "tag values cannot be null");
        }
        return this.addAll(newTags, newTags.length);
    }

    ArrayTagSet addAll(Tag[] ts) {
        return this.addAll(ts, ts.length);
    }

    ArrayTagSet addAll(Tag[] ts, int tsLength) {
        if (tsLength == 0) {
            return this;
        }
        String[] newTags = this.toStringArray(ts, tsLength);
        this.checkForNullValues(newTags);
        return this.addAll(newTags, newTags.length);
    }

    private String[] toStringArray(Tag[] ts, int length) {
        String[] strs = new String[length * 2];
        for (int i = 0; i < length; ++i) {
            strs[2 * i] = ts[i].key();
            strs[2 * i + 1] = ts[i].value();
        }
        return strs;
    }

    private void checkForNullValues(String[] ts) {
        for (String s : ts) {
            if (s != null) continue;
            throw new NullPointerException("tag keys and values cannot be null");
        }
    }

    private static void insertionSort(String[] ts, int length) {
        if (length == 4) {
            if (ts[0].compareTo(ts[2]) > 0) {
                String tmp = ts[0];
                ts[0] = ts[2];
                ts[2] = tmp;
                tmp = ts[1];
                ts[1] = ts[3];
                ts[3] = tmp;
            }
        } else if (length > 4) {
            for (int i = 2; i < length; i += 2) {
                String k = ts[i];
                String v = ts[i + 1];
                for (int j = i - 2; j >= 0 && ts[j].compareTo(k) > 0; j -= 2) {
                    ts[j + 2] = ts[j];
                    ts[j + 3] = ts[j + 1];
                }
                ts[j + 2] = k;
                ts[j + 3] = v;
            }
        }
    }

    static int merge(String[] dst, String[] srcA, int lengthA, String[] srcB, int lengthB) {
        int i = 0;
        int ai = 0;
        int bi = 0;
        while (ai < lengthA && bi < lengthB) {
            int j;
            String ak = srcA[ai];
            String av = srcA[ai + 1];
            String bk = srcB[bi];
            String bv = srcB[bi + 1];
            int cmp = ak.compareTo(bk);
            if (cmp < 0) {
                dst[i++] = ak;
                dst[i++] = av;
                ai += 2;
                continue;
            }
            if (cmp > 0) {
                for (j = bi + 2; j < lengthB && bk.equals(srcB[j]); j += 2) {
                    bv = srcB[j + 1];
                }
                dst[i++] = bk;
                dst[i++] = bv;
                bi = j;
                continue;
            }
            for (j = bi + 2; j < lengthB && ak.equals(srcB[j]); j += 2) {
                bk = srcB[j];
                bv = srcB[j + 1];
            }
            dst[i++] = bk;
            dst[i++] = bv;
            bi = j;
            ai += 2;
        }
        if (ai < lengthA) {
            System.arraycopy(srcA, ai, dst, i, lengthA - ai);
            i += lengthA - ai;
        } else if (bi < lengthB) {
            i = ArrayTagSet.dedup(srcB, bi, dst, i, lengthB - bi);
        }
        return i;
    }

    private static int dedup(String[] src, int ss, String[] dst, int ds, int len) {
        String k;
        if (len == 0) {
            return ds;
        }
        dst[ds] = k = src[ss];
        dst[ds + 1] = src[ss + 1];
        int j = ds;
        int e = ss + len;
        for (int i = ss + 2; i < e; i += 2) {
            if (k.equals(src[i])) {
                dst[j] = src[i];
                dst[j + 1] = src[i + 1];
                continue;
            }
            dst[j += 2] = k = src[i];
            dst[j + 1] = src[i + 1];
        }
        return j + 2;
    }

    private static int dedupInPlace(String[] data, int len) {
        if (len == 0) {
            return 0;
        }
        String k = data[0];
        int j = 0;
        for (int i = 2; i < len; i += 2) {
            if (k.equals(data[i])) {
                data[j] = data[i];
                data[j + 1] = data[i + 1];
                continue;
            }
            k = data[i];
            if (i <= (j += 2)) continue;
            data[j] = k;
            data[j + 1] = data[i + 1];
        }
        return j + 2;
    }

    @Override
    public String getKey(int i) {
        return this.tags[i * 2];
    }

    @Override
    public String getValue(int i) {
        return this.tags[i * 2 + 1];
    }

    @Override
    public int size() {
        return this.length / 2;
    }

    @Override
    public ArrayTagSet filter(BiPredicate<String, String> predicate) {
        int n = this.size();
        String[] result = new String[2 * n];
        int pos = 0;
        for (int i = 0; i < n; ++i) {
            String v;
            String k = this.getKey(i);
            if (!predicate.test(k, v = this.getValue(i))) continue;
            result[pos++] = k;
            result[pos++] = v;
        }
        return new ArrayTagSet(result, pos);
    }

    @Override
    public ArrayTagSet filterByKey(Predicate<String> predicate) {
        return this.filter((k, v) -> predicate.test((String)k));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ArrayTagSet other = (ArrayTagSet)o;
        if (this.length != other.length) {
            return false;
        }
        for (int i = 0; i < this.length; ++i) {
            if (this.tags[i].equals(other.tags[i])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hc = this.cachedHashCode;
        if (hc == 0) {
            hc = 1;
            for (int i = 0; i < this.length; ++i) {
                hc = 31 * hc + this.tags[i].hashCode();
            }
            this.cachedHashCode = hc;
        }
        return hc;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < this.length; i += 2) {
            builder.append(':').append(this.tags[i]).append('=').append(this.tags[i + 1]);
        }
        return builder.toString();
    }

    @Override
    public Spliterator<Tag> spliterator() {
        return Spliterators.spliterator(this.iterator(), (long)this.size(), 1301);
    }

    private static boolean isNaturallyOrdered(SortedMap<?, ?> map) {
        return map.comparator() == null || Comparator.naturalOrder().equals(map.comparator());
    }
}

