/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.publish.atlas;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.dataformat.smile.SmileFactory;
import com.netflix.servo.publish.atlas.JsonPayload;
import com.netflix.servo.util.Throwables;
import iep.com.netflix.iep.http.RxHttp;
import iep.io.reactivex.netty.protocol.http.client.HttpClientRequest;
import iep.io.reactivex.netty.protocol.http.client.HttpClientResponse;
import iep.io.reactivex.netty.protocol.http.client.HttpResponseHeaders;
import io.netty.buffer.ByteBuf;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.Arrays;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;
import rx.Subscription;
import rx.exceptions.CompositeException;
import rx.functions.Func1;
import rx.functions.Func2;
import rx.schedulers.Schedulers;

@Singleton
public final class HttpHelper {
    private static final JsonFactory SMILE_FACTORY = new SmileFactory();
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpHelper.class);
    private static final String SMILE_CONTENT_TYPE = "application/x-jackson-smile";
    private final RxHttp rxHttp;

    @Inject
    public HttpHelper(RxHttp rxHttp) {
        this.rxHttp = rxHttp;
    }

    public RxHttp getRxHttp() {
        return this.rxHttp;
    }

    public Observable<HttpClientResponse<ByteBuf>> postSmile(String uriStr, JsonPayload payload) {
        byte[] entity = this.toByteArray(SMILE_FACTORY, payload);
        URI uri = URI.create(uriStr);
        return this.rxHttp.post(uri, SMILE_CONTENT_TYPE, entity);
    }

    private byte[] toByteArray(JsonFactory factory, JsonPayload payload) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try (JsonGenerator gen = factory.createGenerator((OutputStream)baos, JsonEncoding.UTF8);){
                payload.toJson(gen);
            }
            baos.close();
            return baos.toByteArray();
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private void logErr(String prefix, Throwable e, int sent, int total) {
        if (LOGGER.isWarnEnabled()) {
            Throwable cause = e.getCause() != null ? e.getCause() : e;
            String msg = String.format("%s exception %s:%s Sent %d/%d", prefix, cause.getClass().getSimpleName(), cause.getMessage(), sent, total);
            LOGGER.warn(msg);
            if (cause instanceof CompositeException) {
                CompositeException ce = (CompositeException)cause;
                for (Throwable t : ce.getExceptions()) {
                    LOGGER.warn(" Exception {}: {}", (Object)t.getClass().getSimpleName(), (Object)t.getMessage());
                }
            }
        }
    }

    public int sendAll(Iterable<Observable<Integer>> batches, int numMetrics, long timeoutMillis) {
        AtomicBoolean err = new AtomicBoolean(false);
        AtomicInteger updated = new AtomicInteger(0);
        LOGGER.debug("Got {} ms to send {} metrics", (Object)timeoutMillis, (Object)numMetrics);
        try {
            CountDownLatch completed = new CountDownLatch(1);
            Subscription s = Observable.mergeDelayError((Observable)Observable.from(batches)).timeout(timeoutMillis, TimeUnit.MILLISECONDS).subscribeOn(Schedulers.immediate()).subscribe(updated::addAndGet, exc -> {
                this.logErr("onError caught", (Throwable)exc, updated.get(), numMetrics);
                err.set(true);
                completed.countDown();
            }, completed::countDown);
            try {
                completed.await(timeoutMillis, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interrupted) {
                err.set(true);
                s.unsubscribe();
                LOGGER.warn("Timed out sending metrics. {}/{} sent", (Object)updated.get(), (Object)numMetrics);
            }
        }
        catch (Exception e) {
            err.set(true);
            this.logErr("Unexpected ", e, updated.get(), numMetrics);
        }
        if (updated.get() < numMetrics && !err.get()) {
            LOGGER.warn("No error caught, but only {}/{} sent.", (Object)updated.get(), (Object)numMetrics);
        }
        return updated.get();
    }

    public Response get(HttpClientRequest<ByteBuf> req, long timeout, TimeUnit timeUnit) {
        String uri = req.getUri();
        Response result = new Response();
        try {
            Func1 process = response -> {
                result.status = response.getStatus().code();
                result.headers = response.getHeaders();
                Func2 accumulator = (baos, bb) -> {
                    try {
                        bb.readBytes((OutputStream)baos, bb.readableBytes());
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    return baos;
                };
                return response.getContent().reduce((Object)new ByteArrayOutputStream(), accumulator).map(ByteArrayOutputStream::toByteArray);
            };
            Response.access$002(result, (byte[])this.rxHttp.submit(req).flatMap(process).subscribeOn(Schedulers.io()).toBlocking().toFuture().get(timeout, timeUnit));
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException("failed to get url: " + uri, e);
        }
    }

    public static class Response {
        private int status;
        private byte[] body;
        private HttpResponseHeaders headers;

        public int getStatus() {
            return this.status;
        }

        public byte[] getBody() {
            return Arrays.copyOf(this.body, this.body.length);
        }

        public HttpResponseHeaders getHeaders() {
            return this.headers;
        }

        static /* synthetic */ byte[] access$002(Response x0, byte[] x1) {
            x0.body = x1;
            return x1;
        }
    }
}

