/*
 * Decompiled with CFR 0.152.
 */
package mantis.io.reactivex.netty.server;

import io.netty.bootstrap.AbstractBootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.handler.logging.LogLevel;
import io.netty.util.concurrent.EventExecutorGroup;
import mantis.io.reactivex.netty.RxNetty;
import mantis.io.reactivex.netty.channel.ConnectionHandler;
import mantis.io.reactivex.netty.channel.ObservableConnection;
import mantis.io.reactivex.netty.metrics.MetricEventsListener;
import mantis.io.reactivex.netty.metrics.MetricEventsListenerFactory;
import mantis.io.reactivex.netty.pipeline.PipelineConfigurator;
import mantis.io.reactivex.netty.pipeline.PipelineConfigurators;
import mantis.io.reactivex.netty.pipeline.ssl.SSLEngineFactory;
import mantis.io.reactivex.netty.server.AbstractServer;
import mantis.io.reactivex.netty.server.ServerMetricsEvent;

public abstract class AbstractServerBuilder<I, O, T extends AbstractBootstrap<T, C>, C extends Channel, B extends AbstractServerBuilder, S extends AbstractServer<I, O, T, C, S>> {
    protected final T serverBootstrap;
    protected PipelineConfigurator<I, O> pipelineConfigurator;
    protected Class<? extends C> serverChannelClass;
    protected final ConnectionHandler<I, O> connectionHandler;
    protected final int port;
    protected LogLevel wireLogginLevel;
    protected MetricEventsListenerFactory eventListenersFactory;
    protected EventExecutorGroup eventExecutorGroup;
    protected SSLEngineFactory sslEngineFactory;

    protected AbstractServerBuilder(int port, T bootstrap, ConnectionHandler<I, O> connectionHandler) {
        if (null == connectionHandler) {
            throw new IllegalArgumentException("Connection handler can not be null");
        }
        if (null == bootstrap) {
            throw new IllegalArgumentException("Server bootstrap can not be null");
        }
        this.port = port;
        this.serverBootstrap = bootstrap;
        this.connectionHandler = connectionHandler;
        this.defaultChannelOptions();
    }

    public B eventLoop(EventLoopGroup singleGroup) {
        this.serverBootstrap.group(singleGroup);
        return this.returnBuilder();
    }

    public B channel(Class<? extends C> serverChannelClass) {
        this.serverChannelClass = serverChannelClass;
        return this.returnBuilder();
    }

    public <P> B channelOption(ChannelOption<P> option, P value) {
        this.serverBootstrap.option(option, value);
        return this.returnBuilder();
    }

    public B pipelineConfigurator(PipelineConfigurator<I, O> pipelineConfigurator) {
        this.pipelineConfigurator = pipelineConfigurator;
        return this.returnBuilder();
    }

    public B appendPipelineConfigurator(PipelineConfigurator<I, O> additionalConfigurator) {
        return this.pipelineConfigurator(PipelineConfigurators.composeConfigurators(this.pipelineConfigurator, additionalConfigurator));
    }

    public B withSslEngineFactory(SSLEngineFactory sslEngineFactory) {
        this.sslEngineFactory = sslEngineFactory;
        return this.returnBuilder();
    }

    public B enableWireLogging(LogLevel wireLogginLevel) {
        this.wireLogginLevel = wireLogginLevel;
        return this.returnBuilder();
    }

    public B defaultChannelOptions() {
        this.channelOption(ChannelOption.ALLOCATOR, PooledByteBufAllocator.DEFAULT);
        return this.returnBuilder();
    }

    public B withMetricEventsListenerFactory(MetricEventsListenerFactory eventListenersFactory) {
        this.eventListenersFactory = eventListenersFactory;
        return this.returnBuilder();
    }

    public B withEventExecutorGroup(EventExecutorGroup eventExecutorGroup) {
        this.eventExecutorGroup = eventExecutorGroup;
        return this.returnBuilder();
    }

    public B disableAutoReleaseBuffers() {
        this.serverBootstrap.attr(ObservableConnection.AUTO_RELEASE_BUFFERS, (Object)false);
        return this.returnBuilder();
    }

    public PipelineConfigurator<I, O> getPipelineConfigurator() {
        return this.pipelineConfigurator;
    }

    public S build() {
        if (null == this.serverChannelClass) {
            this.serverChannelClass = this.defaultServerChannelClass();
            EventLoopGroup acceptorGroup = this.serverBootstrap.group();
            if (null == acceptorGroup) {
                this.configureDefaultEventloopGroup();
            }
        }
        if (null == this.serverBootstrap.group()) {
            if (this.defaultServerChannelClass() == this.serverChannelClass) {
                this.configureDefaultEventloopGroup();
            } else {
                throw new IllegalStateException("Specified a channel class but not the event loop group.");
            }
        }
        this.serverBootstrap.channel(this.serverChannelClass);
        if (null != this.wireLogginLevel) {
            this.pipelineConfigurator = PipelineConfigurators.appendLoggingConfigurator(this.pipelineConfigurator, this.wireLogginLevel);
        }
        if (null != this.sslEngineFactory) {
            this.appendPipelineConfigurator(PipelineConfigurators.sslConfigurator(this.sslEngineFactory));
        }
        S server = this.createServer();
        if (null != this.eventListenersFactory) {
            MetricEventsListener<ServerMetricsEvent<Enum>> listener = this.newMetricsListener(this.eventListenersFactory, server);
            ((AbstractServer)server).subscribe((MetricEventsListener<? extends ServerMetricsEvent<?>>)listener);
        }
        return server;
    }

    protected void configureDefaultEventloopGroup() {
        this.serverBootstrap.group(RxNetty.getRxEventLoopProvider().globalServerEventLoop());
    }

    protected abstract Class<? extends C> defaultServerChannelClass();

    protected abstract S createServer();

    protected abstract MetricEventsListener<? extends ServerMetricsEvent<? extends Enum>> newMetricsListener(MetricEventsListenerFactory var1, S var2);

    protected B returnBuilder() {
        return (B)this;
    }
}

