/*
 * Decompiled with CFR 0.152.
 */
package mantis.io.reactivex.netty.protocol.http.server.file;

import io.netty.util.internal.SystemPropertyUtil;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import mantis.io.reactivex.netty.protocol.http.server.file.FileRequestHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalDirectoryRequestHandler
extends FileRequestHandler {
    private static final Logger logger = LoggerFactory.getLogger(LocalDirectoryRequestHandler.class);
    private final String prefix;

    public LocalDirectoryRequestHandler() {
        this(SystemPropertyUtil.get((String)"user.dir") + File.separator);
    }

    public LocalDirectoryRequestHandler(String prefix) {
        this.prefix = "file:///" + prefix;
    }

    @Override
    protected URI resolveUri(String path) {
        String filename = this.prefix + path;
        try {
            URI uri = new URI(filename);
            File file = new File(uri);
            if (!file.exists()) {
                logger.debug("File '{}' not found", (Object)filename);
                return null;
            }
            return uri;
        }
        catch (URISyntaxException e) {
            logger.debug("Error resolving uri for '{}'", (Object)filename);
            return null;
        }
    }
}

