/*
 * Decompiled with CFR 0.152.
 */
package mantis.io.reactivex.netty.pipeline;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.util.concurrent.EventExecutor;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import mantis.io.reactivex.netty.pipeline.InternalReadTimeoutHandler;
import mantis.io.reactivex.netty.pipeline.PipelineConfigurator;
import mantis.io.reactivex.netty.protocol.http.client.ClientRequestResponseConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class ReadTimeoutPipelineConfigurator
implements PipelineConfigurator<Object, Object> {
    private static final Logger logger = LoggerFactory.getLogger(ReadTimeoutPipelineConfigurator.class);
    public static final String READ_TIMEOUT_HANDLER_NAME = "readtimeout-handler";
    @Deprecated
    public static final String READ_TIMEOUT_LIFECYCLE_MANAGER_HANDLER_NAME = "readtimeout-handler-lifecycle-manager";
    private final long timeout;
    private final TimeUnit timeUnit;

    public ReadTimeoutPipelineConfigurator(long timeout, TimeUnit timeUnit) {
        this.timeout = timeout;
        this.timeUnit = timeUnit;
    }

    @Override
    public void configureNewPipeline(ChannelPipeline pipeline) {
        pipeline.addFirst(READ_TIMEOUT_HANDLER_NAME, (ChannelHandler)new InternalReadTimeoutHandler(this.timeout, this.timeUnit));
    }

    public static void disableReadTimeout(ChannelPipeline pipeline) {
        final ChannelHandler timeoutHandler = pipeline.get(READ_TIMEOUT_HANDLER_NAME);
        if (timeoutHandler != null && timeoutHandler instanceof InternalReadTimeoutHandler) {
            final ChannelHandlerContext handlerContext = pipeline.context(timeoutHandler);
            EventExecutor executor = handlerContext.executor();
            if (executor.inEventLoop()) {
                ReadTimeoutPipelineConfigurator.disableHandler(timeoutHandler, handlerContext);
            } else {
                executor.submit((Callable)new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        ReadTimeoutPipelineConfigurator.disableHandler(timeoutHandler, handlerContext);
                        return null;
                    }
                });
            }
        }
    }

    private static void disableHandler(ChannelHandler timeoutHandler, ChannelHandlerContext handlerContext) {
        InternalReadTimeoutHandler tHandler = (InternalReadTimeoutHandler)timeoutHandler;
        try {
            tHandler.cancelTimeoutSchedule(handlerContext);
        }
        catch (Exception e) {
            logger.error("Failed to disable read timeout handler. This connection will be discarded.", (Throwable)e);
            handlerContext.channel().attr(ClientRequestResponseConverter.DISCARD_CONNECTION).set((Object)true);
        }
    }
}

