/*
 * Decompiled with CFR 0.152.
 */
package iep.io.reactivex.netty.util;

import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelPromise;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.Iterator;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import rx.Observable;
import rx.Subscriber;

public class MultipleFutureListener
implements ChannelFutureListener {
    private final ChannelPromise completionPromise;
    private final Observable<Void> completionObservable;
    private final AtomicInteger listeningToCount = new AtomicInteger();
    private final ConcurrentLinkedQueue<ChannelFuture> pendingFutures = new ConcurrentLinkedQueue();

    public MultipleFutureListener(ChannelPromise completionPromise) {
        if (null == completionPromise) {
            throw new NullPointerException("Promise can not be null.");
        }
        this.completionPromise = completionPromise;
        this.completionObservable = Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<Void>(){

            public void call(final Subscriber<? super Void> subscriber) {
                if (MultipleFutureListener.this.listeningToCount.get() == 0) {
                    MultipleFutureListener.this.completionPromise.trySuccess();
                }
                MultipleFutureListener.this.completionPromise.addListener((GenericFutureListener)new ChannelFutureListener(){

                    public void operationComplete(ChannelFuture future) throws Exception {
                        if (future.isSuccess()) {
                            subscriber.onCompleted();
                        } else {
                            subscriber.onError(future.cause());
                        }
                    }
                });
            }
        });
    }

    public void listen(ChannelFuture future) {
        this.pendingFutures.add(future);
        this.listeningToCount.incrementAndGet();
        future.addListener((GenericFutureListener)this);
    }

    public Observable<Void> asObservable() {
        return this.completionObservable;
    }

    public void cancelPendingFutures(boolean mayInterruptIfRunning) {
        Iterator<ChannelFuture> iterator = this.pendingFutures.iterator();
        while (iterator.hasNext()) {
            ChannelFuture pendingFuture = iterator.next();
            iterator.remove();
            pendingFuture.cancel(mayInterruptIfRunning);
        }
    }

    public void operationComplete(ChannelFuture future) throws Exception {
        this.pendingFutures.remove(future);
        int nowListeningTo = this.listeningToCount.decrementAndGet();
        if (!future.isSuccess()) {
            this.completionPromise.tryFailure(future.cause());
        } else if (nowListeningTo == 0) {
            this.completionPromise.trySuccess(null);
        }
    }
}

