/*
 * Decompiled with CFR 0.152.
 */
package iep.io.reactivex.netty.protocol.udp.client;

import iep.io.reactivex.netty.channel.ChannelMetricEventProvider;
import iep.io.reactivex.netty.channel.ObservableConnection;
import iep.io.reactivex.netty.metrics.MetricEventsSubject;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.socket.DatagramPacket;
import java.net.InetSocketAddress;
import java.nio.charset.Charset;
import rx.Observable;

public class UdpClientConnection<I, O>
extends ObservableConnection<I, O> {
    private final InetSocketAddress receiverAddress;

    protected UdpClientConnection(Channel channel, InetSocketAddress receiverAddress, ChannelMetricEventProvider metricEventProvider, MetricEventsSubject<?> eventsSubject) {
        super(channel, metricEventProvider, eventsSubject);
        this.receiverAddress = receiverAddress;
    }

    public static <I, O> UdpClientConnection<I, O> create(Channel channel, InetSocketAddress receiverAddress, MetricEventsSubject<?> eventsSubject, ChannelMetricEventProvider metricEventProvider) {
        UdpClientConnection<I, O> toReturn = new UdpClientConnection<I, O>(channel, receiverAddress, metricEventProvider, eventsSubject);
        toReturn.fireNewRxConnectionEvent();
        return toReturn;
    }

    @Override
    public void writeBytes(byte[] msg) {
        ByteBuf data = this.getChannel().alloc().buffer(msg.length);
        data.writeBytes(msg);
        this.writeOnChannel(new DatagramPacket(data, this.receiverAddress));
    }

    @Override
    public Observable<Void> writeBytesAndFlush(byte[] msg) {
        this.writeBytes(msg);
        return this.flush();
    }

    @Override
    public void writeString(String msg) {
        byte[] dataBytes = msg.getBytes(Charset.defaultCharset());
        this.writeBytes(dataBytes);
    }

    @Override
    public Observable<Void> writeStringAndFlush(String msg) {
        this.writeString(msg);
        return this.flush();
    }
}

