/*
 * Decompiled with CFR 0.152.
 */
package iep.io.reactivex.netty.protocol.http.server;

import iep.io.reactivex.netty.metrics.Clock;
import iep.io.reactivex.netty.protocol.http.AbstractHttpContentHolder;
import iep.io.reactivex.netty.protocol.http.CookiesHolder;
import iep.io.reactivex.netty.protocol.http.UnicastContentSubject;
import iep.io.reactivex.netty.protocol.http.server.HttpRequestHeaders;
import iep.io.reactivex.netty.protocol.http.server.UriInfoHolder;
import io.netty.channel.Channel;
import io.netty.handler.codec.http.Cookie;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpVersion;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class HttpServerRequest<T>
extends AbstractHttpContentHolder<T> {
    public static final long DEFAULT_CONTENT_SUBSCRIPTION_TIMEOUT_MS = 1L;
    private final HttpRequest nettyRequest;
    private final HttpRequestHeaders headers;
    private final HttpMethod method;
    private final HttpVersion protocolVersion;
    private final UriInfoHolder uriInfoHolder;
    private final CookiesHolder cookiesHolder;
    private final Channel nettyChannel;
    private volatile long processingStartTimeMillis;

    @Deprecated
    public HttpServerRequest(HttpRequest nettyRequest, UnicastContentSubject<T> content) {
        super(content);
        this.nettyRequest = nettyRequest;
        this.headers = new HttpRequestHeaders(this.nettyRequest);
        this.method = this.nettyRequest.getMethod();
        this.protocolVersion = this.nettyRequest.getProtocolVersion();
        this.uriInfoHolder = new UriInfoHolder(this.nettyRequest.getUri());
        this.cookiesHolder = CookiesHolder.newServerRequestHolder(nettyRequest.headers());
        this.nettyChannel = null;
    }

    protected HttpServerRequest(Channel channel, HttpRequest nettyRequest, UnicastContentSubject<T> content) {
        super(content);
        this.nettyChannel = channel;
        this.nettyRequest = nettyRequest;
        this.headers = new HttpRequestHeaders(this.nettyRequest);
        this.method = this.nettyRequest.getMethod();
        this.protocolVersion = this.nettyRequest.getProtocolVersion();
        this.uriInfoHolder = new UriInfoHolder(this.nettyRequest.getUri());
        this.cookiesHolder = CookiesHolder.newServerRequestHolder(nettyRequest.headers());
    }

    public HttpRequestHeaders getHeaders() {
        return this.headers;
    }

    public HttpMethod getHttpMethod() {
        return this.method;
    }

    public HttpVersion getHttpVersion() {
        return this.protocolVersion;
    }

    public String getUri() {
        return this.uriInfoHolder.getRawUriString();
    }

    public String getPath() {
        return this.uriInfoHolder.getPath();
    }

    public String getQueryString() {
        return this.uriInfoHolder.getQueryString();
    }

    public Map<String, List<String>> getQueryParameters() {
        return this.uriInfoHolder.getQueryParameters();
    }

    public Map<String, Set<Cookie>> getCookies() {
        return this.cookiesHolder.getAllCookies();
    }

    public Channel getNettyChannel() {
        return this.nettyChannel;
    }

    void onProcessingStart(long processingStartTimeMillis) {
        this.processingStartTimeMillis = processingStartTimeMillis;
    }

    long onProcessingEnd() {
        return Clock.onEndMillis(this.processingStartTimeMillis);
    }
}

