/*
 * Decompiled with CFR 0.152.
 */
package iep.io.reactivex.netty.protocol.http.client;

import iep.io.reactivex.netty.client.ClientMetricsEvent;
import iep.io.reactivex.netty.metrics.MetricsEvent;

public class HttpClientMetricsEvent<T extends Enum>
extends ClientMetricsEvent<T> {
    public static final HttpClientMetricsEvent<EventType> REQUEST_SUBMITTED = HttpClientMetricsEvent.from(EventType.RequestSubmitted);
    public static final HttpClientMetricsEvent<EventType> REQUEST_CONTENT_SOURCE_ERROR = HttpClientMetricsEvent.from(EventType.RequestContentSourceError);
    public static final HttpClientMetricsEvent<EventType> REQUEST_HEADERS_WRITE_START = HttpClientMetricsEvent.from(EventType.RequestHeadersWriteStart);
    public static final HttpClientMetricsEvent<EventType> REQUEST_HEADERS_WRITE_SUCCESS = HttpClientMetricsEvent.from(EventType.RequestHeadersWriteSuccess);
    public static final HttpClientMetricsEvent<EventType> REQUEST_HEADERS_WRITE_FAILED = HttpClientMetricsEvent.from(EventType.RequestHeadersWriteFailed);
    public static final HttpClientMetricsEvent<EventType> REQUEST_CONTENT_WRITE_START = HttpClientMetricsEvent.from(EventType.RequestContentWriteStart);
    public static final HttpClientMetricsEvent<EventType> REQUEST_CONTENT_WRITE_SUCCESS = HttpClientMetricsEvent.from(EventType.RequestContentWriteSuccess);
    public static final HttpClientMetricsEvent<EventType> REQUEST_CONTENT_WRITE_FAILED = HttpClientMetricsEvent.from(EventType.RequestContentWriteFailed);
    public static final HttpClientMetricsEvent<EventType> REQUEST_WRITE_COMPLETE = HttpClientMetricsEvent.from(EventType.RequestWriteComplete);
    public static final HttpClientMetricsEvent<EventType> REQUEST_WRITE_FAILED = HttpClientMetricsEvent.from(EventType.RequestWriteFailed);
    public static final HttpClientMetricsEvent<EventType> RESPONSE_HEADER_RECEIVED = HttpClientMetricsEvent.from(EventType.ResponseHeadersReceived);
    public static final HttpClientMetricsEvent<EventType> RESPONSE_CONTENT_RECEIVED = HttpClientMetricsEvent.from(EventType.ResponseContentReceived);
    public static final HttpClientMetricsEvent<EventType> RESPONSE_RECEIVE_COMPLETE = HttpClientMetricsEvent.from(EventType.ResponseReceiveComplete);
    public static final HttpClientMetricsEvent<EventType> RESPONSE_FAILED = HttpClientMetricsEvent.from(EventType.ResponseFailed);
    public static final HttpClientMetricsEvent<EventType> REQUEST_PROCESSING_COMPLETE = HttpClientMetricsEvent.from(EventType.RequestProcessingComplete);

    protected HttpClientMetricsEvent(T type, boolean isTimed, boolean isError) {
        super(type, isTimed, isError);
    }

    private static HttpClientMetricsEvent<EventType> from(EventType type) {
        return new HttpClientMetricsEvent<EventType>(type, type.isTimed(), type.isError());
    }

    public static enum HttpEventType {

    }

    public static enum EventType implements MetricsEvent.MetricEventType
    {
        RequestSubmitted(false, false, Void.class),
        RequestContentSourceError(false, true, Void.class),
        RequestHeadersWriteStart(false, false, Void.class),
        RequestHeadersWriteSuccess(true, false, Void.class),
        RequestHeadersWriteFailed(true, true, Void.class),
        RequestContentWriteStart(false, false, Void.class),
        RequestContentWriteSuccess(true, false, Void.class),
        RequestContentWriteFailed(true, true, Void.class),
        RequestWriteComplete(true, false, Void.class),
        RequestWriteFailed(true, true, Void.class),
        ResponseHeadersReceived(false, false, Void.class),
        ResponseContentReceived(false, false, Void.class),
        ResponseReceiveComplete(true, false, Void.class),
        ResponseFailed(true, true, Void.class),
        RequestProcessingComplete(true, false, Void.class);

        private final boolean isTimed;
        private final boolean isError;
        private final Class<?> optionalDataType;

        private EventType(boolean isTimed, boolean isError, Class<?> optionalDataType) {
            this.isTimed = isTimed;
            this.isError = isError;
            this.optionalDataType = optionalDataType;
        }

        @Override
        public boolean isTimed() {
            return this.isTimed;
        }

        @Override
        public boolean isError() {
            return this.isError;
        }

        @Override
        public Class<?> getOptionalDataType() {
            return this.optionalDataType;
        }
    }
}

