/*
 * Decompiled with CFR 0.152.
 */
package iep.io.reactivex.netty.metrics;

import iep.io.reactivex.netty.metrics.MetricEventsListener;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class ListenerInvocationException
extends RuntimeException {
    private Map<MetricEventsListener<?>, Throwable> exceptions = new HashMap();
    private String message = super.getMessage();
    private static final long serialVersionUID = -4381062024201397997L;

    protected ListenerInvocationException() {
        super("Metric event listener invocation failed.");
    }

    protected void addException(MetricEventsListener<?> listener, Throwable error) {
        this.exceptions.put(listener, error);
    }

    protected void finish() {
        this.exceptions = Collections.unmodifiableMap(this.exceptions);
        StringBuilder msgBuilder = new StringBuilder(this.getMessage()).append(". Errors: \n");
        for (Map.Entry<MetricEventsListener<?>, Throwable> exceptionEntry : this.exceptions.entrySet()) {
            msgBuilder.append("Listener: ");
            msgBuilder.append(exceptionEntry.getKey().getClass().getSimpleName());
            msgBuilder.append("\n Error:");
            ByteArrayOutputStream stackTraceStream = new ByteArrayOutputStream();
            exceptionEntry.getValue().printStackTrace(new PrintStream(stackTraceStream));
            msgBuilder.append(stackTraceStream.toString());
        }
        this.message = msgBuilder.toString();
    }

    public Map<MetricEventsListener<?>, Throwable> getExceptions() {
        return this.exceptions;
    }

    @Override
    public String getMessage() {
        return this.message;
    }
}

