/*
 * Decompiled with CFR 0.152.
 */
package iep.io.reactivex.netty.client;

import iep.io.reactivex.netty.client.ClientChannelMetricEventProvider;
import iep.io.reactivex.netty.client.ClientConnectionFactory;
import iep.io.reactivex.netty.client.ClientMetricsEvent;
import iep.io.reactivex.netty.client.PoolConfig;
import iep.io.reactivex.netty.client.PooledConnection;
import iep.io.reactivex.netty.metrics.MetricEventsSubject;
import io.netty.channel.Channel;

public class PooledConnectionFactory<I, O>
implements ClientConnectionFactory<I, O, PooledConnection<I, O>> {
    private final PoolConfig poolConfig;
    private MetricEventsSubject<?> eventsSubject;

    public PooledConnectionFactory(PoolConfig poolConfig, MetricEventsSubject<ClientMetricsEvent<?>> eventsSubject) {
        this.poolConfig = poolConfig;
        this.eventsSubject = eventsSubject;
    }

    @Override
    public PooledConnection<I, O> newConnection(Channel channel) {
        return PooledConnection.create(channel, this.poolConfig.getMaxIdleTimeMillis(), ClientChannelMetricEventProvider.INSTANCE, this.eventsSubject);
    }

    @Override
    public void useMetricEventsSubject(MetricEventsSubject<?> eventsSubject) {
        this.eventsSubject = eventsSubject;
    }
}

