/*
 * Decompiled with CFR 0.152.
 */
package iep.com.netflix.iep.http;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;

public final class ServerSentEvent {
    private final String field;
    private final String value;

    private static ByteBuf toByteBuf(String string) {
        try {
            return Unpooled.wrappedBuffer((byte[])string.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
    }

    public static ServerSentEvent parse(ByteBuf byteBuf) {
        return ServerSentEvent.parse(byteBuf.toString(Charset.forName("UTF-8")));
    }

    public static ServerSentEvent parse(String string) {
        if (string == null || "".equals(string) || string.startsWith(":")) {
            return null;
        }
        int n = string.indexOf(58);
        if (n != -1) {
            String string2 = string.substring(0, n);
            String string3 = "";
            if (++n < string.length()) {
                if (string.charAt(n) == ' ') {
                    ++n;
                }
                string3 = n < string.length() ? string.substring(n) : "";
            }
            return new ServerSentEvent(string2, string3);
        }
        return new ServerSentEvent(string, "");
    }

    public ServerSentEvent(String string, String string2) {
        if (string == null) {
            throw new NullPointerException("field");
        }
        if (string2 == null) {
            throw new NullPointerException("value");
        }
        this.field = string;
        this.value = string2;
    }

    public String field() {
        return this.field;
    }

    public String value() {
        return this.value;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof ServerSentEvent)) {
            return false;
        }
        ServerSentEvent serverSentEvent = (ServerSentEvent)object;
        return this.field.equals(serverSentEvent.field) && this.value.equals(serverSentEvent.value);
    }

    public int hashCode() {
        int n = 31;
        n = 31 * n + this.field.hashCode();
        n = 31 * n + this.value.hashCode();
        return n;
    }

    public String toString() {
        return String.format("%s: %s\n\n", this.field, this.value);
    }
}

