/*
 * Decompiled with CFR 0.152.
 */
package iep.com.netflix.iep.http;

public final class Server {
    public static final String UNREGISTERED_HOST_ID = "UNREGISTERED";
    private final String id;
    private final String host;
    private final int port;
    private final boolean secure;

    public Server(String string, int n, boolean bl) {
        this(UNREGISTERED_HOST_ID, string, n, bl);
    }

    public Server(String string, String string2, int n, boolean bl) {
        this.id = string;
        this.host = string2;
        this.port = n;
        this.secure = bl;
    }

    public String id() {
        return this.id;
    }

    public String host() {
        return this.host;
    }

    public int port() {
        return this.port;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public boolean isRegistered() {
        return !UNREGISTERED_HOST_ID.equals(this.id);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof Server)) {
            return false;
        }
        Server server = (Server)object;
        return this.id.equals(server.id) && this.host.equals(server.host) && this.port == server.port && this.secure == server.secure;
    }

    public int hashCode() {
        int n = 31;
        n = 31 * n + this.id.hashCode();
        n = 31 * n + this.host.hashCode();
        n = 31 * n + Integer.valueOf(this.port).hashCode();
        n = 31 * n + Boolean.valueOf(this.secure).hashCode();
        return n;
    }

    public String toString() {
        return "Server(" + this.id + "," + this.host + "," + this.port + "," + this.secure + ")";
    }
}

