/*
 * Decompiled with CFR 0.152.
 */
package iep.com.netflix.iep.http;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.CorruptedFrameException;
import io.netty.handler.codec.TooLongFrameException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetflixJsonObjectDecoder
extends ByteToMessageDecoder {
    protected static final Logger LOGGER = LoggerFactory.getLogger(NetflixJsonObjectDecoder.class);
    private static final int ST_CORRUPTED = -1;
    private static final int ST_INIT = 0;
    private static final int ST_DECODING_NORMAL = 1;
    private static final int ST_DECODING_ARRAY_STREAM = 2;
    private int openBraces;
    private int len;
    private int state;
    private boolean insideString;
    private boolean escapeString;
    private final int maxObjectLength;
    private final boolean streamArrayElements;

    public NetflixJsonObjectDecoder() {
        this(0x100000);
    }

    public NetflixJsonObjectDecoder(int n) {
        this(n, false);
    }

    public NetflixJsonObjectDecoder(boolean bl) {
        this(0x100000, bl);
    }

    public NetflixJsonObjectDecoder(int n, boolean bl) {
        if (n < 1) {
            throw new IllegalArgumentException("maxObjectLength must be a positive int");
        }
        this.maxObjectLength = n;
        this.streamArrayElements = bl;
    }

    protected void decode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) throws Exception {
        if (this.state == -1) {
            byteBuf.skipBytes(byteBuf.readableBytes());
            return;
        }
        if (LOGGER.isTraceEnabled()) {
            byte[] byArray = new byte[byteBuf.readableBytes()];
            byteBuf.getBytes(byteBuf.readerIndex(), byArray, 0, byteBuf.readableBytes());
            LOGGER.trace("starting [" + byteBuf.readerIndex() + ":" + byteBuf.readableBytes() + "]:" + new String(byArray));
        }
        int n = this.len;
        int n2 = byteBuf.writerIndex();
        while (byteBuf.readerIndex() + n < n2) {
            if (n > this.maxObjectLength) {
                byteBuf.skipBytes(byteBuf.readableBytes());
                this.reset();
                throw new TooLongFrameException("object length exceeds " + this.maxObjectLength + ": " + n + " bytes discarded");
            }
            byte by = byteBuf.getByte(byteBuf.readerIndex() + n);
            if (this.state == 1) {
                this.decodeByte(by, byteBuf, byteBuf.readerIndex() + n);
                if (this.openBraces == 0) {
                    ByteBuf byteBuf2 = this.extractObject(channelHandlerContext, byteBuf, byteBuf.readerIndex(), n + 1);
                    if (byteBuf2 != null) {
                        list.add(byteBuf2);
                    }
                    byteBuf.readerIndex(byteBuf.readerIndex() + n + 1);
                    n = 0;
                    this.reset();
                    break;
                }
            } else if (this.state == 2) {
                if (n == 0 && Character.isWhitespace(by)) {
                    byteBuf.skipBytes(1);
                    --n;
                }
                this.decodeByte(by, byteBuf, byteBuf.readerIndex() + n);
                if (!this.insideString && (this.openBraces == 1 && by == 44 || this.openBraces == 0 && by == 93)) {
                    ByteBuf byteBuf3 = this.extractObject(channelHandlerContext, byteBuf, byteBuf.readerIndex(), n);
                    if (byteBuf3 != null) {
                        list.add(byteBuf3);
                    }
                    byteBuf.readerIndex(byteBuf.readerIndex() + n + 1);
                    n = 0;
                    if (by != 93) break;
                    this.reset();
                    break;
                }
            } else if (by == 123 || by == 91) {
                this.initDecoding(by);
                if (this.state == 2) {
                    byteBuf.skipBytes(1);
                    --n;
                }
            } else if (Character.isWhitespace(by)) {
                byteBuf.skipBytes(1);
                --n;
            } else {
                this.state = -1;
                throw new CorruptedFrameException("invalid JSON received at byte position " + (byteBuf.readerIndex() + n) + ": " + ByteBufUtil.hexDump((ByteBuf)byteBuf));
            }
            ++n;
        }
        this.len = n;
        if (LOGGER.isTraceEnabled()) {
            byte[] byArray = new byte[byteBuf.readableBytes()];
            byteBuf.getBytes(byteBuf.readerIndex(), byArray, 0, byteBuf.readableBytes());
            LOGGER.trace("remainder [" + byteBuf.readerIndex() + ":" + byteBuf.readableBytes() + "]:" + new String(byArray));
        }
    }

    protected ByteBuf extractObject(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, int n, int n2) {
        if (n2 == 0) {
            return null;
        }
        ByteBuf byteBuf2 = byteBuf.slice(n, n2).retain();
        if (LOGGER.isTraceEnabled()) {
            byte[] byArray = new byte[byteBuf2.readableBytes()];
            byteBuf2.getBytes(byteBuf2.readerIndex(), byArray, 0, byteBuf2.readableBytes());
            LOGGER.trace("extracted [" + byteBuf2.readerIndex() + ":" + byteBuf2.readableBytes() + "]:" + new String(byArray));
        }
        return byteBuf2;
    }

    private void decodeByte(byte by, ByteBuf byteBuf, int n) {
        if (!(by != 123 && by != 91 || this.insideString)) {
            ++this.openBraces;
        } else if (!(by != 125 && by != 93 || this.insideString)) {
            --this.openBraces;
        } else if (by == 34) {
            if (!this.insideString) {
                this.insideString = true;
            } else if (!this.escapeString) {
                this.insideString = false;
            }
        }
        this.escapeString = this.insideString && by == 92 && !this.escapeString;
    }

    private void initDecoding(byte by) {
        this.openBraces = 1;
        this.state = by == 91 && this.streamArrayElements ? 2 : 1;
    }

    private void reset() {
        this.insideString = false;
        this.escapeString = false;
        this.state = 0;
        this.openBraces = 0;
    }
}

