/*
 * Decompiled with CFR 0.152.
 */
package iep.com.netflix.iep.http;

import com.netflix.archaius.api.Config;
import io.netty.handler.logging.LogLevel;
import java.net.URI;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ClientConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClientConfig.class);
    private static final Pattern NIWS_URI = Pattern.compile("niws://([^/]+).*");
    private static final Pattern VIP_URI = Pattern.compile("vip://([^:]+):([^/]+).*");
    private final Config config;
    private final String name;
    private final String vipAddress;
    private final URI originalUri;
    private final URI uri;

    static String relative(URI uRI) {
        String string = uRI.getRawPath();
        if (string == null) {
            string = "/";
        } else if (string.startsWith("//")) {
            string = string.substring(1);
        }
        if (uRI.getRawQuery() != null) {
            string = string + "?" + uRI.getRawQuery();
        }
        return string;
    }

    private static String fixPath(String string) {
        return string.startsWith("/http://") || string.startsWith("/https://") ? string.substring(1) : string;
    }

    static ClientConfig fromUri(Config config, URI uRI) {
        ClientConfig clientConfig;
        switch (uRI.getScheme()) {
            case "niws": {
                Matcher matcher = NIWS_URI.matcher(uRI.toString());
                if (matcher.matches()) {
                    URI uRI2 = URI.create(ClientConfig.fixPath(ClientConfig.relative(uRI)));
                    clientConfig = new ClientConfig(config, matcher.group(1), null, uRI, uRI2);
                    break;
                }
                throw new IllegalArgumentException("invalid niws uri: " + uRI);
            }
            case "vip": {
                Matcher matcher = VIP_URI.matcher(uRI.toString());
                if (matcher.matches()) {
                    clientConfig = new ClientConfig(config, matcher.group(1), matcher.group(2), uRI, URI.create(ClientConfig.relative(uRI)));
                    break;
                }
                throw new IllegalArgumentException("invalid vip uri: " + uRI);
            }
            default: {
                clientConfig = new ClientConfig(config, "default", null, uRI, uRI);
            }
        }
        LOGGER.trace(clientConfig.toString());
        return clientConfig;
    }

    ClientConfig(Config config, String string, String string2, URI uRI, URI uRI2) {
        this.config = config;
        this.name = string;
        this.vipAddress = string2;
        this.originalUri = uRI;
        this.uri = uRI2;
    }

    private String dfltProp(String string) {
        return "niws.client." + string;
    }

    private String prop(String string) {
        return this.name + "." + this.dfltProp(string);
    }

    private String getString(String string, String string2) {
        String string3 = this.config.getString(this.prop(string), null);
        return string3 == null ? this.config.getString(this.dfltProp(string), string2) : string3;
    }

    private int getInt(String string, int n) {
        String string2 = this.getString(string, null);
        return string2 == null ? n : Integer.parseInt(string2);
    }

    private boolean getBoolean(String string, boolean bl) {
        String string2 = this.getString(string, null);
        return string2 == null ? bl : Boolean.parseBoolean(string2);
    }

    String name() {
        return this.name;
    }

    URI originalUri() {
        return this.originalUri;
    }

    URI uri() {
        return this.uri;
    }

    String relativeUri() {
        return ClientConfig.relative(this.uri);
    }

    int port(int n) {
        return this.getInt("Port", n);
    }

    int connectTimeout() {
        return this.getInt("ConnectTimeout", 1000);
    }

    int connectionActiveLifeAge() {
        return this.getInt("ConnectionActiveLifeAge", 0);
    }

    boolean contentAutoRelease() {
        return this.getBoolean("ContentAutoRelease", true);
    }

    int contentSubscribeTimeout() {
        return this.getInt("ContentSubscribeTimeout", 0);
    }

    int readTimeout() {
        return this.getInt("ReadTimeout", 30000);
    }

    int followRedirects() {
        return this.getInt("FollowRedirects", 3);
    }

    int maxConnectionsPerHost() {
        return this.getInt("MaxConnectionsPerHost", 20);
    }

    int maxConnectionsTotal() {
        return this.getInt("MaxConnectionsTotal", 200);
    }

    int idleConnectionsTimeoutMillis() {
        return this.getInt("ConnectionPoolIdleEvictTimeMilliseconds", 60000);
    }

    boolean isSecure() {
        boolean bl = "https".equals(this.uri.getScheme());
        return bl || this.getBoolean("IsSecure", false);
    }

    boolean useIpAddress() {
        return this.getBoolean("UseIpAddress", true);
    }

    boolean gzipEnabled() {
        return this.getBoolean("GzipEnabled", true);
    }

    boolean wireLoggingEnabled() {
        return this.getBoolean("WireLoggingEnabled", false);
    }

    LogLevel wireLoggingLevel() {
        return LogLevel.valueOf((String)this.getString("WireLoggingLevel", "ERROR"));
    }

    int numRetries() {
        return this.getInt("MaxAutoRetriesNextServer", 2);
    }

    int retryDelay() {
        return this.getInt("RetryDelay", 500);
    }

    boolean retryReadTimeouts() {
        return this.getBoolean("RetryReadTimeouts", true);
    }

    String userAgent() {
        return this.getString("UserAgent", "RxHttp");
    }

    String vip() {
        return this.vipAddress == null ? this.getString("DeploymentContextBasedVipAddresses", null) : this.vipAddress;
    }

    public String toString() {
        return "ClientConfig(Name=" + this.name + ",URI=" + this.uri + ",Port=" + this.port(-1) + ",ConnectTimeout=" + this.connectTimeout() + ",ReadTimeout=" + this.readTimeout() + ",ConnectionActiveLifeAge=" + this.connectionActiveLifeAge() + ",ContentAutoRelease=" + this.contentAutoRelease() + ",ContentSubscribeTimeout=" + this.contentSubscribeTimeout() + ",FollowRedirects=" + this.followRedirects() + ",MaxConnectionsPerHost=" + this.maxConnectionsPerHost() + ",MaxConnectionsTotal=" + this.maxConnectionsTotal() + ",ConnectionPoolIdleEvictTimeMilliseconds=" + this.idleConnectionsTimeoutMillis() + ",UseIpAddress=" + this.useIpAddress() + ",GzipEnabled=" + this.gzipEnabled() + ",WireLoggingEnabled=" + this.wireLoggingEnabled() + ",WireLoggingLevel=" + this.wireLoggingLevel() + ",MaxAutoRetriesNextServer=" + this.numRetries() + ",RetryDelay=" + this.retryDelay() + ",RetryReadTimeouts=" + this.retryReadTimeouts() + ",UserAgent=" + this.userAgent() + ",DeploymentContextBasedVipAddresses=" + this.vip() + ")";
    }
}

