/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.contrib.javanica.command;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import java.util.concurrent.Future;
import rx.Completable;
import rx.Observable;
import rx.Single;

public enum ExecutionType {
    ASYNCHRONOUS,
    SYNCHRONOUS,
    OBSERVABLE;

    private static final Set<? extends Class> RX_TYPES;

    public static ExecutionType getExecutionType(Class<?> type) {
        if (Future.class.isAssignableFrom(type)) {
            return ASYNCHRONOUS;
        }
        if (ExecutionType.isRxType(type)) {
            return OBSERVABLE;
        }
        return SYNCHRONOUS;
    }

    private static boolean isRxType(Class<?> cl) {
        for (Class clazz : RX_TYPES) {
            if (!clazz.isAssignableFrom(cl)) continue;
            return true;
        }
        return false;
    }

    static {
        RX_TYPES = ImmutableSet.of(Observable.class, Single.class, Completable.class);
    }
}

