/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.discovery.endpoint;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Nullable;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DnsResolver {
    private static final Logger logger = LoggerFactory.getLogger(DnsResolver.class);
    private static final String DNS_PROVIDER_URL = "dns:";
    private static final String DNS_NAMING_FACTORY = "com.sun.jndi.dns.DnsContextFactory";
    private static final String JAVA_NAMING_FACTORY_INITIAL = "java.naming.factory.initial";
    private static final String JAVA_NAMING_PROVIDER_URL = "java.naming.provider.url";
    private static final String A_RECORD_TYPE = "A";
    private static final String CNAME_RECORD_TYPE = "CNAME";
    private static final String TXT_RECORD_TYPE = "TXT";
    static final DirContext dirContext = DnsResolver.getDirContext();

    private DnsResolver() {
    }

    public static DirContext getDirContext() {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put(JAVA_NAMING_FACTORY_INITIAL, DNS_NAMING_FACTORY);
        env.put(JAVA_NAMING_PROVIDER_URL, DNS_PROVIDER_URL);
        try {
            return new InitialDirContext(env);
        }
        catch (Throwable e) {
            throw new RuntimeException("Cannot get dir context for some reason", e);
        }
    }

    public static String resolve(String originalHost) {
        String currentHost = originalHost;
        if (DnsResolver.isLocalOrIp(currentHost)) {
            return originalHost;
        }
        try {
            String targetHost = null;
            do {
                Attributes attrs;
                Attribute attr;
                if ((attr = (attrs = dirContext.getAttributes(currentHost, new String[]{A_RECORD_TYPE, CNAME_RECORD_TYPE})).get(A_RECORD_TYPE)) != null) {
                    targetHost = attr.get().toString();
                }
                if ((attr = attrs.get(CNAME_RECORD_TYPE)) != null) {
                    currentHost = attr.get().toString();
                    continue;
                }
                targetHost = currentHost;
            } while (targetHost == null);
            return targetHost;
        }
        catch (NamingException e) {
            logger.warn("Cannot resolve eureka server address {}; returning original value {}", new Object[]{currentHost, originalHost, e});
            return originalHost;
        }
    }

    @Nullable
    public static List<String> resolveARecord(String rootDomainName) {
        if (DnsResolver.isLocalOrIp(rootDomainName)) {
            return null;
        }
        try {
            Attributes attrs = dirContext.getAttributes(rootDomainName, new String[]{A_RECORD_TYPE, CNAME_RECORD_TYPE});
            Attribute aRecord = attrs.get(A_RECORD_TYPE);
            Attribute cRecord = attrs.get(CNAME_RECORD_TYPE);
            if (aRecord != null && cRecord == null) {
                ArrayList<String> result = new ArrayList<String>();
                NamingEnumeration<?> entries = aRecord.getAll();
                while (entries.hasMore()) {
                    result.add((String)entries.next());
                }
                return result;
            }
        }
        catch (Exception e) {
            logger.warn("Cannot load A-record for eureka server address {}", (Object)rootDomainName, (Object)e);
            return null;
        }
        return null;
    }

    private static boolean isLocalOrIp(String currentHost) {
        if ("localhost".equals(currentHost)) {
            return true;
        }
        return "127.0.0.1".equals(currentHost);
    }

    public static Set<String> getCNamesFromTxtRecord(String discoveryDnsName) throws NamingException {
        Attributes attrs = dirContext.getAttributes(discoveryDnsName, new String[]{TXT_RECORD_TYPE});
        Attribute attr = attrs.get(TXT_RECORD_TYPE);
        String txtRecord = null;
        if (attr != null) {
            txtRecord = attr.get().toString();
        }
        TreeSet<String> cnamesSet = new TreeSet<String>();
        if (txtRecord == null || txtRecord.trim().isEmpty()) {
            return cnamesSet;
        }
        String[] cnames = txtRecord.split(" ");
        Collections.addAll(cnamesSet, cnames);
        return cnamesSet;
    }
}

