/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.appinfo;

import com.netflix.appinfo.AmazonInfo;
import com.netflix.appinfo.AmazonInfoConfig;
import com.netflix.appinfo.DataCenterInfo;
import java.util.HashMap;
import java.util.HashSet;
import javax.inject.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RefreshableAmazonInfoProvider
implements Provider<AmazonInfo> {
    private static final Logger logger = LoggerFactory.getLogger(RefreshableAmazonInfoProvider.class);
    volatile AmazonInfo info;
    private final AmazonInfoConfig amazonInfoConfig;

    public RefreshableAmazonInfoProvider(AmazonInfoConfig amazonInfoConfig, FallbackAddressProvider fallbackAddressProvider) {
        this(RefreshableAmazonInfoProvider.init(amazonInfoConfig, fallbackAddressProvider), amazonInfoConfig);
    }

    RefreshableAmazonInfoProvider(AmazonInfo initialInfo, AmazonInfoConfig amazonInfoConfig) {
        this.amazonInfoConfig = amazonInfoConfig;
        this.info = initialInfo;
    }

    private static AmazonInfo init(AmazonInfoConfig amazonInfoConfig, FallbackAddressProvider fallbackAddressProvider) {
        AmazonInfo info;
        try {
            info = AmazonInfo.Builder.newBuilder().withAmazonInfoConfig(amazonInfoConfig).autoBuild(amazonInfoConfig.getNamespace());
            logger.info("Datacenter is: {}", (Object)DataCenterInfo.Name.Amazon);
        }
        catch (Throwable e) {
            logger.error("Cannot initialize amazon info :", e);
            throw new RuntimeException(e);
        }
        if (info.get(AmazonInfo.MetaDataKey.instanceId) == null) {
            if (amazonInfoConfig.shouldValidateInstanceId()) {
                throw new RuntimeException("Your datacenter is defined as cloud but we are not able to get the amazon metadata to register. \nSet the property " + amazonInfoConfig.getNamespace() + "validateInstanceId to false to ignore the metadata call");
            }
            HashMap<String, String> metadataMap = new HashMap<String, String>();
            metadataMap.put(AmazonInfo.MetaDataKey.instanceId.getName(), fallbackAddressProvider.getFallbackIp());
            metadataMap.put(AmazonInfo.MetaDataKey.publicHostname.getName(), fallbackAddressProvider.getFallbackHostname());
            info.setMetadata(metadataMap);
        } else if (info.get(AmazonInfo.MetaDataKey.publicHostname) == null && info.get(AmazonInfo.MetaDataKey.localIpv4) != null) {
            info.getMetadata().put(AmazonInfo.MetaDataKey.publicHostname.getName(), info.get(AmazonInfo.MetaDataKey.localIpv4));
        }
        return info;
    }

    public synchronized void refresh() {
        try {
            AmazonInfo newInfo = AmazonInfo.Builder.newBuilder().withAmazonInfoConfig(this.amazonInfoConfig).autoBuild(this.amazonInfoConfig.getNamespace());
            if (RefreshableAmazonInfoProvider.shouldUpdate(newInfo, this.info)) {
                logger.info("The AmazonInfo changed from : {} => {}", (Object)this.info, (Object)newInfo);
                this.info = newInfo;
            }
        }
        catch (Throwable t) {
            logger.error("Cannot refresh the Amazon Info ", t);
        }
    }

    public AmazonInfo get() {
        return this.info;
    }

    static boolean shouldUpdate(AmazonInfo newInfo, AmazonInfo oldInfo) {
        if (newInfo.getMetadata().isEmpty()) {
            logger.warn("Newly resolved AmazonInfo is empty, skipping an update cycle");
        } else if (!newInfo.equals(oldInfo)) {
            if (RefreshableAmazonInfoProvider.isBlank(newInfo.get(AmazonInfo.MetaDataKey.instanceId))) {
                logger.warn("instanceId is blank, skipping an update cycle");
                return false;
            }
            if (RefreshableAmazonInfoProvider.isBlank(newInfo.get(AmazonInfo.MetaDataKey.localIpv4))) {
                logger.warn("localIpv4 is blank, skipping an update cycle");
                return false;
            }
            HashSet<String> newKeys = new HashSet<String>(newInfo.getMetadata().keySet());
            HashSet<String> oldKeys = new HashSet<String>(oldInfo.getMetadata().keySet());
            HashSet<String> union = new HashSet<String>(newKeys);
            union.retainAll(oldKeys);
            newKeys.removeAll(union);
            oldKeys.removeAll(union);
            for (String key : newKeys) {
                logger.info("Adding new metadata {}={}", (Object)key, (Object)newInfo.getMetadata().get(key));
            }
            for (String key : oldKeys) {
                logger.info("Removing old metadata {}={}", (Object)key, (Object)oldInfo.getMetadata().get(key));
            }
            return true;
        }
        return false;
    }

    private static boolean isBlank(String str) {
        return str == null || str.isEmpty();
    }

    public static interface FallbackAddressProvider {
        public String getFallbackIp();

        public String getFallbackHostname();
    }
}

