/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.discovery.util;

import com.netflix.appinfo.InstanceInfo;

public class EurekaEntityTransformers {
    private static final Transformer<Object> IDENTITY_TRANSFORMER = new Transformer<Object>(){

        @Override
        public Object apply(Object value) {
            return value;
        }
    };
    private static final Transformer<InstanceInfo> ADD_ACTION_SETTER_TRANSFORMER = new Transformer<InstanceInfo>(){

        @Override
        public InstanceInfo apply(InstanceInfo instance) {
            InstanceInfo copy = new InstanceInfo(instance);
            copy.setActionType(InstanceInfo.ActionType.ADDED);
            return copy;
        }
    };
    private static final Transformer<InstanceInfo> MODIFIED_ACTION_SETTER_TRANSFORMER = new Transformer<InstanceInfo>(){

        @Override
        public InstanceInfo apply(InstanceInfo instance) {
            InstanceInfo copy = new InstanceInfo(instance);
            copy.setActionType(InstanceInfo.ActionType.MODIFIED);
            return copy;
        }
    };
    private static final Transformer<InstanceInfo> DELETED_ACTION_SETTER_TRANSFORMER = new Transformer<InstanceInfo>(){

        @Override
        public InstanceInfo apply(InstanceInfo instance) {
            InstanceInfo copy = new InstanceInfo(instance);
            copy.setActionType(InstanceInfo.ActionType.DELETED);
            return copy;
        }
    };

    public static <T> Transformer<T> identity() {
        return IDENTITY_TRANSFORMER;
    }

    public static Transformer<InstanceInfo> actionTypeSetter(InstanceInfo.ActionType actionType) {
        switch (actionType) {
            case ADDED: {
                return ADD_ACTION_SETTER_TRANSFORMER;
            }
            case MODIFIED: {
                return MODIFIED_ACTION_SETTER_TRANSFORMER;
            }
            case DELETED: {
                return DELETED_ACTION_SETTER_TRANSFORMER;
            }
        }
        throw new IllegalStateException("Unhandled ActionType value " + (Object)((Object)actionType));
    }

    public static interface Transformer<T> {
        public T apply(T var1);
    }
}

