/*
 * Decompiled with CFR 0.152.
 */
package com.mycila.maven.plugin.license.document;

import com.mycila.maven.plugin.license.document.Document;
import com.mycila.maven.plugin.license.document.DocumentPropertiesLoader;
import com.mycila.maven.plugin.license.header.HeaderDefinition;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.Map;

public final class DocumentFactory {
    private final Map<String, String> mapping;
    private final Map<String, HeaderDefinition> definitions;
    private final File basedir;
    private final Charset encoding;
    private final String[] keywords;
    private final DocumentPropertiesLoader documentPropertiesLoader;

    public DocumentFactory(File basedir, Map<String, String> mapping, Map<String, HeaderDefinition> definitions, Charset encoding, String[] keywords, DocumentPropertiesLoader documentPropertiesLoader) {
        this.mapping = mapping;
        this.definitions = definitions;
        this.basedir = basedir;
        this.encoding = encoding;
        this.keywords = (String[])keywords.clone();
        this.documentPropertiesLoader = documentPropertiesLoader;
    }

    public Document createDocuments(String file) {
        return this.getWrapper(file);
    }

    private Document getWrapper(String file) {
        String headerType = this.mapping.get("");
        String lowerFileName = Path.of(file, new String[0]).getFileName().toString().toLowerCase();
        for (Map.Entry<String, String> entry : this.mapping.entrySet()) {
            String lowerKey = entry.getKey().toLowerCase();
            if (!lowerFileName.endsWith("." + lowerKey) && !lowerFileName.equals(lowerKey)) continue;
            headerType = entry.getValue().toLowerCase();
            break;
        }
        return new Document(new File(this.basedir, file), this.definitions.get(headerType), this.encoding, this.keywords, this.documentPropertiesLoader);
    }
}

