/*
 * Decompiled with CFR 0.152.
 */
package com.mohiva.play.silhouette.impl.providers;

import com.mohiva.play.silhouette.api.LoginInfo;
import com.mohiva.play.silhouette.api.exceptions.ConfigurationException;
import com.mohiva.play.silhouette.api.exceptions.ConfigurationException$;
import com.mohiva.play.silhouette.api.repositories.AuthInfoRepository;
import com.mohiva.play.silhouette.api.util.Credentials;
import com.mohiva.play.silhouette.api.util.PasswordHasherRegistry;
import com.mohiva.play.silhouette.impl.exceptions.IdentityNotFoundException;
import com.mohiva.play.silhouette.impl.exceptions.IdentityNotFoundException$;
import com.mohiva.play.silhouette.impl.exceptions.InvalidPasswordException;
import com.mohiva.play.silhouette.impl.exceptions.InvalidPasswordException$;
import com.mohiva.play.silhouette.impl.providers.CredentialsProvider$;
import com.mohiva.play.silhouette.impl.providers.PasswordProvider;
import com.mohiva.play.silhouette.impl.providers.PasswordProvider$Authenticated$;
import com.mohiva.play.silhouette.impl.providers.PasswordProvider$InvalidPassword$;
import com.mohiva.play.silhouette.impl.providers.PasswordProvider$NotFound$;
import com.mohiva.play.silhouette.impl.providers.PasswordProvider$UnsupportedHasher$;
import java.io.Serializable;
import javax.inject.Inject;
import scala.Function1;
import scala.MatchError;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005]4A\u0001E\t\u0001=!A\u0011\u0006\u0001BC\u0002\u0013E!\u0006\u0003\u00054\u0001\t\u0005\t\u0015!\u0003,\u0011!!\u0004A!b\u0001\n#)\u0004\u0002\u0003\u001f\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001c\t\u0011u\u0002!Q1A\u0005\u0004yB\u0001\"\u0012\u0001\u0003\u0002\u0003\u0006Ia\u0010\u0005\u0006\r\u0002!\ta\u0012\u0005\u0006-\u0002!\te\u0016\u0005\u0006A\u0002!\t!\u0019\u0005\u0006]\u0002!\ta\\\u0004\u0006cFA\tA\u001d\u0004\u0006!EA\ta\u001d\u0005\u0006\r2!\t\u0001\u001e\u0005\bk2\u0011\r\u0011\"\u0001X\u0011\u00191H\u0002)A\u00051\n\u00192I]3eK:$\u0018.\u00197t!J|g/\u001b3fe*\u0011!cE\u0001\naJ|g/\u001b3feNT!\u0001F\u000b\u0002\t%l\u0007\u000f\u001c\u0006\u0003-]\t!b]5mQ>,X\r\u001e;f\u0015\tA\u0012$\u0001\u0003qY\u0006L(B\u0001\u000e\u001c\u0003\u0019iw\u000e[5wC*\tA$A\u0002d_6\u001c\u0001aE\u0002\u0001?\u0015\u0002\"\u0001I\u0012\u000e\u0003\u0005R\u0011AI\u0001\u0006g\u000e\fG.Y\u0005\u0003I\u0005\u0012a!\u00118z%\u00164\u0007C\u0001\u0014(\u001b\u0005\t\u0012B\u0001\u0015\u0012\u0005A\u0001\u0016m]:x_J$\u0007K]8wS\u0012,'/\u0001\nbkRD\u0017J\u001c4p%\u0016\u0004xn]5u_JLX#A\u0016\u0011\u00051\nT\"A\u0017\u000b\u00059z\u0013\u0001\u0004:fa>\u001c\u0018\u000e^8sS\u0016\u001c(B\u0001\u0019\u0016\u0003\r\t\u0007/[\u0005\u0003e5\u0012!#Q;uQ&sgm\u001c*fa>\u001c\u0018\u000e^8ss\u0006\u0019\u0012-\u001e;i\u0013:4wNU3q_NLGo\u001c:zA\u00051\u0002/Y:to>\u0014H\rS1tQ\u0016\u0014(+Z4jgR\u0014\u00180F\u00017!\t9$(D\u00019\u0015\tIt&\u0001\u0003vi&d\u0017BA\u001e9\u0005Y\u0001\u0016m]:x_J$\u0007*Y:iKJ\u0014VmZ5tiJL\u0018a\u00069bgN<xN\u001d3ICNDWM\u001d*fO&\u001cHO]=!\u0003A)\u00070Z2vi&|gnQ8oi\u0016DH/F\u0001@!\t\u00015)D\u0001B\u0015\t\u0011\u0015%\u0001\u0006d_:\u001cWO\u001d:f]RL!\u0001R!\u0003!\u0015CXmY;uS>t7i\u001c8uKb$\u0018!E3yK\u000e,H/[8o\u0007>tG/\u001a=uA\u00051A(\u001b8jiz\"2\u0001S&M)\tI%\n\u0005\u0002'\u0001!)Qh\u0002a\u0002\u007f!)\u0011f\u0002a\u0001W!)Ag\u0002a\u0001m!\u0012qA\u0014\t\u0003\u001fRk\u0011\u0001\u0015\u0006\u0003#J\u000ba!\u001b8kK\u000e$(\"A*\u0002\u000b)\fg/\u0019=\n\u0005U\u0003&AB%oU\u0016\u001cG/\u0001\u0002jIV\t\u0001\f\u0005\u0002Z=6\t!L\u0003\u0002\\9\u0006!A.\u00198h\u0015\u0005i\u0016\u0001\u00026bm\u0006L!a\u0018.\u0003\rM#(/\u001b8h\u00031\tW\u000f\u001e5f]RL7-\u0019;f)\t\u0011\u0017\u000eE\u0002AG\u0016L!\u0001Z!\u0003\r\u0019+H/\u001e:f!\t1w-D\u00010\u0013\tAwFA\u0005M_\u001eLg.\u00138g_\")!.\u0003a\u0001W\u0006Y1M]3eK:$\u0018.\u00197t!\t9D.\u0003\u0002nq\tY1I]3eK:$\u0018.\u00197t\u0003%awnZ5o\u0013:4w\u000e\u0006\u0002ca\")!N\u0003a\u0001W\u0006\u00192I]3eK:$\u0018.\u00197t!J|g/\u001b3feB\u0011a\u0005D\n\u0003\u0019}!\u0012A]\u0001\u0003\u0013\u0012\u000b1!\u0013#!\u0001")
public class CredentialsProvider
implements PasswordProvider {
    private final AuthInfoRepository authInfoRepository;
    private final PasswordHasherRegistry passwordHasherRegistry;
    private final ExecutionContext executionContext;
    private volatile PasswordProvider$Authenticated$ Authenticated$module;
    private volatile PasswordProvider$InvalidPassword$ InvalidPassword$module;
    private volatile PasswordProvider$UnsupportedHasher$ UnsupportedHasher$module;
    private volatile PasswordProvider$NotFound$ NotFound$module;

    public static String ID() {
        return CredentialsProvider$.MODULE$.ID();
    }

    @Override
    public Future<PasswordProvider.State> authenticate(LoginInfo loginInfo, String password) {
        return PasswordProvider.authenticate$(this, loginInfo, password);
    }

    @Override
    public PasswordProvider$Authenticated$ Authenticated() {
        if (this.Authenticated$module == null) {
            this.Authenticated$lzycompute$1();
        }
        return this.Authenticated$module;
    }

    @Override
    public PasswordProvider$InvalidPassword$ InvalidPassword() {
        if (this.InvalidPassword$module == null) {
            this.InvalidPassword$lzycompute$1();
        }
        return this.InvalidPassword$module;
    }

    @Override
    public PasswordProvider$UnsupportedHasher$ UnsupportedHasher() {
        if (this.UnsupportedHasher$module == null) {
            this.UnsupportedHasher$lzycompute$1();
        }
        return this.UnsupportedHasher$module;
    }

    @Override
    public PasswordProvider$NotFound$ NotFound() {
        if (this.NotFound$module == null) {
            this.NotFound$lzycompute$1();
        }
        return this.NotFound$module;
    }

    @Override
    public AuthInfoRepository authInfoRepository() {
        return this.authInfoRepository;
    }

    @Override
    public PasswordHasherRegistry passwordHasherRegistry() {
        return this.passwordHasherRegistry;
    }

    @Override
    public ExecutionContext executionContext() {
        return this.executionContext;
    }

    @Override
    public String id() {
        return CredentialsProvider$.MODULE$.ID();
    }

    public Future<LoginInfo> authenticate(Credentials credentials) {
        return this.loginInfo(credentials).flatMap((Function1 & Serializable)loginInfo -> this.authenticate((LoginInfo)loginInfo, credentials.password()).map((Function1 & Serializable)x0$1 -> {
            PasswordProvider.State state = x0$1;
            if (!this.Authenticated().equals(state)) {
                if (state instanceof PasswordProvider.InvalidPassword) {
                    PasswordProvider.InvalidPassword invalidPassword = (PasswordProvider.InvalidPassword)state;
                    String error = invalidPassword.error();
                    throw new InvalidPasswordException(error, InvalidPasswordException$.MODULE$.$lessinit$greater$default$2());
                }
                if (state instanceof PasswordProvider.UnsupportedHasher) {
                    PasswordProvider.UnsupportedHasher unsupportedHasher = (PasswordProvider.UnsupportedHasher)state;
                    String error = unsupportedHasher.error();
                    throw new ConfigurationException(error, ConfigurationException$.MODULE$.$lessinit$greater$default$2());
                }
                if (state instanceof PasswordProvider.NotFound) {
                    PasswordProvider.NotFound notFound = (PasswordProvider.NotFound)state;
                    String error = notFound.error();
                    throw new IdentityNotFoundException(error, IdentityNotFoundException$.MODULE$.$lessinit$greater$default$2());
                }
                throw new MatchError((Object)state);
            }
            LoginInfo loginInfo = loginInfo;
            return loginInfo;
        }, this.executionContext()), this.executionContext());
    }

    public Future<LoginInfo> loginInfo(Credentials credentials) {
        return Future$.MODULE$.successful((Object)new LoginInfo(this.id(), credentials.identifier()));
    }

    private final void Authenticated$lzycompute$1() {
        CredentialsProvider credentialsProvider = this;
        synchronized (credentialsProvider) {
            if (this.Authenticated$module == null) {
                this.Authenticated$module = new PasswordProvider$Authenticated$(this);
            }
        }
    }

    private final void InvalidPassword$lzycompute$1() {
        CredentialsProvider credentialsProvider = this;
        synchronized (credentialsProvider) {
            if (this.InvalidPassword$module == null) {
                this.InvalidPassword$module = new PasswordProvider$InvalidPassword$(this);
            }
        }
    }

    private final void UnsupportedHasher$lzycompute$1() {
        CredentialsProvider credentialsProvider = this;
        synchronized (credentialsProvider) {
            if (this.UnsupportedHasher$module == null) {
                this.UnsupportedHasher$module = new PasswordProvider$UnsupportedHasher$(this);
            }
        }
    }

    private final void NotFound$lzycompute$1() {
        CredentialsProvider credentialsProvider = this;
        synchronized (credentialsProvider) {
            if (this.NotFound$module == null) {
                this.NotFound$module = new PasswordProvider$NotFound$(this);
            }
        }
    }

    @Inject
    public CredentialsProvider(AuthInfoRepository authInfoRepository, PasswordHasherRegistry passwordHasherRegistry, ExecutionContext executionContext) {
        this.authInfoRepository = authInfoRepository;
        this.passwordHasherRegistry = passwordHasherRegistry;
        this.executionContext = executionContext;
        PasswordProvider.$init$(this);
    }
}

