/*
 * Decompiled with CFR 0.152.
 */
package com.moesif.api;

import com.moesif.api.APIHelper;
import com.moesif.api.Base64;
import java.util.Map;

public class BodyParser {
    public static BodyWrapper parseBody(Map<String, String> headers, String content) {
        if (content.equals("[\"[UNSUPPORTED ENCODING]\"]")) {
            String errorMsgJson = "{    \"moesif_error\": {       \"code\": \"servlet_content_type_error\",       \"msg\": \"The content type of the body is not supported.\",       \"src\": \"moesif-servlet\",       \"args\": \"\"    }";
            try {
                return new BodyWrapper(APIHelper.deserialize(errorMsgJson, Object.class), null);
            }
            catch (Exception E) {
                return new BodyWrapper(null, null);
            }
        }
        if (BodyParser.isJsonHeader(headers) || BodyParser.startWithJson(content)) {
            try {
                return new BodyWrapper(APIHelper.deserialize(content, Object.class), null);
            }
            catch (Exception e) {
                return new BodyWrapper(BodyParser.getBase64String(content), "base64");
            }
        }
        return new BodyWrapper(BodyParser.getBase64String(content), "base64");
    }

    private static boolean isJsonHeader(Map<String, String> headers) {
        String val = headers.get("Content-Type");
        if (val != null && val.contains("json")) {
            return true;
        }
        String val2 = headers.get("content-type");
        if (val2 != null && val2.contains("json")) {
            return true;
        }
        String val3 = headers.get("CONTENT-TYPE");
        return val3 != null && val3.contains("json");
    }

    private static boolean startWithJson(String str) {
        return str.trim().startsWith("[") || str.trim().startsWith("{");
    }

    private static String getBase64String(String str) {
        byte[] encodedBytes = Base64.encode(str.getBytes(), 0);
        return new String(encodedBytes);
    }

    public static class BodyWrapper {
        public Object body;
        public String transferEncoding;

        public BodyWrapper(Object body, String transferEncoding) {
            this.body = body;
            this.transferEncoding = transferEncoding;
        }
    }
}

