/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.mock.web;

import com.mockrunner.mock.web.MockRequestDispatcher;
import com.mockrunner.util.common.StreamUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextAttributeEvent;
import javax.servlet.ServletContextAttributeListener;
import javax.servlet.ServletException;

public class MockServletContext
implements ServletContext {
    private Map attributes;
    private Map requestDispatchers;
    private Map contexts;
    private Map initParameters;
    private Map mimeTypes;
    private Map realPaths;
    private Map resources;
    private Map resourcePaths;
    private Map resourceStreams;
    private String servletContextName;
    private String contextPath;
    private List attributeListener;
    private int majorVersion;
    private int minorVersion;
    private int effectiveMajorVersion;
    private int effectiveMinorVersion;

    public MockServletContext() {
        this.resetAll();
    }

    public synchronized void resetAll() {
        this.attributes = new HashMap();
        this.requestDispatchers = new HashMap();
        this.contexts = new HashMap();
        this.initParameters = new HashMap();
        this.mimeTypes = new HashMap();
        this.realPaths = new HashMap();
        this.resources = new HashMap();
        this.resourcePaths = new HashMap();
        this.resourceStreams = new HashMap();
        this.attributeListener = new ArrayList();
        this.majorVersion = 2;
        this.minorVersion = 5;
        this.effectiveMajorVersion = 2;
        this.effectiveMinorVersion = 5;
    }

    public synchronized void addAttributeListener(ServletContextAttributeListener listener) {
        this.attributeListener.add(listener);
    }

    public synchronized void clearAttributes() {
        this.attributes.clear();
    }

    public synchronized Object getAttribute(String key) {
        return this.attributes.get(key);
    }

    public synchronized Enumeration getAttributeNames() {
        Vector attKeys = new Vector(this.attributes.keySet());
        return attKeys.elements();
    }

    public synchronized void removeAttribute(String key) {
        Object value = this.attributes.get(key);
        this.attributes.remove(key);
        if (null != value) {
            this.callAttributeListenersRemovedMethod(key, value);
        }
    }

    public synchronized void setAttribute(String key, Object value) {
        Object oldValue = this.attributes.get(key);
        if (null == value) {
            this.attributes.remove(key);
        } else {
            this.attributes.put(key, value);
        }
        this.handleAttributeListenerCalls(key, value, oldValue);
    }

    public synchronized RequestDispatcher getNamedDispatcher(String name) {
        return this.getRequestDispatcher(name);
    }

    public synchronized RequestDispatcher getRequestDispatcher(String path) {
        RequestDispatcher dispatcher = (RequestDispatcher)this.requestDispatchers.get(path);
        if (null == dispatcher) {
            dispatcher = new MockRequestDispatcher();
            this.setRequestDispatcher(path, dispatcher);
        }
        return dispatcher;
    }

    public synchronized Map getRequestDispatcherMap() {
        return Collections.unmodifiableMap(this.requestDispatchers);
    }

    public synchronized void clearRequestDispatcherMap() {
        this.requestDispatchers.clear();
    }

    public synchronized void setRequestDispatcher(String path, RequestDispatcher dispatcher) {
        if (dispatcher instanceof MockRequestDispatcher) {
            ((MockRequestDispatcher)dispatcher).setPath(path);
        }
        this.requestDispatchers.put(path, dispatcher);
    }

    public synchronized ServletContext getContext(String url) {
        return (ServletContext)this.contexts.get(url);
    }

    public synchronized void setContext(String url, ServletContext context) {
        this.contexts.put(url, context);
    }

    public synchronized void clearInitParameters() {
        this.initParameters.clear();
    }

    public synchronized String getInitParameter(String name) {
        return (String)this.initParameters.get(name);
    }

    public synchronized boolean setInitParameter(String name, String value) {
        if (this.initParameters.containsKey(name)) {
            return false;
        }
        this.initParameters.put(name, value);
        return true;
    }

    public synchronized void setInitParameters(Map parameters) {
        this.initParameters.putAll(parameters);
    }

    public synchronized Enumeration getInitParameterNames() {
        return new Vector(this.initParameters.keySet()).elements();
    }

    public synchronized int getMajorVersion() {
        return this.majorVersion;
    }

    public synchronized void setMajorVersion(int majorVersion) {
        this.majorVersion = majorVersion;
    }

    public synchronized int getMinorVersion() {
        return this.minorVersion;
    }

    public synchronized void setMinorVersion(int minorVersion) {
        this.minorVersion = minorVersion;
    }

    public synchronized int getEffectiveMajorVersion() {
        return this.effectiveMajorVersion;
    }

    public synchronized void setEffectiveMajorVersion(int effectiveMajorVersion) {
        this.effectiveMajorVersion = effectiveMajorVersion;
    }

    public synchronized int getEffectiveMinorVersion() {
        return this.effectiveMinorVersion;
    }

    public synchronized void setEffectiveMinorVersion(int effectiveMinorVersion) {
        this.effectiveMinorVersion = effectiveMinorVersion;
    }

    public synchronized String getMimeType(String file) {
        return (String)this.mimeTypes.get(file);
    }

    public synchronized void setMimeType(String file, String type) {
        this.mimeTypes.put(file, type);
    }

    public synchronized String getRealPath(String path) {
        return (String)this.realPaths.get(path);
    }

    public synchronized void setRealPath(String path, String realPath) {
        this.realPaths.put(path, realPath);
    }

    public synchronized URL getResource(String path) throws MalformedURLException {
        return (URL)this.resources.get(path);
    }

    public synchronized void setResource(String path, URL url) {
        this.resources.put(path, url);
    }

    public synchronized InputStream getResourceAsStream(String path) {
        byte[] data = (byte[])this.resourceStreams.get(path);
        if (null == data) {
            return null;
        }
        return new ByteArrayInputStream(data);
    }

    public synchronized void setResourceAsStream(String path, InputStream inputStream) {
        this.setResourceAsStream(path, StreamUtil.getStreamAsByteArray((InputStream)inputStream));
    }

    public synchronized void setResourceAsStream(String path, byte[] data) {
        byte[] copy = (byte[])data.clone();
        this.resourceStreams.put(path, copy);
    }

    public synchronized Set getResourcePaths(String path) {
        Set set = (Set)this.resourcePaths.get(path);
        if (null == set) {
            return null;
        }
        return Collections.unmodifiableSet(set);
    }

    public synchronized void addResourcePaths(String path, Collection pathes) {
        HashSet set = (HashSet)this.resourcePaths.get(path);
        if (null == set) {
            set = new HashSet();
            this.resourcePaths.put(path, set);
        }
        set.addAll(pathes);
    }

    public synchronized void addResourcePath(String path, String resourcePath) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(resourcePath);
        this.addResourcePaths(path, list);
    }

    public synchronized String getServerInfo() {
        return "Mockrunner Server";
    }

    public synchronized Servlet getServlet(String arg0) throws ServletException {
        return null;
    }

    public synchronized String getServletContextName() {
        return this.servletContextName;
    }

    public synchronized void setServletContextName(String servletContextName) {
        this.servletContextName = servletContextName;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public synchronized Enumeration getServletNames() {
        return new Vector().elements();
    }

    public synchronized Enumeration getServlets() {
        return new Vector().elements();
    }

    public synchronized void log(Exception exc, String message) {
    }

    public synchronized void log(String message, Throwable exc) {
    }

    public synchronized void log(String message) {
    }

    private synchronized void handleAttributeListenerCalls(String key, Object value, Object oldValue) {
        if (null != oldValue) {
            if (value != null) {
                this.callAttributeListenersReplacedMethod(key, oldValue);
            } else {
                this.callAttributeListenersRemovedMethod(key, oldValue);
            }
        } else if (value != null) {
            this.callAttributeListenersAddedMethod(key, value);
        }
    }

    private synchronized void callAttributeListenersAddedMethod(String key, Object value) {
        for (Object anAttributeListener : this.attributeListener) {
            ServletContextAttributeEvent event = new ServletContextAttributeEvent((ServletContext)this, key, value);
            ((ServletContextAttributeListener)anAttributeListener).attributeAdded(event);
        }
    }

    private synchronized void callAttributeListenersReplacedMethod(String key, Object value) {
        for (Object anAttributeListener : this.attributeListener) {
            ServletContextAttributeEvent event = new ServletContextAttributeEvent((ServletContext)this, key, value);
            ((ServletContextAttributeListener)anAttributeListener).attributeReplaced(event);
        }
    }

    private synchronized void callAttributeListenersRemovedMethod(String key, Object value) {
        for (Object anAttributeListener : this.attributeListener) {
            ServletContextAttributeEvent event = new ServletContextAttributeEvent((ServletContext)this, key, value);
            ((ServletContextAttributeListener)anAttributeListener).attributeRemoved(event);
        }
    }
}

