/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.mock.web;

import com.mockrunner.base.NestedApplicationException;
import com.mockrunner.mock.web.MockHttpSession;
import com.mockrunner.mock.web.MockRequestDispatcher;
import com.mockrunner.mock.web.MockServletContext;
import com.mockrunner.mock.web.MockServletInputStream;
import com.mockrunner.util.common.CaseAwareMap;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.security.Principal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestAttributeEvent;
import javax.servlet.ServletRequestAttributeListener;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class MockHttpServletRequest
implements HttpServletRequest {
    private Map attributes;
    private Map parameters;
    private Vector locales;
    private Map requestDispatchers;
    private HttpSession session;
    private String method;
    private String authType;
    private Map headers;
    private String contextPath;
    private String pathInfo;
    private String pathTranslated;
    private String queryString;
    private StringBuffer requestUrl;
    private String requestUri;
    private String servletPath;
    private Principal principal;
    private String remoteUser;
    private boolean requestedSessionIdIsFromCookie;
    private String protocol;
    private String serverName;
    private int serverPort;
    private String scheme;
    private String remoteHost;
    private String remoteAddr;
    private Map roles;
    private String characterEncoding;
    private int contentLength;
    private String contentType;
    private List cookies;
    private MockServletInputStream bodyContent;
    private String localAddr;
    private String localName;
    private int localPort;
    private int remotePort;
    private boolean sessionCreated;
    private List attributeListener;
    private boolean isAsyncSupported;

    public MockHttpServletRequest() {
        this.resetAll();
    }

    public static MockHttpServletRequest getRequest(URI uri) {
        return MockHttpServletRequest.createRequest(uri).setMethod("GET");
    }

    public static MockHttpServletRequest postRequest(URI uri) {
        return MockHttpServletRequest.createRequest(uri).setMethod("POST");
    }

    public static MockHttpServletRequest postJsonRequest(URI uri) {
        String contentType = "application/json";
        String encoding = "UTF-8";
        try {
            return MockHttpServletRequest.createRequest(uri).setMethod("POST").setContentType("application/json").addCharacterEncoding("UTF-8").addHeader("Content-Type", "application/json").addHeader("Content-Transfer-Encoding", "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Failed to create POST JSON MockHttpServletRequest", e);
        }
    }

    public static MockHttpServletRequest createRequest(URI uri) {
        try {
            URL url = uri.toURL();
            return new MockHttpServletRequest().setProtocol(url.getProtocol()).setScheme(uri.getScheme()).setRequestURL(url.toString()).setRequestURI(uri.getPath()).setPathInfo(url.getPath());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Failed to create MockHttpServletRequest", e);
        }
    }

    public void resetAll() {
        this.attributes = new HashMap();
        this.parameters = new HashMap();
        this.locales = new Vector();
        this.requestDispatchers = new HashMap();
        this.method = "GET";
        this.headers = new CaseAwareMap();
        this.requestedSessionIdIsFromCookie = true;
        this.protocol = "HTTP/1.1";
        this.serverName = "localhost";
        this.serverPort = 8080;
        this.scheme = "http";
        this.remoteHost = "localhost";
        this.remoteAddr = "127.0.0.1";
        this.roles = new HashMap();
        this.contentLength = -1;
        this.cookies = null;
        this.localAddr = "127.0.0.1";
        this.localName = "localhost";
        this.localPort = 8080;
        this.remotePort = 5000;
        this.sessionCreated = false;
        this.attributeListener = new ArrayList();
        this.bodyContent = new MockServletInputStream(new byte[0]);
        this.isAsyncSupported = false;
    }

    public MockHttpServletRequest addAttributeListener(ServletRequestAttributeListener listener) {
        this.attributeListener.add(listener);
        return this;
    }

    public String getParameter(String key) {
        String[] values = this.getParameterValues(key);
        if (null != values && 0 < values.length) {
            return values[0];
        }
        return null;
    }

    public MockHttpServletRequest clearParameters() {
        this.parameters.clear();
        return this;
    }

    public String[] getParameterValues(String key) {
        return (String[])this.parameters.get(key);
    }

    public MockHttpServletRequest setupAddParameter(String key, String[] values) {
        this.parameters.put(key, values);
        return this;
    }

    public MockHttpServletRequest setupAddParameter(String key, String value) {
        this.setupAddParameter(key, new String[]{value});
        return this;
    }

    public Enumeration getParameterNames() {
        Vector parameterKeys = new Vector(this.parameters.keySet());
        return parameterKeys.elements();
    }

    public Map getParameterMap() {
        return Collections.unmodifiableMap(this.parameters);
    }

    public MockHttpServletRequest clearAttributes() {
        this.attributes.clear();
        return this;
    }

    public Object getAttribute(String key) {
        return this.attributes.get(key);
    }

    public Enumeration getAttributeNames() {
        Vector attKeys = new Vector(this.attributes.keySet());
        return attKeys.elements();
    }

    public void removeAttribute(String key) {
        Object value = this.attributes.get(key);
        this.attributes.remove(key);
        if (null != value) {
            this.callAttributeListenersRemovedMethod(key, value);
        }
    }

    public void setAttribute(String key, Object value) {
        Object oldValue = this.attributes.get(key);
        if (null == value) {
            this.attributes.remove(key);
        } else {
            this.attributes.put(key, value);
        }
        this.handleAttributeListenerCalls(key, value, oldValue);
    }

    public MockHttpServletRequest addAttribute(String key, Object value) {
        this.setAttribute(key, value);
        return this;
    }

    public HttpSession getSession() {
        return this.getSession(true);
    }

    public HttpSession getSession(boolean create) {
        if (!create && !this.sessionCreated) {
            return null;
        }
        if (create) {
            this.sessionCreated = true;
            if (this.session instanceof MockHttpSession && !((MockHttpSession)this.session).isValid()) {
                ((MockHttpSession)this.session).resetAll();
            }
        }
        return this.session;
    }

    public MockHttpServletRequest setSession(HttpSession session) {
        this.session = session;
        return this;
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        RequestDispatcher dispatcher = (RequestDispatcher)this.requestDispatchers.get(path);
        if (null == dispatcher) {
            dispatcher = new MockRequestDispatcher();
            this.setRequestDispatcher(path, dispatcher);
        }
        return dispatcher;
    }

    public Map getRequestDispatcherMap() {
        return Collections.unmodifiableMap(this.requestDispatchers);
    }

    public MockHttpServletRequest clearRequestDispatcherMap() {
        this.requestDispatchers.clear();
        return this;
    }

    public MockHttpServletRequest setRequestDispatcher(String path, RequestDispatcher dispatcher) {
        if (dispatcher instanceof MockRequestDispatcher) {
            ((MockRequestDispatcher)dispatcher).setPath(path);
        }
        this.requestDispatchers.put(path, dispatcher);
        return this;
    }

    public Locale getLocale() {
        if (this.locales.size() < 1) {
            return Locale.getDefault();
        }
        return (Locale)this.locales.get(0);
    }

    public Enumeration getLocales() {
        return this.locales.elements();
    }

    public MockHttpServletRequest addLocale(Locale locale) {
        this.locales.add(locale);
        return this;
    }

    public MockHttpServletRequest addLocales(List localeList) {
        this.locales.addAll(localeList);
        return this;
    }

    public String getMethod() {
        return this.method;
    }

    public MockHttpServletRequest setMethod(String method) {
        this.method = method;
        return this;
    }

    public String getAuthType() {
        return this.authType;
    }

    public MockHttpServletRequest setAuthType(String authType) {
        this.authType = authType;
        return this;
    }

    public long getDateHeader(String key) {
        String header = this.getHeader(key);
        if (null == header) {
            return -1L;
        }
        try {
            Date dateValue = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss z", Locale.US).parse(header);
            return dateValue.getTime();
        }
        catch (ParseException exc) {
            throw new IllegalArgumentException(exc.getMessage());
        }
    }

    public String getHeader(String key) {
        List headerList = (List)this.headers.get(key);
        if (null == headerList || 0 == headerList.size()) {
            return null;
        }
        return (String)headerList.get(0);
    }

    public Enumeration getHeaderNames() {
        return new Vector(this.headers.keySet()).elements();
    }

    public Enumeration getHeaders(String key) {
        List headerList = (List)this.headers.get(key);
        if (null == headerList) {
            return new Vector().elements();
        }
        return new Vector(headerList).elements();
    }

    public int getIntHeader(String key) {
        String header = this.getHeader(key);
        if (null == header) {
            return -1;
        }
        return new Integer(header);
    }

    public MockHttpServletRequest addHeader(String key, String value) {
        ArrayList<String> valueList = (ArrayList<String>)this.headers.get(key);
        if (null == valueList) {
            valueList = new ArrayList<String>();
            this.headers.put(key, valueList);
        }
        valueList.add(value);
        return this;
    }

    public void setHeader(String key, String value) {
        ArrayList<String> valueList = new ArrayList<String>();
        this.headers.put(key, valueList);
        valueList.add(value);
    }

    public MockHttpServletRequest clearHeaders() {
        this.headers.clear();
        return this;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public MockHttpServletRequest setContextPath(String contextPath) {
        this.contextPath = contextPath;
        return this;
    }

    public String getPathInfo() {
        return this.pathInfo;
    }

    public MockHttpServletRequest setPathInfo(String pathInfo) {
        this.pathInfo = pathInfo;
        return this;
    }

    public String getPathTranslated() {
        return this.pathTranslated;
    }

    public MockHttpServletRequest setPathTranslated(String pathTranslated) {
        this.pathTranslated = pathTranslated;
        return this;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public MockHttpServletRequest setQueryString(String queryString) {
        this.queryString = queryString;
        return this;
    }

    public String getRequestURI() {
        return this.requestUri;
    }

    public MockHttpServletRequest setRequestURI(String requestUri) {
        this.requestUri = requestUri;
        return this;
    }

    public StringBuffer getRequestURL() {
        return this.requestUrl;
    }

    public MockHttpServletRequest setRequestURL(String requestUrl) {
        this.requestUrl = new StringBuffer(requestUrl);
        return this;
    }

    public String getServletPath() {
        return this.servletPath;
    }

    public MockHttpServletRequest setServletPath(String servletPath) {
        this.servletPath = servletPath;
        return this;
    }

    public Principal getUserPrincipal() {
        return this.principal;
    }

    public MockHttpServletRequest setUserPrincipal(Principal principal) {
        this.principal = principal;
        return this;
    }

    public String getRemoteUser() {
        return this.remoteUser;
    }

    public MockHttpServletRequest setRemoteUser(String remoteUser) {
        this.remoteUser = remoteUser;
        return this;
    }

    public Cookie[] getCookies() {
        if (null == this.cookies) {
            return null;
        }
        return this.cookies.toArray(new Cookie[this.cookies.size()]);
    }

    public MockHttpServletRequest addCookie(Cookie cookie) {
        if (null == this.cookies) {
            this.cookies = new ArrayList();
        }
        this.cookies.add(cookie);
        return this;
    }

    public String getRequestedSessionId() {
        HttpSession session = this.getSession();
        if (null == session) {
            return null;
        }
        return session.getId();
    }

    public boolean isRequestedSessionIdFromCookie() {
        return this.requestedSessionIdIsFromCookie;
    }

    public boolean isRequestedSessionIdFromUrl() {
        return this.isRequestedSessionIdFromURL();
    }

    public boolean isRequestedSessionIdFromURL() {
        return !this.requestedSessionIdIsFromCookie;
    }

    public MockHttpServletRequest setRequestedSessionIdFromCookie(boolean requestedSessionIdIsFromCookie) {
        this.requestedSessionIdIsFromCookie = requestedSessionIdIsFromCookie;
        return this;
    }

    public boolean isRequestedSessionIdValid() {
        HttpSession session = this.getSession();
        return null != session;
    }

    public boolean isUserInRole(String role) {
        if (!this.roles.containsKey(role)) {
            return false;
        }
        return (Boolean)this.roles.get(role);
    }

    public MockHttpServletRequest setUserInRole(String role, boolean isInRole) {
        this.roles.put(role, isInRole);
        return this;
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public void setCharacterEncoding(String characterEncoding) throws UnsupportedEncodingException {
        this.characterEncoding = characterEncoding;
    }

    public MockHttpServletRequest addCharacterEncoding(String characterEncoding) throws UnsupportedEncodingException {
        this.setCharacterEncoding(characterEncoding);
        return this;
    }

    public int getContentLength() {
        return this.contentLength;
    }

    public MockHttpServletRequest setContentLength(int contentLength) {
        this.contentLength = contentLength;
        return this;
    }

    public String getContentType() {
        return this.contentType;
    }

    public MockHttpServletRequest setContentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public MockHttpServletRequest setProtocol(String protocol) {
        this.protocol = protocol;
        return this;
    }

    public String getServerName() {
        return this.serverName;
    }

    public MockHttpServletRequest setServerName(String serverName) {
        this.serverName = serverName;
        return this;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public MockHttpServletRequest setServerPort(int serverPort) {
        this.serverPort = serverPort;
        return this;
    }

    public String getScheme() {
        return this.scheme;
    }

    public MockHttpServletRequest setScheme(String scheme) {
        this.scheme = scheme;
        return this;
    }

    public String getRemoteAddr() {
        return this.remoteAddr;
    }

    public MockHttpServletRequest setRemoteAddr(String remoteAddr) {
        this.remoteAddr = remoteAddr;
        return this;
    }

    public String getRemoteHost() {
        return this.remoteHost;
    }

    public MockHttpServletRequest setRemoteHost(String remoteHost) {
        this.remoteHost = remoteHost;
        return this;
    }

    public BufferedReader getReader() throws IOException {
        return new BufferedReader(new InputStreamReader((InputStream)((Object)this.bodyContent)));
    }

    public ServletInputStream getInputStream() throws IOException {
        return this.bodyContent;
    }

    public MockHttpServletRequest setBodyContent(byte[] data) {
        this.bodyContent = new MockServletInputStream(data);
        return this;
    }

    public MockHttpServletRequest setBodyContent(String bodyContent) {
        String encoding = null == this.characterEncoding ? "ISO-8859-1" : this.characterEncoding;
        try {
            this.setBodyContent(bodyContent.getBytes(encoding));
        }
        catch (UnsupportedEncodingException exc) {
            throw new NestedApplicationException(exc);
        }
        return this;
    }

    public String getRealPath(String path) {
        HttpSession session = this.getSession();
        if (null == session) {
            return null;
        }
        return session.getServletContext().getRealPath(path);
    }

    public boolean isSecure() {
        String scheme = this.getScheme();
        if (null == scheme) {
            return false;
        }
        return scheme.equals("https");
    }

    public String getLocalAddr() {
        return this.localAddr;
    }

    public MockHttpServletRequest setLocalAddr(String localAddr) {
        this.localAddr = localAddr;
        return this;
    }

    public String getLocalName() {
        return this.localName;
    }

    public MockHttpServletRequest setLocalName(String localName) {
        this.localName = localName;
        return this;
    }

    public int getLocalPort() {
        return this.localPort;
    }

    public MockHttpServletRequest setLocalPort(int localPort) {
        this.localPort = localPort;
        return this;
    }

    public int getRemotePort() {
        return this.remotePort;
    }

    public MockHttpServletRequest setRemotePort(int remotePort) {
        this.remotePort = remotePort;
        return this;
    }

    public boolean isAsyncSupported() {
        return this.isAsyncSupported;
    }

    public MockHttpServletRequest setAsyncSupported(boolean isAsyncSupported) {
        this.isAsyncSupported = isAsyncSupported;
        return this;
    }

    private void handleAttributeListenerCalls(String key, Object value, Object oldValue) {
        if (null != oldValue) {
            if (value != null) {
                this.callAttributeListenersReplacedMethod(key, oldValue);
            } else {
                this.callAttributeListenersRemovedMethod(key, oldValue);
            }
        } else if (value != null) {
            this.callAttributeListenersAddedMethod(key, value);
        }
    }

    private void callAttributeListenersAddedMethod(String key, Object value) {
        for (Object anAttributeListener : this.attributeListener) {
            ServletRequestAttributeEvent event = new ServletRequestAttributeEvent(this.getServletContext(), (ServletRequest)this, key, value);
            ((ServletRequestAttributeListener)anAttributeListener).attributeAdded(event);
        }
    }

    private void callAttributeListenersReplacedMethod(String key, Object value) {
        for (Object anAttributeListener : this.attributeListener) {
            ServletRequestAttributeEvent event = new ServletRequestAttributeEvent(this.getServletContext(), (ServletRequest)this, key, value);
            ((ServletRequestAttributeListener)anAttributeListener).attributeReplaced(event);
        }
    }

    private void callAttributeListenersRemovedMethod(String key, Object value) {
        for (Object anAttributeListener : this.attributeListener) {
            ServletRequestAttributeEvent event = new ServletRequestAttributeEvent(this.getServletContext(), (ServletRequest)this, key, value);
            ((ServletRequestAttributeListener)anAttributeListener).attributeRemoved(event);
        }
    }

    private ServletContext getServletContext() {
        if (null == this.session) {
            return new MockServletContext();
        }
        return this.session.getServletContext();
    }
}

