/*
 * Decompiled with CFR 0.152.
 */
package com.mks.api.util;

import com.mks.api.CmdRunner;
import com.mks.api.Command;
import com.mks.api.IntegrationPoint;
import com.mks.api.IntegrationPointFactory;
import com.mks.api.Option;
import com.mks.api.Session;
import com.mks.api.response.APIError;
import com.mks.api.response.APIException;
import com.mks.api.response.ApplicationConnectionException;
import com.mks.api.response.Field;
import com.mks.api.response.InvalidHostException;
import com.mks.api.response.InvalidIntegrationPointException;
import com.mks.api.response.Item;
import com.mks.api.response.ItemList;
import com.mks.api.response.Response;
import com.mks.api.response.Result;
import com.mks.api.response.SubRoutine;
import com.mks.api.response.UnsupportedApplicationException;
import com.mks.api.response.WorkItem;
import com.mks.api.response.impl.CommandException;
import com.mks.api.response.impl.InvalidDirectiveException;
import com.mks.api.response.impl.InvalidValueException;
import com.mks.api.response.impl.ResponseWalker;
import com.mks.api.util.ResponseUtil;
import java.util.List;

public class GenericCommandHandler {
    private static final String IP_HOST = "--iphostname=";
    private static final String IP_PORT = "--ipport=";
    private static final String IP_LOCAL = "--iplocal";
    private static final String IP_AUTOSTART = "--ipautostart";
    private static final String IP_SECURE = "--ipsecure";
    private static final String NAMED_SESSION = "--namedsession";
    private static final String SESSION_USER = "--sessionuser=";
    private static final String SESSION_PASS = "--sessionpassword=";
    private static final String COMMAND_TYPE = "--commandtype=";
    private static final String RESPONSE_TYPE = "--responsetype=";
    private static final String DIRECTIVE = "--directive=";
    private static final String DEFAULT_HOST = "--defaulthostname=";
    private static final String DEFAULT_PORT = "--defaultport=";
    private static final String DEFAULT_USER = "--defaultuser=";
    private static final String DEFAULT_PASS = "--defaultpassword=";
    private static final String DEFAULT_IMP = "--defaultimpersonateduser=";
    private static final String SHOW_ALL_PROPS = "--showAllProperties=";
    private static final String OBJECT_CMD = "OBJECT";
    private static final String ARRAY_CMD = "ARRAY";
    private static final String NO_INTERIM = "NO_INTERIM";
    private static final String INTERIM_NO_CACHE = "INTERIM_NO_CACHE";
    private static final String INTERIM_CACHE = "INTERIM_CACHE";

    private static void printErrorMsg() {
        System.out.print("Invalid command.  Syntax: java GenericCommandHanlder <options> <Integrity CLI command>");
        System.out.println("where options are:");
        System.out.println("\t--iphostname=<hostname>");
        System.out.println("\t--ipport=<port>");
        System.out.println("\t--iplocal");
        System.out.println("\t--ipautostart (--iplocal must be specified)");
        System.out.println("\t--ipsecure (observed only if --iplocal is not specified)");
        System.out.println("\t--namedsession");
        System.out.println("\t--sessionuser=<username> (--namedsession must be specified)");
        System.out.println("\t--sessionpassword=<password> (--namedsession must be specified)");
        System.out.println("\t--responsetype=<NO_INTERIM | INTERIM_NO_CACHE | INTERIM_CACHE> (default: NO_INTERIM)");
        System.out.println("\t--commandtype=<OBJECT | ARRAY> (default: OBJECT)");
        System.out.println("\t--directive=<directives>");
        System.out.println("\t--defaulthostname=<hostname> (optional)");
        System.out.println("\t--defaultport=<port> (optional)");
        System.out.println("\t--defaultuser=<username> (optional)");
        System.out.println("\t--defaultpassword=<password> (optional)");
        System.out.println("\t--defaultimpersonateduser=<username> (optional)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void main(String[] args) {
        block96: {
            CmdRunner cr;
            block95: {
                int i;
                if (args.length < 4) {
                    GenericCommandHandler.printErrorMsg();
                    System.exit(1);
                }
                boolean ipIsLocal = false;
                boolean ipAutoStart = false;
                String ipHost = null;
                int ipPort = 0;
                boolean ipSecure = false;
                boolean commonSession = true;
                String sessionUser = null;
                String sessionPass = null;
                String defaultHost = null;
                int defaultPort = 0;
                String defaultUser = null;
                String defaultPass = null;
                String defaultImp = null;
                String directive = null;
                boolean useArray = false;
                boolean useInterim = false;
                boolean cacheInterim = false;
                for (i = 0; i < args.length && args[i].startsWith("--"); ++i) {
                    String t;
                    if (args[i].startsWith(IP_HOST)) {
                        ipHost = args[i].substring(args[i].indexOf(61) + 1);
                        continue;
                    }
                    if (args[i].startsWith(IP_PORT)) {
                        t = args[i].substring(args[i].indexOf(61) + 1);
                        ipPort = Integer.parseInt(t);
                        continue;
                    }
                    if (args[i].startsWith(IP_LOCAL)) {
                        ipIsLocal = true;
                        continue;
                    }
                    if (args[i].startsWith(IP_AUTOSTART)) {
                        ipAutoStart = true;
                        continue;
                    }
                    if (args[i].startsWith(IP_SECURE)) {
                        ipSecure = true;
                        continue;
                    }
                    if (args[i].startsWith(NAMED_SESSION)) {
                        commonSession = false;
                        continue;
                    }
                    if (args[i].startsWith(SESSION_USER)) {
                        sessionUser = args[i].substring(args[i].indexOf(61) + 1);
                        continue;
                    }
                    if (args[i].startsWith(SESSION_PASS)) {
                        sessionPass = args[i].substring(args[i].indexOf(61) + 1);
                        continue;
                    }
                    if (args[i].startsWith(DEFAULT_HOST)) {
                        defaultHost = args[i].substring(args[i].indexOf(61) + 1);
                        continue;
                    }
                    if (args[i].startsWith(DEFAULT_PORT)) {
                        t = args[i].substring(args[i].indexOf(61) + 1);
                        defaultPort = Integer.parseInt(t);
                        continue;
                    }
                    if (args[i].startsWith(DEFAULT_USER)) {
                        defaultUser = args[i].substring(args[i].indexOf(61) + 1);
                        continue;
                    }
                    if (args[i].startsWith(DEFAULT_PASS)) {
                        defaultPass = args[i].substring(args[i].indexOf(61) + 1);
                        continue;
                    }
                    if (args[i].startsWith(DEFAULT_IMP)) {
                        defaultImp = args[i].substring(args[i].indexOf(61) + 1);
                        continue;
                    }
                    if (args[i].startsWith(COMMAND_TYPE)) {
                        t = args[i].substring(args[i].indexOf(61) + 1);
                        if (t.equals(ARRAY_CMD)) {
                            useArray = true;
                            continue;
                        }
                        useArray = false;
                        continue;
                    }
                    if (args[i].startsWith(RESPONSE_TYPE)) {
                        t = args[i].substring(args[i].indexOf(61) + 1);
                        if (t.equals(INTERIM_NO_CACHE)) {
                            useInterim = true;
                            cacheInterim = false;
                            continue;
                        }
                        if (t.equals(INTERIM_CACHE)) {
                            useInterim = true;
                            cacheInterim = true;
                            continue;
                        }
                        useInterim = false;
                        cacheInterim = false;
                        continue;
                    }
                    if (args[i].startsWith(DIRECTIVE)) {
                        directive = args[i].substring(args[i].indexOf(61) + 1);
                        continue;
                    }
                    if (args[i].startsWith(SHOW_ALL_PROPS)) {
                        System.setProperty("com.mks.api.response.showAllProperties", args[i].substring(args[i].indexOf(61) + 1));
                        continue;
                    }
                    System.out.println("Ignoring unknown option: " + args[i]);
                }
                if (args.length - i < 2) {
                    GenericCommandHandler.printErrorMsg();
                    System.exit(1);
                }
                String[] cmdArr = null;
                Command cmd = null;
                if (useArray) {
                    cmdArr = new String[args.length - i];
                    System.arraycopy(args, i, cmdArr, 0, cmdArr.length);
                } else {
                    cmd = new Command(args[i], args[++i]);
                    ++i;
                    while (i < args.length) {
                        int idx;
                        if (args[i].startsWith("--")) {
                            idx = args[i].indexOf(61);
                            cmd.addOption(new Option(args[i].substring(2, idx), args[i].substring(idx + 1)));
                        } else if (args[i].startsWith("-")) {
                            idx = args[i].indexOf(32);
                            if (idx < 0) {
                                cmd.addOption(new Option(args[i].substring(1)));
                            } else {
                                cmd.addOption(new Option(args[i].substring(1, idx), args[i].substring(idx + 1)));
                            }
                        } else {
                            cmd.addSelection(args[i]);
                        }
                        ++i;
                    }
                }
                cr = null;
                IntegrationPointFactory ipf = IntegrationPointFactory.getInstance();
                ipf.getLogger().configure("API", 3, 10);
                IntegrationPoint ip = null;
                if (ipIsLocal) {
                    ip = ipf.createLocalIntegrationPoint(0, 0);
                    ip.setAutoStartIntegrityClient(ipAutoStart);
                } else {
                    ip = ipf.createIntegrationPoint(ipHost, ipPort, ipSecure, 0, 0);
                }
                Session session = null;
                session = commonSession ? ip.getCommonSession() : ip.createSession(sessionUser, sessionPass);
                cr = session.createCmdRunner();
                cr.setDefaultHostname(defaultHost);
                cr.setDefaultPort(defaultPort);
                cr.setDefaultUsername(defaultUser);
                cr.setDefaultPassword(defaultPass);
                cr.setDefaultImpersonationUser(defaultImp);
                Response response = null;
                response = useArray ? (useInterim ? cr.executeWithInterim(cmdArr, cacheInterim) : cr.execute(cmdArr)) : (useInterim ? cr.executeWithInterim(cmd, cacheInterim) : cr.execute(cmd));
                ResponseWalker responseWalker = new ResponseWalker(response);
                if (directive == null) {
                    directive = "response";
                }
                responseWalker.walk(directive);
                Object objectVal = responseWalker.getCurrentObject();
                System.setProperty("com.mks.api.util.internal.TestHarnessOutput", "true");
                if (objectVal instanceof Response) {
                    ResponseUtil.printResponse((Response)objectVal, 1, System.out);
                    break block95;
                }
                if (objectVal instanceof Field) {
                    ResponseUtil.printField((Field)objectVal, 1, System.out);
                    break block95;
                }
                if (objectVal instanceof Result) {
                    ResponseUtil.printResult((Result)objectVal, 1, System.out);
                    break block95;
                }
                if (objectVal instanceof List) {
                    ResponseUtil.printList((List)objectVal, 1, System.out);
                    break block95;
                }
                if (objectVal instanceof ItemList) {
                    ResponseUtil.printItemList((ItemList)objectVal, 1, System.out);
                    break block95;
                }
                if (objectVal instanceof Item) {
                    ResponseUtil.printItem((Item)objectVal, 1, System.out);
                    break block95;
                }
                if (objectVal instanceof SubRoutine) {
                    ResponseUtil.printSubRoutine((SubRoutine)objectVal, 1, System.out);
                    break block95;
                }
                if (objectVal instanceof WorkItem) {
                    ResponseUtil.printWorkItem((WorkItem)objectVal, 1, System.out);
                    break block95;
                }
                System.out.println("List Value:");
                System.out.println(objectVal);
            }
            Object var29_40 = null;
            Session uas = cr == null ? null : cr.getSession();
            try {
                if (cr != null) {
                    cr.release();
                }
                if (uas != null) {
                    uas.release();
                }
                break block96;
            }
            catch (Exception ex2) {}
            break block96;
            {
                catch (UnsupportedApplicationException ex) {
                    ResponseUtil.printAPIException("UnsupportedApplicationException:", (APIException)ex, 0, System.out);
                    Object var29_41 = null;
                    uas = cr == null ? null : cr.getSession();
                    try {
                        if (cr != null) {
                            cr.release();
                        }
                        if (uas != null) {
                            uas.release();
                        }
                        break block96;
                    }
                    catch (Exception ex2) {}
                    break block96;
                }
                catch (ApplicationConnectionException ex) {
                    ResponseUtil.printAPIException("ApplicationConnectionException:", (APIException)ex, 0, System.out);
                    Object var29_42 = null;
                    uas = cr == null ? null : cr.getSession();
                    try {
                        if (cr != null) {
                            cr.release();
                        }
                        if (uas != null) {
                            uas.release();
                        }
                        break block96;
                    }
                    catch (Exception ex2) {}
                    break block96;
                }
                catch (InvalidHostException ex) {
                    ResponseUtil.printAPIException("InvalidHostException:", (APIException)ex, 0, System.out);
                    Object var29_43 = null;
                    uas = cr == null ? null : cr.getSession();
                    try {
                        if (cr != null) {
                            cr.release();
                        }
                        if (uas != null) {
                            uas.release();
                        }
                        break block96;
                    }
                    catch (Exception ex2) {}
                    break block96;
                }
                catch (InvalidIntegrationPointException ex) {
                    ResponseUtil.printAPIException("InvalidIntegrationPointException:", (APIException)ex, 0, System.out);
                    Object var29_44 = null;
                    uas = cr == null ? null : cr.getSession();
                    try {
                        if (cr != null) {
                            cr.release();
                        }
                        if (uas != null) {
                            uas.release();
                        }
                        break block96;
                    }
                    catch (Exception ex2) {}
                    break block96;
                }
                catch (APIException ex) {
                    Response res = ex.getResponse();
                    if (res != null) {
                        ResponseUtil.printResponse(res, 0, System.out);
                    } else {
                        ResponseUtil.printAPIException(ex, 0, System.out);
                    }
                    Object var29_45 = null;
                    uas = cr == null ? null : cr.getSession();
                    try {
                        if (cr != null) {
                            cr.release();
                        }
                        if (uas != null) {
                            uas.release();
                        }
                        break block96;
                    }
                    catch (Exception ex2) {}
                    break block96;
                }
                catch (InvalidDirectiveException ex) {
                    System.out.println("ERROR: Directive given is invalid.");
                    System.out.println(ex.getMessage());
                    Object var29_46 = null;
                    uas = cr == null ? null : cr.getSession();
                    try {
                        if (cr != null) {
                            cr.release();
                        }
                        if (uas != null) {
                            uas.release();
                        }
                        break block96;
                    }
                    catch (Exception ex2) {}
                    break block96;
                }
                catch (InvalidValueException ex) {
                    System.out.println("InvalidValueException:");
                    System.out.println(ex.getMessage());
                    Object var29_47 = null;
                    uas = cr == null ? null : cr.getSession();
                    try {
                        if (cr != null) {
                            cr.release();
                        }
                        if (uas != null) {
                            uas.release();
                        }
                        break block96;
                    }
                    catch (Exception ex2) {}
                    break block96;
                }
                catch (CommandException ex) {
                    ex.printStackTrace(System.err);
                    Object var29_48 = null;
                    uas = cr == null ? null : cr.getSession();
                    try {
                        if (cr != null) {
                            cr.release();
                        }
                        if (uas != null) {
                            uas.release();
                        }
                        break block96;
                    }
                    catch (Exception ex2) {}
                    break block96;
                }
                catch (Exception ex) {
                    System.out.println(ex.getClass());
                    System.out.println(ex.getMessage());
                    ex.printStackTrace(System.err);
                    Object var29_49 = null;
                    uas = cr == null ? null : cr.getSession();
                    try {
                        if (cr != null) {
                            cr.release();
                        }
                        if (uas != null) {
                            uas.release();
                        }
                        break block96;
                    }
                    catch (Exception ex2) {}
                    break block96;
                }
                catch (APIError err) {
                    System.out.println("APIError:");
                    System.out.println(err.getClass());
                    System.out.println(err.getMessage());
                    Object var29_50 = null;
                    uas = cr == null ? null : cr.getSession();
                    try {
                        if (cr != null) {
                            cr.release();
                        }
                        if (uas != null) {
                            uas.release();
                        }
                        break block96;
                    }
                    catch (Exception ex2) {}
                }
            }
            catch (Throwable throwable) {
                Object var29_51 = null;
                uas = cr == null ? null : cr.getSession();
                try {
                    if (cr != null) {
                        cr.release();
                    }
                    if (uas != null) {
                        uas.release();
                    }
                }
                catch (Exception ex2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }
}

