/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.providers.oauth2;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.fragment.app.FragmentActivity;
import com.microsoft.identity.common.internal.providers.oauth2.AuthorizationFragment;
import com.microsoft.identity.common.internal.telemetry.Telemetry;
import com.microsoft.identity.common.internal.telemetry.events.UiEndEvent;
import com.microsoft.identity.common.java.exception.BaseException;
import com.microsoft.identity.common.java.exception.ClientException;
import com.microsoft.identity.common.java.providers.RawAuthorizationResult;
import com.microsoft.identity.common.java.telemetry.events.BaseEvent;
import com.microsoft.identity.common.java.util.StringUtil;
import com.microsoft.identity.common.java.util.UrlUtil;
import com.microsoft.identity.common.logging.Logger;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.net.URI;
import java.util.Map;

public class BrowserAuthorizationFragment
extends AuthorizationFragment {
    private static final String TAG = BrowserAuthorizationFragment.class.getSimpleName();
    @VisibleForTesting
    private static final String BROWSER_FLOW_STARTED = "browserFlowStarted";
    private static Class<?> sCallingActivityClass;
    private static String sCustomTabResponseUri;
    private boolean mBrowserFlowStarted = false;
    private Intent mAuthIntent;

    @Nullable
    public static Intent createCustomTabResponseIntent(Context context, String responseUri) {
        String methodTag = TAG + ":createCustomTabResponseIntent";
        if (sCallingActivityClass == null) {
            Logger.warn(methodTag, "Calling activity class is NULL. Unable to create intent for response.");
            return null;
        }
        sCustomTabResponseUri = responseUri;
        Intent intent = new Intent(context, sCallingActivityClass);
        intent.addFlags(0x24000000);
        return intent;
    }

    @Override
    @SuppressFBWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"})
    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        FragmentActivity activity = this.getActivity();
        if (activity != null) {
            sCallingActivityClass = activity.getClass();
        }
    }

    public void onSaveInstanceState(@NonNull Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putParcelable("com.microsoft.identity.auth.intent", (Parcelable)this.mAuthIntent);
        outState.putBoolean(BROWSER_FLOW_STARTED, this.mBrowserFlowStarted);
    }

    @Override
    void extractState(@NonNull Bundle state) {
        super.extractState(state);
        this.mAuthIntent = (Intent)state.getParcelable("com.microsoft.identity.auth.intent");
        this.mBrowserFlowStarted = state.getBoolean(BROWSER_FLOW_STARTED, false);
    }

    @SuppressFBWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"})
    public void onResume() {
        super.onResume();
        if (!this.mBrowserFlowStarted) {
            this.mBrowserFlowStarted = true;
            if (this.mAuthIntent != null) {
                this.startActivity(this.mAuthIntent);
            } else {
                this.sendResult(RawAuthorizationResult.fromException((BaseException)new ClientException("Authorization intent is null.")));
                this.finish();
            }
        } else {
            if (!StringUtil.isNullOrEmpty((String)sCustomTabResponseUri)) {
                this.completeAuthorizationInBrowserFlow(sCustomTabResponseUri);
            } else {
                this.cancelAuthorization(true);
            }
            sCustomTabResponseUri = null;
        }
    }

    private void completeAuthorizationInBrowserFlow(@NonNull String customTabResponseUri) {
        String methodTag = TAG + ":completeAuthorizationInBrowserFlow";
        Logger.info(methodTag, null, "Received redirect from customTab/browser.");
        RawAuthorizationResult data = RawAuthorizationResult.fromRedirectUri((String)customTabResponseUri);
        switch (data.getResultCode()) {
            case BROKER_INSTALLATION_TRIGGERED: {
                Map urlQueryParameters = UrlUtil.getParameters((URI)data.getAuthorizationFinalUri());
                String appLink = (String)urlQueryParameters.get("app_link");
                Intent browserIntent = new Intent("android.intent.action.VIEW", Uri.parse((String)appLink));
                this.startActivity(browserIntent);
                break;
            }
            case COMPLETED: {
                Telemetry.emit((BaseEvent)new UiEndEvent().isUiComplete());
                break;
            }
            case CANCELLED: {
                Telemetry.emit((BaseEvent)new UiEndEvent().isUserCancelled());
                break;
            }
        }
        this.sendResult(data);
        this.finish();
    }
}

