/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.platform;

import android.os.Build;
import com.microsoft.identity.common.java.platform.AbstractDeviceMetadata;
import lombok.NonNull;

public class AndroidDeviceMetadata
extends AbstractDeviceMetadata {
    private static final String ANDROID_DEVICE_TYPE = "Android";

    @NonNull
    public String getDeviceType() {
        return ANDROID_DEVICE_TYPE;
    }

    @NonNull
    public String getCpu() {
        if (Build.VERSION.SDK_INT < 21) {
            return Build.CPU_ABI;
        }
        String[] supportedABIs = Build.SUPPORTED_ABIS;
        if (supportedABIs != null && supportedABIs.length > 0) {
            return supportedABIs[0];
        }
        return "UNKNOWN";
    }

    @NonNull
    public String getOsForEsts() {
        return String.valueOf(Build.VERSION.SDK_INT);
    }

    @NonNull
    public String getOsForMats() {
        return Build.VERSION.RELEASE;
    }

    @NonNull
    public String getOsForDrs() {
        return Build.VERSION.RELEASE;
    }

    @NonNull
    public String getDeviceModel() {
        return Build.MODEL;
    }

    @NonNull
    public String getManufacturer() {
        return Build.MANUFACTURER;
    }
}

