/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.ui.webview.challengehandlers;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import com.microsoft.identity.common.internal.telemetry.Telemetry;
import com.microsoft.identity.common.internal.ui.webview.challengehandlers.AbstractSmartcardCertBasedAuthManager;
import com.microsoft.identity.common.internal.ui.webview.challengehandlers.YubiKitSmartcardSession;
import com.microsoft.identity.common.java.telemetry.events.BaseEvent;
import com.microsoft.identity.common.java.telemetry.events.PivProviderStatusEvent;
import com.microsoft.identity.common.logging.Logger;
import com.yubico.yubikit.android.YubiKitManager;
import com.yubico.yubikit.android.transport.usb.UsbConfiguration;
import com.yubico.yubikit.android.transport.usb.UsbYubiKeyDevice;
import com.yubico.yubikit.android.transport.usb.connection.UsbSmartCardConnection;
import com.yubico.yubikit.core.smartcard.SmartCardConnection;
import com.yubico.yubikit.core.util.Callback;
import com.yubico.yubikit.core.util.Result;
import com.yubico.yubikit.piv.PivSession;
import com.yubico.yubikit.piv.jca.PivProvider;
import java.io.IOException;
import java.security.Provider;
import java.security.Security;
import java.util.concurrent.Callable;

public class YubiKitCertBasedAuthManager
extends AbstractSmartcardCertBasedAuthManager {
    private static final String TAG = YubiKitCertBasedAuthManager.class.getSimpleName();
    private static final String MDEVICE_NULL_ERROR_MESSAGE = "Instance UsbYubiKitDevice variable (mDevice) is null.";
    private static final String YUBIKEY_PROVIDER = "YKPiv";
    private final YubiKitManager mYubiKitManager;
    private UsbYubiKeyDevice mDevice;
    private static final Object sDeviceLock = new Object();

    public YubiKitCertBasedAuthManager(@NonNull Context context) {
        if (context.getSystemService("usb") != null) {
            this.mYubiKitManager = new YubiKitManager(context);
        } else {
            this.mYubiKitManager = null;
            Logger.info(TAG, "Certificate Based Authentication via YubiKey not enabled due to device not supporting USB_SERVICE.");
        }
    }

    @Override
    public void startDiscovery() {
        String methodTag = TAG + ":startDiscovery";
        if (this.mYubiKitManager == null) {
            Logger.info(methodTag, "Discovery for Certificate Based Authentication via YubiKey not started.");
            return;
        }
        this.mYubiKitManager.startUsbDiscovery(new UsbConfiguration(), (Callback)new Callback<UsbYubiKeyDevice>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void invoke(@NonNull UsbYubiKeyDevice device) {
                Logger.verbose(TAG, "A YubiKey device was connected");
                Object object = sDeviceLock;
                synchronized (object) {
                    YubiKitCertBasedAuthManager.this.mDevice = device;
                    if (YubiKitCertBasedAuthManager.this.mConnectionCallback != null) {
                        YubiKitCertBasedAuthManager.this.mConnectionCallback.onCreateConnection();
                    }
                    YubiKitCertBasedAuthManager.this.mDevice.setOnClosed(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            Logger.verbose(TAG, "A YubiKey device was disconnected");
                            Object object = sDeviceLock;
                            synchronized (object) {
                                YubiKitCertBasedAuthManager.this.mDevice = null;
                            }
                            PivProviderStatusEvent pivProviderStatusEvent = new PivProviderStatusEvent();
                            if (Security.getProvider(YubiKitCertBasedAuthManager.YUBIKEY_PROVIDER) != null) {
                                Security.removeProvider(YubiKitCertBasedAuthManager.YUBIKEY_PROVIDER);
                                Telemetry.emit((BaseEvent)pivProviderStatusEvent.putPivProviderRemoved(true));
                                Logger.info(TAG, "An instance of PivProvider was removed from Security static list upon YubiKey device connection being closed.");
                            } else {
                                Telemetry.emit((BaseEvent)pivProviderStatusEvent.putPivProviderRemoved(false));
                                Logger.info(TAG, "An instance of PivProvider was not present in Security static list upon YubiKey device connection being closed.");
                            }
                            if (YubiKitCertBasedAuthManager.this.mConnectionCallback != null) {
                                YubiKitCertBasedAuthManager.this.mConnectionCallback.onClosedConnection();
                            }
                        }
                    });
                }
            }
        });
    }

    @Override
    public void stopDiscovery() {
        String methodTag = TAG + ":stopDiscovery";
        if (this.mYubiKitManager == null) {
            Logger.info(methodTag, "Stop discovery for Certificate Based Authentication via YubiKey not performed.");
            return;
        }
        this.mYubiKitManager.stopUsbDiscovery();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void requestDeviceSession(final @NonNull AbstractSmartcardCertBasedAuthManager.ISessionCallback callback) {
        String methodTag = TAG + "requestDeviceSession:";
        Object object = sDeviceLock;
        synchronized (object) {
            if (this.mDevice == null) {
                Logger.error(methodTag, MDEVICE_NULL_ERROR_MESSAGE, null);
                callback.onException(new Exception());
            }
            this.mDevice.requestConnection(UsbSmartCardConnection.class, (Callback)new Callback<Result<UsbSmartCardConnection, IOException>>(){

                public void invoke(@NonNull Result<UsbSmartCardConnection, IOException> value) {
                    try {
                        SmartCardConnection c = (SmartCardConnection)value.getValue();
                        PivSession piv = new PivSession(c);
                        YubiKitSmartcardSession session = new YubiKitSmartcardSession(piv);
                        callback.onGetSession(session);
                    }
                    catch (Exception e) {
                        callback.onException(e);
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDeviceConnected() {
        Object object = sDeviceLock;
        synchronized (object) {
            return this.mDevice != null;
        }
    }

    @Override
    public void initBeforeProceedingWithRequest() {
        String methodTag = TAG + ":initBeforeProceedingWithRequest";
        PivProviderStatusEvent pivProviderStatusEvent = new PivProviderStatusEvent();
        if (Security.getProvider(YUBIKEY_PROVIDER) != null) {
            Security.removeProvider(YUBIKEY_PROVIDER);
            Telemetry.emit((BaseEvent)pivProviderStatusEvent.putIsExistingPivProviderPresent(true));
            Logger.info(methodTag, "Existing PivProvider was present in Security static list.");
        } else {
            Telemetry.emit((BaseEvent)pivProviderStatusEvent.putIsExistingPivProviderPresent(false));
            Logger.info(methodTag, "Security static list does not have existing PivProvider.");
        }
        Security.insertProviderAt((Provider)new PivProvider(this.getPivProviderCallback()), 1);
        Logger.info(methodTag, "An instance of PivProvider was added to Security static list.");
    }

    @Override
    public void onDestroy() {
        this.stopDiscovery();
    }

    private Callback<Callback<Result<PivSession, Exception>>> getPivProviderCallback() {
        final String methodTag = TAG + "getPivProviderCallback:";
        return new Callback<Callback<Result<PivSession, Exception>>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @RequiresApi(api=21)
            public void invoke(final @NonNull Callback<Result<PivSession, Exception>> callback) {
                Object object = sDeviceLock;
                synchronized (object) {
                    if (YubiKitCertBasedAuthManager.this.mDevice == null) {
                        Logger.error(methodTag, YubiKitCertBasedAuthManager.MDEVICE_NULL_ERROR_MESSAGE, null);
                        callback.invoke((Object)Result.failure((Throwable)new Exception(YubiKitCertBasedAuthManager.MDEVICE_NULL_ERROR_MESSAGE)));
                        return;
                    }
                    YubiKitCertBasedAuthManager.this.mDevice.requestConnection(UsbSmartCardConnection.class, (Callback)new Callback<Result<UsbSmartCardConnection, IOException>>(){

                        public void invoke(final @NonNull Result<UsbSmartCardConnection, IOException> value) {
                            callback.invoke((Object)Result.of((Callable)new Callable<PivSession>(){

                                @Override
                                public PivSession call() throws Exception {
                                    return new PivSession((SmartCardConnection)value.getValue());
                                }
                            }));
                        }
                    });
                }
            }
        };
    }
}

