/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.ui.webview.challengehandlers;

import android.app.Activity;
import android.content.Context;
import android.security.KeyChain;
import android.security.KeyChainAliasCallback;
import android.security.KeyChainException;
import android.webkit.ClientCertRequest;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import com.microsoft.identity.common.internal.telemetry.Telemetry;
import com.microsoft.identity.common.internal.ui.webview.challengehandlers.ICertBasedAuthChallengeHandler;
import com.microsoft.identity.common.java.exception.BaseException;
import com.microsoft.identity.common.java.providers.RawAuthorizationResult;
import com.microsoft.identity.common.java.telemetry.events.BaseEvent;
import com.microsoft.identity.common.java.telemetry.events.CertBasedAuthResultEvent;
import com.microsoft.identity.common.java.telemetry.events.ErrorEvent;
import com.microsoft.identity.common.logging.Logger;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;

public class OnDeviceCertBasedAuthChallengeHandler
implements ICertBasedAuthChallengeHandler {
    private static final String TAG = OnDeviceCertBasedAuthChallengeHandler.class.getSimpleName();
    private static final String ACCEPTABLE_ISSUER = "CN=MS-Organization-Access";
    private final Activity mActivity;
    private boolean mIsOnDeviceCertBasedAuthProceeding;

    public OnDeviceCertBasedAuthChallengeHandler(@NonNull Activity activity) {
        this.mActivity = activity;
        this.mIsOnDeviceCertBasedAuthProceeding = false;
    }

    @Override
    @RequiresApi(api=21)
    public Void processChallenge(final ClientCertRequest request) {
        final String methodTag = TAG + ":processChallenge";
        Principal[] acceptableCertIssuers = request.getPrincipals();
        if (acceptableCertIssuers != null) {
            for (Principal issuer : acceptableCertIssuers) {
                if (!issuer.getName().contains(ACCEPTABLE_ISSUER)) continue;
                Logger.info(methodTag, "Cancelling the TLS request, not respond to TLS challenge triggered by device authentication.");
                request.cancel();
                return null;
            }
        }
        KeyChain.choosePrivateKeyAlias((Activity)this.mActivity, (KeyChainAliasCallback)new KeyChainAliasCallback(){

            public void alias(String alias) {
                if (alias == null) {
                    Logger.info(methodTag, "No certificate chosen by user, cancelling the TLS request.");
                    request.cancel();
                    return;
                }
                try {
                    X509Certificate[] certChain = KeyChain.getCertificateChain((Context)OnDeviceCertBasedAuthChallengeHandler.this.mActivity.getApplicationContext(), (String)alias);
                    PrivateKey privateKey = KeyChain.getPrivateKey((Context)OnDeviceCertBasedAuthChallengeHandler.this.mActivity, (String)alias);
                    Logger.info(methodTag, "Certificate is chosen by user, proceed with TLS request.");
                    OnDeviceCertBasedAuthChallengeHandler.this.mIsOnDeviceCertBasedAuthProceeding = true;
                    request.proceed(privateKey, certChain);
                    return;
                }
                catch (KeyChainException e) {
                    Logger.errorPII(methodTag, "KeyChain exception", e);
                }
                catch (InterruptedException e) {
                    Logger.errorPII(methodTag, "InterruptedException exception", e);
                }
                request.cancel();
            }
        }, (String[])request.getKeyTypes(), (Principal[])request.getPrincipals(), (String)request.getHost(), (int)request.getPort(), null);
        return null;
    }

    @Override
    public void emitTelemetryForCertBasedAuthResults(@NonNull RawAuthorizationResult response) {
        if (this.mIsOnDeviceCertBasedAuthProceeding) {
            CertBasedAuthResultEvent certBasedAuthResultEvent = new CertBasedAuthResultEvent("cert_based_auth_result_on_device_event");
            this.mIsOnDeviceCertBasedAuthProceeding = false;
            Telemetry.emit((BaseEvent)certBasedAuthResultEvent.putResponseCode(response.getResultCode().toString()));
            BaseException exception = response.getException();
            if (exception != null) {
                Telemetry.emit((BaseEvent)new ErrorEvent().putException((Exception)exception));
            }
        }
    }

    @Override
    public void cleanUp() {
    }
}

