/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.ui.webview.challengehandlers;

import android.webkit.ClientCertRequest;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import com.microsoft.identity.common.R;
import com.microsoft.identity.common.internal.telemetry.Telemetry;
import com.microsoft.identity.common.internal.ui.webview.challengehandlers.AbstractSmartcardCertBasedAuthManager;
import com.microsoft.identity.common.internal.ui.webview.challengehandlers.DialogHolder;
import com.microsoft.identity.common.internal.ui.webview.challengehandlers.ICertBasedAuthChallengeHandler;
import com.microsoft.identity.common.internal.ui.webview.challengehandlers.ICertDetails;
import com.microsoft.identity.common.internal.ui.webview.challengehandlers.ISmartcardSession;
import com.microsoft.identity.common.internal.ui.webview.challengehandlers.SmartcardCertPickerDialog;
import com.microsoft.identity.common.internal.ui.webview.challengehandlers.SmartcardPinDialog;
import com.microsoft.identity.common.java.exception.BaseException;
import com.microsoft.identity.common.java.providers.RawAuthorizationResult;
import com.microsoft.identity.common.java.telemetry.events.BaseEvent;
import com.microsoft.identity.common.java.telemetry.events.CertBasedAuthResultEvent;
import com.microsoft.identity.common.java.telemetry.events.ErrorEvent;
import com.microsoft.identity.common.logging.Logger;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.List;

public class SmartcardCertBasedAuthChallengeHandler
implements ICertBasedAuthChallengeHandler {
    private static final String TAG = SmartcardCertBasedAuthChallengeHandler.class.getSimpleName();
    protected final AbstractSmartcardCertBasedAuthManager mSmartcardCertBasedAuthManager;
    private final DialogHolder mDialogHolder;
    private boolean mIsSmartcardCertBasedAuthProceeding;

    public SmartcardCertBasedAuthChallengeHandler(@NonNull AbstractSmartcardCertBasedAuthManager smartcardCertBasedAuthManager, @NonNull DialogHolder dialogHolder) {
        final String methodTag = TAG + ":SmartcardCertBasedAuthChallengeHandler";
        this.mIsSmartcardCertBasedAuthProceeding = false;
        this.mSmartcardCertBasedAuthManager = smartcardCertBasedAuthManager;
        this.mDialogHolder = dialogHolder;
        this.mSmartcardCertBasedAuthManager.setConnectionCallback(new AbstractSmartcardCertBasedAuthManager.IConnectionCallback(){

            @Override
            public void onCreateConnection() {
                SmartcardCertBasedAuthChallengeHandler.this.mDialogHolder.dismissDialog();
            }

            @Override
            public void onClosedConnection() {
                if (SmartcardCertBasedAuthChallengeHandler.this.mDialogHolder.isDialogShowing()) {
                    SmartcardCertBasedAuthChallengeHandler.this.mDialogHolder.onCancelCba();
                    SmartcardCertBasedAuthChallengeHandler.this.mDialogHolder.showErrorDialog(R.string.smartcard_early_unplug_dialog_title, R.string.smartcard_early_unplug_dialog_message);
                    Logger.verbose(methodTag, "Smartcard was disconnected while dialog was still displayed.");
                }
            }
        });
    }

    @Override
    @RequiresApi(api=21)
    public Void processChallenge(final ClientCertRequest request) {
        final String methodTag = TAG + ":processChallenge";
        this.mSmartcardCertBasedAuthManager.requestDeviceSession(new AbstractSmartcardCertBasedAuthManager.ISessionCallback(){

            @Override
            public void onGetSession(@NonNull ISmartcardSession session) throws Exception {
                if (session.getPinAttemptsRemaining() == 0) {
                    SmartcardCertBasedAuthChallengeHandler.this.indicateTooManyFailedAttempts(methodTag);
                    request.cancel();
                    return;
                }
                List<ICertDetails> certList = session.getCertDetailsList();
                if (certList.isEmpty()) {
                    Logger.info(methodTag, "No PIV certificates found on smartcard device.");
                    SmartcardCertBasedAuthChallengeHandler.this.mDialogHolder.showErrorDialog(R.string.smartcard_no_cert_dialog_title, R.string.smartcard_no_cert_dialog_message);
                    request.cancel();
                    return;
                }
                SmartcardCertBasedAuthChallengeHandler.this.mDialogHolder.showCertPickerDialog(certList, SmartcardCertBasedAuthChallengeHandler.this.getSmartcardCertPickerDialogPositiveButtonListener(request), new SmartcardCertPickerDialog.CancelCbaCallback(){

                    @Override
                    @RequiresApi(api=21)
                    public void onCancel() {
                        SmartcardCertBasedAuthChallengeHandler.this.mDialogHolder.dismissDialog();
                        request.cancel();
                    }
                });
            }

            @Override
            public void onException(@NonNull Exception e) {
                SmartcardCertBasedAuthChallengeHandler.this.indicateGeneralException(methodTag, e);
                request.cancel();
            }
        });
        return null;
    }

    private void indicateTooManyFailedAttempts(@NonNull String methodTag) {
        Logger.info(methodTag, "User has reached the maximum failed attempts allowed.");
        this.mDialogHolder.showErrorDialog(R.string.smartcard_max_attempt_dialog_title, R.string.smartcard_max_attempt_dialog_message);
    }

    private void indicateGeneralException(@NonNull String methodTag, @NonNull Exception e) {
        Logger.error(methodTag, e.getMessage(), e);
        this.mDialogHolder.showErrorDialog(R.string.smartcard_general_error_dialog_title, R.string.smartcard_general_error_dialog_message);
        Telemetry.emit((BaseEvent)new ErrorEvent().putException(e));
    }

    private SmartcardCertPickerDialog.PositiveButtonListener getSmartcardCertPickerDialogPositiveButtonListener(final @NonNull ClientCertRequest request) {
        return new SmartcardCertPickerDialog.PositiveButtonListener(){

            @Override
            @RequiresApi(api=21)
            public void onClick(@NonNull ICertDetails certDetails) {
                SmartcardCertBasedAuthChallengeHandler.this.mDialogHolder.showPinDialog(SmartcardCertBasedAuthChallengeHandler.this.getSmartcardPinDialogPositiveButtonListener(certDetails, request), new SmartcardPinDialog.CancelCbaCallback(){

                    @Override
                    @RequiresApi(api=21)
                    public void onCancel() {
                        SmartcardCertBasedAuthChallengeHandler.this.mDialogHolder.dismissDialog();
                        request.cancel();
                    }
                });
            }
        };
    }

    private SmartcardPinDialog.PositiveButtonListener getSmartcardPinDialogPositiveButtonListener(final @NonNull ICertDetails certDetails, final @NonNull ClientCertRequest request) {
        final String methodTag = TAG + ":getSmartcardPinDialogPositiveButtonListener";
        return new SmartcardPinDialog.PositiveButtonListener(){

            @Override
            @RequiresApi(api=21)
            public void onClick(final @NonNull char[] pin) {
                SmartcardCertBasedAuthChallengeHandler.this.mSmartcardCertBasedAuthManager.requestDeviceSession(new AbstractSmartcardCertBasedAuthManager.ISessionCallback(){

                    @Override
                    public void onGetSession(@NonNull ISmartcardSession session) throws Exception {
                        SmartcardCertBasedAuthChallengeHandler.this.tryUsingSmartcardWithPin(pin, certDetails, request, session);
                        SmartcardCertBasedAuthChallengeHandler.this.clearPin(pin);
                    }

                    @Override
                    public void onException(@NonNull Exception e) {
                        SmartcardCertBasedAuthChallengeHandler.this.indicateGeneralException(methodTag, e);
                        request.cancel();
                        SmartcardCertBasedAuthChallengeHandler.this.clearPin(pin);
                    }
                });
            }
        };
    }

    @RequiresApi(api=21)
    private void tryUsingSmartcardWithPin(@NonNull char[] pin, @NonNull ICertDetails certDetails, @NonNull ClientCertRequest request, @NonNull ISmartcardSession session) throws Exception {
        String methodTag = TAG + ":tryUsingSmartcardWithPin";
        if (session.verifyPin(pin)) {
            this.useSmartcardCertForAuth(certDetails, pin, session, request);
        } else if (session.getPinAttemptsRemaining() == 0) {
            this.indicateTooManyFailedAttempts(methodTag);
            request.cancel();
        } else {
            this.mDialogHolder.setPinDialogErrorMode();
        }
    }

    @RequiresApi(api=21)
    private void useSmartcardCertForAuth(@NonNull ICertDetails certDetails, @NonNull char[] pin, @NonNull ISmartcardSession session, @NonNull ClientCertRequest request) throws Exception {
        this.mSmartcardCertBasedAuthManager.initBeforeProceedingWithRequest();
        PrivateKey privateKey = session.getKeyForAuth(certDetails, pin);
        X509Certificate[] chain = new X509Certificate[]{certDetails.getCertificate()};
        this.mDialogHolder.dismissDialog();
        this.mIsSmartcardCertBasedAuthProceeding = true;
        request.proceed(privateKey, chain);
    }

    private void clearPin(@NonNull char[] pin) {
        Arrays.fill(pin, '\u0000');
    }

    @Override
    public void emitTelemetryForCertBasedAuthResults(@NonNull RawAuthorizationResult response) {
        if (this.mIsSmartcardCertBasedAuthProceeding) {
            CertBasedAuthResultEvent certBasedAuthResultEvent = new CertBasedAuthResultEvent("cert_based_auth_result_smartcard_event");
            this.mIsSmartcardCertBasedAuthProceeding = false;
            Telemetry.emit((BaseEvent)certBasedAuthResultEvent.putResponseCode(response.getResultCode().toString()));
            BaseException exception = response.getException();
            if (exception != null) {
                Telemetry.emit((BaseEvent)new ErrorEvent().putException((Exception)exception));
            }
        }
    }

    @Override
    public void cleanUp() {
        this.mDialogHolder.dismissDialog();
        this.mSmartcardCertBasedAuthManager.setConnectionCallback(null);
    }
}

