/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.adal.internal.cache;

import android.net.Uri;
import android.os.Build;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.microsoft.identity.common.adal.internal.AuthenticationSettings;
import com.microsoft.identity.common.adal.internal.cache.ADALTokenCacheItem;
import com.microsoft.identity.common.java.BaseAccount;
import com.microsoft.identity.common.java.adal.cache.CacheKey;
import com.microsoft.identity.common.java.adal.cache.DateTimeAdapter;
import com.microsoft.identity.common.java.authscheme.AbstractAuthenticationScheme;
import com.microsoft.identity.common.java.cache.AccountDeletionRecord;
import com.microsoft.identity.common.java.cache.ICacheRecord;
import com.microsoft.identity.common.java.cache.IShareSingleSignOnState;
import com.microsoft.identity.common.java.dto.AccountRecord;
import com.microsoft.identity.common.java.dto.Credential;
import com.microsoft.identity.common.java.dto.CredentialType;
import com.microsoft.identity.common.java.dto.IdTokenRecord;
import com.microsoft.identity.common.java.exception.ClientException;
import com.microsoft.identity.common.java.interfaces.INameValueStorage;
import com.microsoft.identity.common.java.interfaces.IPlatformComponents;
import com.microsoft.identity.common.java.logging.Logger;
import com.microsoft.identity.common.java.providers.microsoft.MicrosoftAccount;
import com.microsoft.identity.common.java.providers.microsoft.MicrosoftRefreshToken;
import com.microsoft.identity.common.java.providers.microsoft.azureactivedirectory.AzureActiveDirectoryAccount;
import com.microsoft.identity.common.java.providers.microsoft.azureactivedirectory.AzureActiveDirectoryAuthorizationRequest;
import com.microsoft.identity.common.java.providers.microsoft.azureactivedirectory.AzureActiveDirectoryOAuth2Strategy;
import com.microsoft.identity.common.java.providers.microsoft.azureactivedirectory.AzureActiveDirectoryRefreshToken;
import com.microsoft.identity.common.java.providers.microsoft.azureactivedirectory.AzureActiveDirectoryTokenResponse;
import com.microsoft.identity.common.java.providers.oauth2.OAuth2TokenCache;
import com.microsoft.identity.common.java.providers.oauth2.RefreshToken;
import com.microsoft.identity.common.java.util.StringUtil;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import lombok.NonNull;

public class ADALOAuth2TokenCache
extends OAuth2TokenCache<AzureActiveDirectoryOAuth2Strategy, AzureActiveDirectoryAuthorizationRequest, AzureActiveDirectoryTokenResponse>
implements IShareSingleSignOnState {
    private INameValueStorage<String> mISharedPreferencesFileManager;
    private static final String TAG = ADALOAuth2TokenCache.class.getSimpleName();
    private static final String SHARED_PREFERENCES_FILENAME = "com.microsoft.aad.adal.cache";
    private Gson mGson = new GsonBuilder().registerTypeAdapter(Date.class, (Object)new DateTimeAdapter()).create();
    private List<IShareSingleSignOnState<MicrosoftAccount, MicrosoftRefreshToken>> mSharedSSOCaches;

    public ADALOAuth2TokenCache(IPlatformComponents components) {
        super(components);
        Logger.verbose((String)TAG, (String)("Init: " + TAG));
        this.validateSecretKeySetting();
        this.initializeSharedPreferencesFileManager(SHARED_PREFERENCES_FILENAME);
        this.mSharedSSOCaches = new ArrayList<IShareSingleSignOnState<MicrosoftAccount, MicrosoftRefreshToken>>();
    }

    public ADALOAuth2TokenCache(IPlatformComponents context, List<IShareSingleSignOnState<MicrosoftAccount, MicrosoftRefreshToken>> sharedSSOCaches) {
        super(context);
        Logger.verbose((String)TAG, (String)("Init: " + TAG));
        this.validateSecretKeySetting();
        this.initializeSharedPreferencesFileManager(SHARED_PREFERENCES_FILENAME);
        this.mSharedSSOCaches = sharedSSOCaches;
    }

    protected void initializeSharedPreferencesFileManager(String fileName) {
        Logger.verbose((String)TAG, (String)"Initializing SharedPreferencesFileManager");
        Logger.verbosePII((String)TAG, (String)("Initializing with name: " + fileName));
        IPlatformComponents components = this.getComponents();
        this.mISharedPreferencesFileManager = components.getEncryptedNameValueStore(fileName, components.getStorageEncryptionManager(), String.class);
    }

    public ICacheRecord save(AzureActiveDirectoryOAuth2Strategy strategy, AzureActiveDirectoryAuthorizationRequest request, AzureActiveDirectoryTokenResponse response) throws ClientException {
        String methodTag = TAG + ":save";
        String issuerCacheIdentifier = strategy.getIssuerCacheIdentifier(request);
        AzureActiveDirectoryAccount account = strategy.createAccount(response);
        String msalEnvironment = Uri.parse((String)issuerCacheIdentifier).getAuthority();
        account.setEnvironment(msalEnvironment);
        AzureActiveDirectoryRefreshToken refreshToken = strategy.getRefreshTokenFromResponse(response);
        refreshToken.setEnvironment(msalEnvironment);
        Logger.info((String)methodTag, (String)"Constructing new ADALTokenCacheItem");
        ADALTokenCacheItem cacheItem = new ADALTokenCacheItem(strategy, request, response);
        ADALOAuth2TokenCache.logTokenCacheItem(cacheItem, methodTag);
        Logger.info((String)methodTag, (String)"Setting items to cache for user...");
        for (String string2 : account.getCacheIdentifiers()) {
            String scope = request.getScope();
            String clientId = request.getClientId();
            Logger.infoPII((String)methodTag, (String)("issuerCacheIdentifier: [" + issuerCacheIdentifier + "]"));
            Logger.infoPII((String)methodTag, (String)("scope: [" + scope + "]"));
            Logger.infoPII((String)methodTag, (String)("clientId: [" + clientId + "]"));
            Logger.infoPII((String)methodTag, (String)("cacheIdentifier: [" + string2 + "]"));
            this.setItemToCacheForUser(issuerCacheIdentifier, scope, clientId, cacheItem, string2);
        }
        this.setItemToCacheForUser(issuerCacheIdentifier, request.getScope(), request.getClientId(), cacheItem, null);
        Logger.info((String)methodTag, (String)"Syncing SSO state to caches...");
        for (IShareSingleSignOnState iShareSingleSignOnState : this.mSharedSSOCaches) {
            try {
                iShareSingleSignOnState.setSingleSignOnState((BaseAccount)account, (RefreshToken)refreshToken);
            }
            catch (ClientException e) {
                Logger.errorPII((String)TAG, (String)("Exception setting single sign on state for account " + account.getUsername()), (Throwable)e);
            }
            catch (IllegalStateException e) {
                Logger.errorPII((String)TAG, (String)("Exception setting single sign on state for account " + account.getUsername()), (Throwable)e);
                if (AuthenticationSettings.INSTANCE.shouldIgnoreKeyLoaderNotFoundError()) continue;
                throw e;
            }
        }
        return null;
    }

    public List<ICacheRecord> saveAndLoadAggregatedAccountData(AzureActiveDirectoryOAuth2Strategy oAuth2Strategy, AzureActiveDirectoryAuthorizationRequest request, AzureActiveDirectoryTokenResponse response) throws ClientException {
        throw new UnsupportedOperationException("This method is unsupported.");
    }

    public ICacheRecord save(AccountRecord accountRecord, IdTokenRecord idTokenRecord) {
        throw new UnsupportedOperationException("This method is unsupported.");
    }

    public ICacheRecord load(String clientId, String target, AccountRecord account, AbstractAuthenticationScheme scheme) {
        throw new UnsupportedOperationException("This method is unsupported.");
    }

    public List<ICacheRecord> loadWithAggregatedAccountData(String clientId, String target, AccountRecord account, AbstractAuthenticationScheme scheme) {
        throw new UnsupportedOperationException("This method is unsupported.");
    }

    public boolean removeCredential(Credential credential) {
        throw new UnsupportedOperationException("This method is unsupported.");
    }

    public AccountRecord getAccount(String environment, String clientId, String homeAccountId, String realm) {
        throw new UnsupportedOperationException("This method is unsupported.");
    }

    public List<ICacheRecord> getAccountsWithAggregatedAccountData(String environment, String clientId, String homeAccountId) {
        throw new UnsupportedOperationException("This method is unsupported.");
    }

    public AccountRecord getAccountByLocalAccountId(String environment, String clientId, String localAccountId) {
        throw new UnsupportedOperationException("This method is unsupported.");
    }

    public ICacheRecord getAccountWithAggregatedAccountDataByLocalAccountId(String environment, String clientId, String localAccountId) {
        throw new UnsupportedOperationException("This method is unsupported.");
    }

    public List<AccountRecord> getAccounts(String environment, String clientId) {
        throw new UnsupportedOperationException("This method is unsupported.");
    }

    public List<AccountRecord> getAllTenantAccountsForAccountByClientId(String clientId, AccountRecord accountRecord) {
        throw new UnsupportedOperationException("This method is unsupported.");
    }

    public List<ICacheRecord> getAccountsWithAggregatedAccountData(String environment, String clientId) {
        throw new UnsupportedOperationException("This method is unsupported.");
    }

    public List<IdTokenRecord> getIdTokensForAccountRecord(String clientId, AccountRecord accountRecord) {
        throw new UnsupportedOperationException("This method is unsupported.");
    }

    public AccountDeletionRecord removeAccount(String environment, String clientId, String homeAccountId, String realm) {
        throw new UnsupportedOperationException("This method is unsupported.");
    }

    public AccountDeletionRecord removeAccount(String environment, String clientId, String homeAccountId, String realm, CredentialType ... typesToRemove) {
        throw new UnsupportedOperationException("This method is unsupported.");
    }

    public void clearAll() {
        throw new UnsupportedOperationException("This method is unsupported.");
    }

    protected Set<String> getAllClientIds() {
        throw new UnsupportedOperationException("This method is unsupported.");
    }

    public AccountRecord getAccountByHomeAccountId(@Nullable String environment, @NonNull String clientId, @NonNull String homeAccountId) {
        if (clientId == null) {
            throw new NullPointerException("clientId is marked non-null but is null");
        }
        if (homeAccountId == null) {
            throw new NullPointerException("homeAccountId is marked non-null but is null");
        }
        throw new UnsupportedOperationException("This method is unsupported.");
    }

    private static void logTokenCacheItem(ADALTokenCacheItem tokenCacheItem, @NonNull String methodTag) {
        if (methodTag == null) {
            throw new NullPointerException("methodTag is marked non-null but is null");
        }
        Logger.info((String)methodTag, (String)"Logging TokenCacheItem");
        Logger.infoPII((String)methodTag, (String)("resource: [" + tokenCacheItem.getResource() + "]"));
        Logger.infoPII((String)methodTag, (String)("authority: [" + tokenCacheItem.getAuthority() + "]"));
        Logger.infoPII((String)methodTag, (String)("clientId: [" + tokenCacheItem.getClientId() + "]"));
        Logger.infoPII((String)methodTag, (String)("expiresOn: [" + tokenCacheItem.getExpiresOn() + "]"));
        Logger.infoPII((String)methodTag, (String)("isMrrt: [" + tokenCacheItem.getIsMultiResourceRefreshToken() + "]"));
        Logger.infoPII((String)methodTag, (String)("tenantId: [" + tokenCacheItem.getTenantId() + "]"));
        Logger.infoPII((String)methodTag, (String)("foci: [" + tokenCacheItem.getFamilyClientId() + "]"));
        Logger.infoPII((String)methodTag, (String)("extendedExpires: [" + tokenCacheItem.getExtendedExpiresOn() + "]"));
        Logger.infoPII((String)methodTag, (String)("speRing: [" + tokenCacheItem.getSpeRing() + "]"));
    }

    private void setItemToCacheForUser(String issuer, String resource, String clientId, ADALTokenCacheItem cacheItem, String userId) {
        String methodTag = TAG + ":setItemToCacheForUser";
        Logger.info((String)methodTag, (String)"Setting cacheitem for RT entry.");
        this.setItem(CacheKey.createCacheKeyForRTEntry((String)issuer, (String)resource, (String)clientId, (String)userId), cacheItem);
        if (cacheItem.getIsMultiResourceRefreshToken()) {
            Logger.info((String)methodTag, (String)"CacheItem is an MRRT.");
            this.setItem(CacheKey.createCacheKeyForMRRT((String)issuer, (String)clientId, (String)userId), ADALTokenCacheItem.getAsMRRTTokenCacheItem((ADALTokenCacheItem)cacheItem));
        }
        if (!StringUtil.isNullOrEmpty((String)cacheItem.getFamilyClientId())) {
            Logger.info((String)methodTag, (String)"CacheItem is an FRT.");
            this.setItem(CacheKey.createCacheKeyForFRT((String)issuer, (String)cacheItem.getFamilyClientId(), (String)userId), ADALTokenCacheItem.getAsFRTTokenCacheItem((ADALTokenCacheItem)cacheItem));
        }
    }

    private void setItem(String key, ADALTokenCacheItem cacheItem) {
        Logger.info((String)(TAG + ":setItem"), (String)"Setting item to cache");
        String json = this.mGson.toJson((Object)cacheItem);
        this.mISharedPreferencesFileManager.put(key, (Object)json);
    }

    private void validateSecretKeySetting() {
        Logger.verbose((String)TAG, (String)"Validating secret key settings.");
        byte[] secretKeyData = AuthenticationSettings.INSTANCE.getSecretKeyData();
        if (secretKeyData == null && Build.VERSION.SDK_INT < 18) {
            throw new IllegalArgumentException("Secret key must be provided for API < 18. Use AuthenticationSettings.INSTANCE.setSecretKey()");
        }
    }

    public void setSingleSignOnState(BaseAccount account, RefreshToken refreshToken) {
        Logger.warn((String)TAG, (String)"setSingleSignOnState was called, but is not implemented.");
    }

    public RefreshToken getSingleSignOnState(BaseAccount account) {
        Logger.warn((String)TAG, (String)"getSingleSignOnState was called, but is not implemented.");
        RefreshToken refreshToken = null;
        return refreshToken;
    }

    public static String getAdalCacheFilename() {
        Logger.info((String)(TAG + ":getAdalCacheFilename"), (String)"Getting ADAL cache file name...");
        return SHARED_PREFERENCES_FILENAME;
    }
}

