/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.platform;

import android.content.Context;
import androidx.annotation.NonNull;
import com.microsoft.identity.common.AndroidPlatformComponents;
import com.microsoft.identity.common.internal.platform.AndroidKeystoreAsymmetricRsaKey;
import com.microsoft.identity.common.internal.platform.AsymmetricRsaKey;
import com.microsoft.identity.common.internal.platform.AsymmetricRsaKeyFactory;
import com.microsoft.identity.common.java.exception.ClientException;

public class AndroidKeystoreAsymmetricRsaKeyFactory
implements AsymmetricRsaKeyFactory {
    private final Context mContext;

    public AndroidKeystoreAsymmetricRsaKeyFactory(@NonNull Context context) {
        this.mContext = context;
    }

    @Override
    public synchronized AsymmetricRsaKey generateAsymmetricKey(@NonNull String alias) throws ClientException {
        return new AndroidKeystoreAsymmetricRsaKey(AndroidPlatformComponents.createFromContext(this.mContext).getDevicePopManager(alias), alias);
    }

    @Override
    public synchronized AsymmetricRsaKey loadAsymmetricKey(@NonNull String alias) throws ClientException {
        return this.generateAsymmetricKey(alias);
    }

    @Override
    public synchronized boolean clearAsymmetricKey(@NonNull String alias) throws ClientException {
        return AndroidPlatformComponents.createFromContext(this.mContext).getDevicePopManager(alias).clearAsymmetricKey();
    }
}

