/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.ui.webview.challengehandlers;

import android.app.Activity;
import androidx.annotation.NonNull;
import com.microsoft.identity.common.internal.ui.webview.challengehandlers.AbstractSmartcardCertBasedAuthManager;
import com.microsoft.identity.common.internal.ui.webview.challengehandlers.DialogHolder;
import com.microsoft.identity.common.internal.ui.webview.challengehandlers.ICertBasedAuthChallengeHandler;
import com.microsoft.identity.common.internal.ui.webview.challengehandlers.OnDeviceCertBasedAuthChallengeHandler;
import com.microsoft.identity.common.internal.ui.webview.challengehandlers.SmartcardCertBasedAuthChallengeHandler;
import com.microsoft.identity.common.internal.ui.webview.challengehandlers.YubiKitCertBasedAuthManager;
import com.microsoft.identity.common.logging.Logger;

public class CertBasedAuthFactory {
    private static final String TAG = CertBasedAuthFactory.class.getSimpleName();
    private final Activity mActivity;
    private final AbstractSmartcardCertBasedAuthManager mSmartcardCertBasedAuthManager;

    public CertBasedAuthFactory(@NonNull Activity activity) {
        final String methodTag = TAG + ":CertBasedAuthFactory";
        this.mActivity = activity;
        this.mSmartcardCertBasedAuthManager = new YubiKitCertBasedAuthManager(this.mActivity.getApplicationContext());
        this.mSmartcardCertBasedAuthManager.setDiscoveryExceptionCallback(new AbstractSmartcardCertBasedAuthManager.IDiscoveryExceptionCallback(){

            @Override
            public void onException() {
                Logger.error(methodTag, "Unable to start smartcard usb discovery.", null);
            }
        });
        this.mSmartcardCertBasedAuthManager.startDiscovery();
    }

    @NonNull
    public ICertBasedAuthChallengeHandler createCertBasedAuthChallengeHandler() {
        if (this.mSmartcardCertBasedAuthManager.isDeviceConnected()) {
            return new SmartcardCertBasedAuthChallengeHandler(this.mSmartcardCertBasedAuthManager, new DialogHolder(this.mActivity));
        }
        return new OnDeviceCertBasedAuthChallengeHandler(this.mActivity);
    }

    public void onDestroy() {
        this.mSmartcardCertBasedAuthManager.onDestroy();
    }
}

