/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.providers.oauth2;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.ProgressBar;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.fragment.app.FragmentActivity;
import com.microsoft.identity.common.R;
import com.microsoft.identity.common.adal.internal.util.StringExtensions;
import com.microsoft.identity.common.internal.providers.oauth2.AuthorizationFragment;
import com.microsoft.identity.common.internal.ui.webview.AzureActiveDirectoryWebViewClient;
import com.microsoft.identity.common.internal.ui.webview.OnPageLoadedCallback;
import com.microsoft.identity.common.internal.ui.webview.WebViewUtil;
import com.microsoft.identity.common.java.providers.RawAuthorizationResult;
import com.microsoft.identity.common.java.ui.webview.authorization.IAuthorizationCompletionCallback;
import com.microsoft.identity.common.logging.Logger;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;

public class WebViewAuthorizationFragment
extends AuthorizationFragment {
    private static final String TAG = WebViewAuthorizationFragment.class.getSimpleName();
    @VisibleForTesting
    private static final String PKEYAUTH_STATUS = "pkeyAuthStatus";
    private WebView mWebView;
    private AzureActiveDirectoryWebViewClient mAADWebViewClient;
    private ProgressBar mProgressBar;
    private Intent mAuthIntent;
    private boolean mPkeyAuthStatus = false;
    private String mAuthorizationRequestUrl;
    private String mRedirectUri;
    private HashMap<String, String> mRequestHeaders;
    private String mPostPageLoadedJavascript;
    private boolean webViewZoomControlsEnabled;
    private boolean webViewZoomEnabled;

    @Override
    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        String methodTag = TAG + ":onCreate";
        FragmentActivity activity = this.getActivity();
        if (activity != null) {
            WebViewUtil.setDataDirectorySuffix(activity.getApplicationContext());
        }
        if (Build.VERSION.SDK_INT >= 21) {
            WebView.clearClientCertPreferences(null);
        } else {
            Logger.warn(methodTag, "Client Cert Preferences cache not cleared due to SDK version < 21 (LOLLIPOP)");
        }
    }

    public void onSaveInstanceState(@NonNull Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putParcelable("com.microsoft.identity.auth.intent", (Parcelable)this.mAuthIntent);
        outState.putBoolean(PKEYAUTH_STATUS, this.mPkeyAuthStatus);
        outState.putString("com.microsoft.identity.request.redirect.uri", this.mRedirectUri);
        outState.putString("com.microsoft.identity.request.url", this.mAuthorizationRequestUrl);
        outState.putSerializable("com.microsoft.identity.request.headers", this.mRequestHeaders);
        outState.putSerializable("com.microsoft.identity.post.page.loaded.url", (Serializable)((Object)this.mPostPageLoadedJavascript));
        outState.putBoolean("com.microsoft.identity.web.view.zoom.controls.enabled", this.webViewZoomControlsEnabled);
        outState.putBoolean("com.microsoft.identity.web.view.zoom.enabled", this.webViewZoomEnabled);
    }

    @Override
    void extractState(@NonNull Bundle state) {
        super.extractState(state);
        this.mAuthIntent = (Intent)state.getParcelable("com.microsoft.identity.auth.intent");
        this.mPkeyAuthStatus = state.getBoolean(PKEYAUTH_STATUS, false);
        this.mAuthorizationRequestUrl = state.getString("com.microsoft.identity.request.url");
        this.mRedirectUri = state.getString("com.microsoft.identity.request.redirect.uri");
        this.mRequestHeaders = this.getRequestHeaders(state);
        this.mPostPageLoadedJavascript = state.getString("com.microsoft.identity.post.page.loaded.url");
        this.webViewZoomEnabled = state.getBoolean("com.microsoft.identity.web.view.zoom.enabled", true);
        this.webViewZoomControlsEnabled = state.getBoolean("com.microsoft.identity.web.view.zoom.controls.enabled", true);
    }

    @Nullable
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        final String methodTag = TAG + ":onCreateView";
        View view = inflater.inflate(R.layout.common_activity_authentication, container, false);
        this.mProgressBar = (ProgressBar)view.findViewById(R.id.common_auth_webview_progressbar);
        FragmentActivity activity = this.getActivity();
        if (activity == null) {
            return null;
        }
        this.mAADWebViewClient = new AzureActiveDirectoryWebViewClient((Activity)activity, new AuthorizationCompletionCallback(), new OnPageLoadedCallback(){

            @Override
            public void onPageLoaded(String url) {
                String[] javascriptToExecute = new String[1];
                WebViewAuthorizationFragment.this.mProgressBar.setVisibility(4);
                try {
                    javascriptToExecute[0] = String.format("window.expectedUrl = '%s';%n%s", URLEncoder.encode(url, "UTF-8"), WebViewAuthorizationFragment.this.mPostPageLoadedJavascript);
                }
                catch (UnsupportedEncodingException e) {
                    Logger.warn(methodTag, "Inject expectedUrl failed.");
                }
                if (!WebViewAuthorizationFragment.this.mAuthResultSent && !StringExtensions.isNullOrBlank(javascriptToExecute[0])) {
                    if (Build.VERSION.SDK_INT >= 19) {
                        WebViewAuthorizationFragment.this.mWebView.evaluateJavascript(javascriptToExecute[0], null);
                    } else {
                        WebViewAuthorizationFragment.this.mWebView.loadUrl("javascript:" + javascriptToExecute[0].replace("%", "%25"));
                    }
                }
            }
        }, this.mRedirectUri);
        this.setUpWebView(view, this.mAADWebViewClient);
        this.mWebView.post(new Runnable(){

            @Override
            public void run() {
                Logger.info(methodTag, "Launching embedded WebView for acquiring auth code.");
                Logger.infoPII(methodTag, "The start url is " + WebViewAuthorizationFragment.this.mAuthorizationRequestUrl);
                WebViewAuthorizationFragment.this.mWebView.loadUrl(WebViewAuthorizationFragment.this.mAuthorizationRequestUrl, (Map)WebViewAuthorizationFragment.this.mRequestHeaders);
                WebViewAuthorizationFragment.this.mProgressBar.setVisibility(0);
            }
        });
        return view;
    }

    @Override
    public void handleBackButtonPressed() {
        String methodTag = TAG + ":handleBackButtonPressed";
        Logger.info(methodTag, "Back button is pressed");
        if (this.mWebView.canGoBack()) {
            this.mWebView.goBack();
            if (Build.VERSION.SDK_INT >= 21) {
                WebView.clearClientCertPreferences(null);
            } else {
                Logger.warn(methodTag, "Client Cert Preferences cache not cleared due to SDK version < 21 (LOLLIPOP)");
            }
        } else {
            this.cancelAuthorization(true);
        }
    }

    @SuppressLint(value={"SetJavaScriptEnabled", "ClickableViewAccessibility"})
    private void setUpWebView(@NonNull View view, @NonNull AzureActiveDirectoryWebViewClient webViewClient) {
        this.mWebView = (WebView)view.findViewById(R.id.common_auth_webview);
        WebSettings userAgentSetting = this.mWebView.getSettings();
        String userAgent = userAgentSetting.getUserAgentString();
        this.mWebView.getSettings().setUserAgentString(userAgent + " PKeyAuth/1.0");
        this.mWebView.getSettings().setJavaScriptEnabled(true);
        this.mWebView.requestFocus(130);
        this.mWebView.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View view, MotionEvent event) {
                int action = event.getAction();
                if (!(action != 0 && action != 1 || view.hasFocus())) {
                    view.requestFocus();
                }
                return false;
            }
        });
        this.mWebView.getSettings().setLoadWithOverviewMode(true);
        this.mWebView.getSettings().setDomStorageEnabled(true);
        this.mWebView.getSettings().setUseWideViewPort(true);
        this.mWebView.getSettings().setBuiltInZoomControls(this.webViewZoomControlsEnabled);
        this.mWebView.getSettings().setSupportZoom(this.webViewZoomEnabled);
        this.mWebView.setVisibility(4);
        this.mWebView.setWebViewClient((WebViewClient)webViewClient);
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        String methodTag = TAG + ":onDestroy";
        if (this.mAADWebViewClient != null) {
            this.mAADWebViewClient.onDestroy();
        } else {
            Logger.error(methodTag, "Fragment destroyed, but smartcard usb discovery was unable to be stopped.", null);
        }
    }

    private HashMap<String, String> getRequestHeaders(Bundle state) {
        try {
            HashMap requestHeaders = (HashMap)state.getSerializable("com.microsoft.identity.request.headers");
            return requestHeaders;
        }
        catch (Exception e) {
            return null;
        }
    }

    class AuthorizationCompletionCallback
    implements IAuthorizationCompletionCallback {
        AuthorizationCompletionCallback() {
        }

        public void onChallengeResponseReceived(@NonNull RawAuthorizationResult response) {
            String methodTag = TAG + ":onChallengeResponseReceived";
            Logger.info(methodTag, null, "onChallengeResponseReceived:" + response.getResultCode());
            if (WebViewAuthorizationFragment.this.mAADWebViewClient != null) {
                WebViewAuthorizationFragment.this.mAADWebViewClient.emitTelemetryForCertBasedAuthResult(response);
            }
            WebViewAuthorizationFragment.this.sendResult(response);
            WebViewAuthorizationFragment.this.finish();
        }

        public void setPKeyAuthStatus(boolean status) {
            String methodTag = TAG + ":setPKeyAuthStatus";
            WebViewAuthorizationFragment.this.mPkeyAuthStatus = status;
            Logger.info(methodTag, null, "setPKeyAuthStatus:" + status);
        }
    }
}

