/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.crypto;

import android.annotation.TargetApi;
import android.content.Context;
import android.security.KeyPairGeneratorSpec;
import androidx.annotation.RequiresApi;
import com.microsoft.identity.common.internal.util.AndroidKeyStoreUtil;
import com.microsoft.identity.common.java.crypto.key.AES256KeyLoader;
import com.microsoft.identity.common.java.crypto.key.KeyUtil;
import com.microsoft.identity.common.java.exception.ClientException;
import com.microsoft.identity.common.java.telemetry.ITelemetryCallback;
import com.microsoft.identity.common.java.util.CachedData;
import com.microsoft.identity.common.java.util.FileUtil;
import com.microsoft.identity.common.logging.Logger;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Calendar;
import java.util.Locale;
import javax.crypto.SecretKey;
import javax.security.auth.x500.X500Principal;
import lombok.NonNull;

@TargetApi(value=18)
public class AndroidWrappedKeyLoader
extends AES256KeyLoader {
    private static final String TAG = AndroidWrappedKeyLoader.class.getSimpleName() + "#";
    @SuppressFBWarnings(value={"MS_SHOULD_BE_FINAL"})
    public static boolean sSkipKeyInvalidationCheck = false;
    static final String KEYSTORE_KEY_ALIAS = "KEYSTORE_KEY";
    private static final String WRAP_ALGORITHM = "RSA/ECB/PKCS1Padding";
    private static final String WRAP_KEY_ALGORITHM = "RSA";
    public static final String KEY_IDENTIFIER = "A001";
    static final String KEY_FILE_PATH = "adalks";
    static final int KEY_FILE_SIZE = 1024;
    private final Context mContext;
    private final ITelemetryCallback mTelemetryCallback;
    private final String mAlias;
    private final CachedData<SecretKey> mKeyCache = new CachedData<SecretKey>(){

        public SecretKey getData() {
            if (!(sSkipKeyInvalidationCheck || AndroidKeyStoreUtil.canLoadKey(AndroidWrappedKeyLoader.this.mAlias) && AndroidWrappedKeyLoader.this.getKeyFile().exists())) {
                this.clear();
            }
            return (SecretKey)super.getData();
        }
    };

    @NonNull
    CachedData<SecretKey> getKeyCache() {
        return this.mKeyCache;
    }

    public AndroidWrappedKeyLoader(@NonNull String alias, @NonNull Context context, @Nullable ITelemetryCallback telemetryCallback) {
        if (alias == null) {
            throw new NullPointerException("alias is marked non-null but is null");
        }
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        this.mAlias = alias;
        this.mContext = context;
        this.mTelemetryCallback = telemetryCallback;
    }

    @NonNull
    public String getAlias() {
        return KEYSTORE_KEY_ALIAS;
    }

    @NonNull
    public String getKeyTypeIdentifier() {
        return KEY_IDENTIFIER;
    }

    @NonNull
    public synchronized SecretKey getKey() throws ClientException {
        SecretKey key = (SecretKey)this.mKeyCache.getData();
        if (key == null) {
            key = this.readSecretKeyFromStorage();
        }
        if (key == null) {
            key = this.generateRandomKey();
        }
        this.mKeyCache.setData((Object)key);
        return key;
    }

    protected SecretKey generateRandomKey() throws ClientException {
        String methodTag = TAG + ":generateRandomKey";
        SecretKey key = super.generateRandomKey();
        this.saveSecretKeyToStorage(key);
        this.logEvent(methodTag, "key_created_v2", false, "New key is generated.");
        Logger.info(methodTag, "New key is generated with thumbprint: " + KeyUtil.getKeyThumbPrint((SecretKey)key));
        return key;
    }

    @Nullable
    SecretKey readSecretKeyFromStorage() throws ClientException {
        String methodTag = TAG + ":readSecretKeyFromStorage";
        try {
            KeyPair keyPair = this.readKeyStoreKeyPair();
            if (keyPair == null) {
                Logger.info(methodTag, "key does not exist in keystore");
                this.deleteSecretKeyFromStorage();
                return null;
            }
            byte[] wrappedSecretKey = FileUtil.readFromFile((File)this.getKeyFile(), (int)1024);
            if (wrappedSecretKey == null) {
                Logger.warn(methodTag, "Key file is empty");
                this.deleteSecretKeyFromStorage();
                return null;
            }
            SecretKey key = AndroidKeyStoreUtil.unwrap(wrappedSecretKey, this.getKeySpecAlgorithm(), keyPair, WRAP_ALGORITHM);
            Logger.info(methodTag, "New key is generated with thumbprint: " + KeyUtil.getKeyThumbPrint((SecretKey)key));
            return key;
        }
        catch (ClientException e) {
            Logger.warn(methodTag, "Error when loading key from Storage, wipe all existing key data ");
            this.deleteSecretKeyFromStorage();
            throw e;
        }
    }

    private void saveSecretKeyToStorage(@NonNull SecretKey unencryptedKey) throws ClientException {
        if (unencryptedKey == null) {
            throw new NullPointerException("unencryptedKey is marked non-null but is null");
        }
        String methodTag = TAG + ":saveSecretKeyToStorage";
        KeyPair keyPair = this.readKeyStoreKeyPair();
        if (keyPair == null) {
            Logger.info(methodTag, "No existing keypair. Generating a new one.");
            keyPair = this.generateKeyStoreKeyPair();
        }
        byte[] keyWrapped = AndroidKeyStoreUtil.wrap(unencryptedKey, keyPair, WRAP_ALGORITHM);
        FileUtil.writeDataToFile((byte[])keyWrapped, (File)this.getKeyFile());
    }

    private void deleteSecretKeyFromStorage() throws ClientException {
        AndroidKeyStoreUtil.deleteKey(this.mAlias);
        FileUtil.deleteFile((File)this.getKeyFile());
        this.mKeyCache.clear();
    }

    @NonNull
    private synchronized KeyPair generateKeyStoreKeyPair() throws ClientException {
        String methodTag = TAG + ":generateKeyStoreKeyPair";
        try {
            this.logFlowStart(methodTag, "keychain_write_v2_start");
            KeyPair keyPair = AndroidKeyStoreUtil.generateKeyPair(WRAP_KEY_ALGORITHM, AndroidWrappedKeyLoader.getSpecForKeyStoreKey(this.mContext, this.mAlias));
            this.logFlowSuccess(methodTag, "keychain_write_v2_end", "");
            return keyPair;
        }
        catch (ClientException e) {
            this.logFlowError(methodTag, "keychain_write_v2_end", e.toString(), (Exception)((Object)e));
            throw e;
        }
    }

    @Nullable
    private synchronized KeyPair readKeyStoreKeyPair() throws ClientException {
        String methodTag = TAG + ":readKeyStoreKeyPair";
        try {
            this.logFlowStart(methodTag, "keychain_read_v2_start");
            KeyPair keyPair = AndroidKeyStoreUtil.readKey(this.mAlias);
            if (keyPair == null) {
                this.logFlowSuccess(methodTag, "keychain_read_v2_end", "KeyStore is empty.");
            }
            this.logFlowSuccess(methodTag, "keychain_read_v2_end", "KeyStore KeyPair is loaded.");
            return keyPair;
        }
        catch (ClientException e) {
            this.logFlowError(methodTag, "keychain_read_v2_end", e.toString(), (Exception)((Object)e));
            throw e;
        }
    }

    @RequiresApi(api=18)
    private static AlgorithmParameterSpec getSpecForKeyStoreKey(@NonNull Context context, @NonNull String alias) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (alias == null) {
            throw new NullPointerException("alias is marked non-null but is null");
        }
        String certInfo = String.format(Locale.ROOT, "CN=%s, OU=%s", alias, context.getPackageName());
        Calendar start = Calendar.getInstance();
        Calendar end = Calendar.getInstance();
        int certValidYears = 100;
        end.add(1, 100);
        return new KeyPairGeneratorSpec.Builder(context).setAlias(alias).setSubject(new X500Principal(certInfo)).setSerialNumber(BigInteger.ONE).setStartDate(start.getTime()).setEndDate(end.getTime()).build();
    }

    private File getKeyFile() {
        return new File(this.mContext.getDir(this.mContext.getPackageName(), 0), KEY_FILE_PATH);
    }

    private void logEvent(@NonNull String methodTag, @NonNull String operationName, boolean isFailed, @NonNull String reason) {
        if (methodTag == null) {
            throw new NullPointerException("methodTag is marked non-null but is null");
        }
        if (operationName == null) {
            throw new NullPointerException("operationName is marked non-null but is null");
        }
        if (reason == null) {
            throw new NullPointerException("reason is marked non-null but is null");
        }
        Logger.verbose(methodTag, operationName + ": " + reason);
        if (this.mTelemetryCallback != null) {
            this.mTelemetryCallback.logEvent(operationName, Boolean.valueOf(isFailed), reason);
        }
    }

    private void logFlowStart(@NonNull String methodTag, @NonNull String operationName) {
        if (methodTag == null) {
            throw new NullPointerException("methodTag is marked non-null but is null");
        }
        if (operationName == null) {
            throw new NullPointerException("operationName is marked non-null but is null");
        }
        Logger.verbose(methodTag, operationName + " started.");
        if (this.mTelemetryCallback != null) {
            this.mTelemetryCallback.logEvent(operationName, Boolean.valueOf(false), "");
        }
    }

    private void logFlowSuccess(@NonNull String methodTag, @NonNull String operationName, @NonNull String reason) {
        if (methodTag == null) {
            throw new NullPointerException("methodTag is marked non-null but is null");
        }
        if (operationName == null) {
            throw new NullPointerException("operationName is marked non-null but is null");
        }
        if (reason == null) {
            throw new NullPointerException("reason is marked non-null but is null");
        }
        Logger.verbose(methodTag, operationName + " successfully finished: " + reason);
        if (this.mTelemetryCallback != null) {
            this.mTelemetryCallback.logEvent(operationName, Boolean.valueOf(false), reason);
        }
    }

    private void logFlowError(@NonNull String methodTag, @NonNull String operationName, @NonNull String reason, @Nullable Exception e) {
        if (methodTag == null) {
            throw new NullPointerException("methodTag is marked non-null but is null");
        }
        if (operationName == null) {
            throw new NullPointerException("operationName is marked non-null but is null");
        }
        if (reason == null) {
            throw new NullPointerException("reason is marked non-null but is null");
        }
        Logger.error(methodTag, operationName + " failed: " + reason, e);
        if (this.mTelemetryCallback != null) {
            this.mTelemetryCallback.logEvent(operationName, Boolean.valueOf(true), reason);
        }
    }
}

