/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.ui.webview.challengehandlers;

import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.RadioButton;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AlertDialog;
import com.microsoft.identity.common.R;
import com.microsoft.identity.common.internal.ui.webview.challengehandlers.ClientCertAuthChallengeHandler;
import com.microsoft.identity.common.internal.ui.webview.challengehandlers.SmartcardDialog;
import java.security.cert.X509Certificate;
import java.util.List;

public class SmartcardCertPickerDialog
extends SmartcardDialog {
    private final List<ClientCertAuthChallengeHandler.YubiKitCertDetails> mCertList;
    private final PositiveButtonListener mPositiveButtonListener;
    private final CancelCbaCallback mCancelCbaCallback;

    public SmartcardCertPickerDialog(@NonNull List<ClientCertAuthChallengeHandler.YubiKitCertDetails> certList, @NonNull PositiveButtonListener positiveButtonListener, @NonNull CancelCbaCallback cancelCbaCallback, @NonNull Activity activity) {
        super(activity);
        this.mCertList = certList;
        this.mPositiveButtonListener = positiveButtonListener;
        this.mCancelCbaCallback = cancelCbaCallback;
        this.createDialog();
    }

    @Override
    protected void createDialog() {
        final CertDetailsAdapter certAdapter = new CertDetailsAdapter((Context)this.mActivity, this.mCertList);
        this.mActivity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                AlertDialog.Builder builder = new AlertDialog.Builder((Context)SmartcardCertPickerDialog.this.mActivity, R.style.CertAlertDialogTheme).setTitle(R.string.smartcard_cert_dialog_title).setSingleChoiceItems((ListAdapter)certAdapter, 0, null).setPositiveButton(R.string.smartcard_cert_dialog_positive_button, new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        int checkedPosition = ((AlertDialog)dialog).getListView().getCheckedItemPosition();
                        ClientCertAuthChallengeHandler.YubiKitCertDetails certDetails = (ClientCertAuthChallengeHandler.YubiKitCertDetails)certAdapter.getItem(checkedPosition);
                        SmartcardCertPickerDialog.this.mPositiveButtonListener.onClick(certDetails);
                    }
                }).setNegativeButton(R.string.smartcard_cert_dialog_negative_button, new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        SmartcardCertPickerDialog.this.mCancelCbaCallback.onCancel();
                    }
                });
                AlertDialog alertDialog = builder.create();
                final ListView listView = alertDialog.getListView();
                listView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

                    public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                        listView.setItemChecked(position, true);
                        certAdapter.notifyDataSetChanged();
                    }
                });
                alertDialog.setCanceledOnTouchOutside(false);
                alertDialog.setOnCancelListener(new DialogInterface.OnCancelListener(){

                    public void onCancel(DialogInterface dialog) {
                        SmartcardCertPickerDialog.this.mCancelCbaCallback.onCancel();
                    }
                });
                SmartcardCertPickerDialog.this.mDialog = alertDialog;
            }
        });
    }

    @Override
    public void onCancelCba() {
        this.mCancelCbaCallback.onCancel();
    }

    public static class CertDetailsAdapter
    extends ArrayAdapter<ClientCertAuthChallengeHandler.YubiKitCertDetails> {
        public CertDetailsAdapter(@NonNull Context context, @NonNull List<ClientCertAuthChallengeHandler.YubiKitCertDetails> certs) {
            super(context, 0, certs);
        }

        @NonNull
        public View getView(int position, @Nullable View convertView, @NonNull ViewGroup parent) {
            View item = convertView;
            if (item == null) {
                item = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.certificate_row_layout, parent, false);
            }
            TextView subjectText = (TextView)item.findViewById(R.id.subjectText);
            TextView issuerText = (TextView)item.findViewById(R.id.issuerText);
            X509Certificate currentCert = ((ClientCertAuthChallengeHandler.YubiKitCertDetails)this.getItem(position)).getCertificate();
            subjectText.setText((CharSequence)currentCert.getSubjectDN().getName());
            issuerText.setText((CharSequence)currentCert.getIssuerDN().getName());
            ListView listView = (ListView)parent;
            RadioButton radioButton = (RadioButton)item.findViewById(R.id.radioButton);
            radioButton.setChecked(position == listView.getCheckedItemPosition());
            return item;
        }
    }

    public static interface CancelCbaCallback {
        public void onCancel();
    }

    public static interface PositiveButtonListener {
        public void onClick(@NonNull ClientCertAuthChallengeHandler.YubiKitCertDetails var1);
    }
}

