/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.ui.webview.challengehandlers;

import android.app.Activity;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.microsoft.identity.common.internal.ui.webview.challengehandlers.ClientCertAuthChallengeHandler;
import com.microsoft.identity.common.internal.ui.webview.challengehandlers.SmartcardCertPickerDialog;
import com.microsoft.identity.common.internal.ui.webview.challengehandlers.SmartcardDialog;
import com.microsoft.identity.common.internal.ui.webview.challengehandlers.SmartcardErrorDialog;
import com.microsoft.identity.common.internal.ui.webview.challengehandlers.SmartcardPinDialog;
import java.util.List;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class DialogHolder {
    private final Activity mActivity;
    private SmartcardDialog mCurrentDialog;

    DialogHolder(@NonNull Activity activity) {
        this.mActivity = activity;
        this.mCurrentDialog = null;
    }

    public synchronized void showCertPickerDialog(@NonNull List<ClientCertAuthChallengeHandler.YubiKitCertDetails> certList, @NonNull SmartcardCertPickerDialog.PositiveButtonListener positiveButtonListener, @NonNull SmartcardCertPickerDialog.CancelCbaCallback cancelCbaCallback) {
        SmartcardCertPickerDialog certPickerDialog = new SmartcardCertPickerDialog(certList, positiveButtonListener, cancelCbaCallback, this.mActivity);
        this.showDialog(certPickerDialog);
    }

    public synchronized void showPinDialog(@NonNull SmartcardPinDialog.PositiveButtonListener positiveButtonListener, @NonNull SmartcardPinDialog.CancelCbaCallback cancelCbaCallback) {
        SmartcardPinDialog pinDialog = new SmartcardPinDialog(positiveButtonListener, cancelCbaCallback, this.mActivity);
        this.showDialog(pinDialog);
    }

    public synchronized void showErrorDialog(int titleStringResourceId, int messageStringResourceId) {
        this.showDialog(new SmartcardErrorDialog(titleStringResourceId, messageStringResourceId, new SmartcardErrorDialog.DismissCallback(){

            @Override
            public void onClick() {
                DialogHolder.this.dismissDialog();
            }
        }, this.mActivity));
    }

    public synchronized void dismissDialog() {
        this.showDialog(null);
    }

    public synchronized void showDialog(@Nullable SmartcardDialog dialog) {
        if (this.mCurrentDialog != null) {
            this.mCurrentDialog.dismiss();
        }
        this.mCurrentDialog = dialog;
        if (this.mCurrentDialog != null) {
            this.mCurrentDialog.show();
        }
    }

    public synchronized boolean isDialogShowing() {
        return this.mCurrentDialog != null;
    }

    public synchronized void onCancelCba() {
        if (this.mCurrentDialog != null) {
            this.mCurrentDialog.onCancelCba();
        }
    }

    @RequiresApi(api=21)
    public synchronized void setPinDialogErrorMode() {
        if (this.mCurrentDialog instanceof SmartcardPinDialog) {
            ((SmartcardPinDialog)this.mCurrentDialog).setErrorMode();
        }
    }
}

