/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.ui.webview.challengehandlers;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.security.KeyChain;
import android.security.KeyChainAliasCallback;
import android.security.KeyChainException;
import android.webkit.ClientCertRequest;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import com.microsoft.identity.common.R;
import com.microsoft.identity.common.internal.telemetry.Telemetry;
import com.microsoft.identity.common.internal.ui.webview.challengehandlers.DialogHolder;
import com.microsoft.identity.common.internal.ui.webview.challengehandlers.IChallengeHandler;
import com.microsoft.identity.common.internal.ui.webview.challengehandlers.SmartcardCertPickerDialog;
import com.microsoft.identity.common.internal.ui.webview.challengehandlers.SmartcardPinDialog;
import com.microsoft.identity.common.java.exception.BaseException;
import com.microsoft.identity.common.java.providers.RawAuthorizationResult;
import com.microsoft.identity.common.java.telemetry.events.BaseEvent;
import com.microsoft.identity.common.java.telemetry.events.CertBasedAuthResultEvent;
import com.microsoft.identity.common.java.telemetry.events.ErrorEvent;
import com.microsoft.identity.common.java.telemetry.events.PivProviderStatusEvent;
import com.microsoft.identity.common.logging.Logger;
import com.yubico.yubikit.android.YubiKitManager;
import com.yubico.yubikit.android.transport.usb.UsbConfiguration;
import com.yubico.yubikit.android.transport.usb.UsbYubiKeyDevice;
import com.yubico.yubikit.android.transport.usb.connection.UsbSmartCardConnection;
import com.yubico.yubikit.core.application.ApplicationNotAvailableException;
import com.yubico.yubikit.core.application.BadResponseException;
import com.yubico.yubikit.core.smartcard.ApduException;
import com.yubico.yubikit.core.smartcard.SmartCardConnection;
import com.yubico.yubikit.core.util.Callback;
import com.yubico.yubikit.core.util.Result;
import com.yubico.yubikit.piv.InvalidPinException;
import com.yubico.yubikit.piv.PivSession;
import com.yubico.yubikit.piv.Slot;
import com.yubico.yubikit.piv.jca.PivPrivateKey;
import com.yubico.yubikit.piv.jca.PivProvider;
import java.io.IOException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import javax.annotation.Nonnull;

public final class ClientCertAuthChallengeHandler
implements IChallengeHandler<ClientCertRequest, Void> {
    private static final String TAG = ClientCertAuthChallengeHandler.class.getSimpleName();
    private static final String ACCEPTABLE_ISSUER = "CN=MS-Organization-Access";
    private static final String MDEVICE_NULL_ERROR_MESSAGE = "Instance UsbYubiKitDevice variable (mDevice) is null.";
    private static final String YUBIKEY_PROVIDER = "YKPiv";
    private final Activity mActivity;
    private final YubiKitManager mYubiKitManager;
    private UsbYubiKeyDevice mDevice;
    private final DialogHolder mDialogHolder;
    private static final Object sDeviceLock = new Object();
    private boolean mIsOnDeviceCertBasedAuthProceeding;
    private boolean mIsSmartcardCertBasedAuthProceeding;

    public ClientCertAuthChallengeHandler(@NonNull Activity activity) {
        this.mActivity = activity;
        this.mDialogHolder = new DialogHolder(this.mActivity);
        this.mIsOnDeviceCertBasedAuthProceeding = false;
        this.mIsSmartcardCertBasedAuthProceeding = false;
        this.mYubiKitManager = new YubiKitManager(this.mActivity.getApplicationContext());
        this.mYubiKitManager.startUsbDiscovery(new UsbConfiguration(), (Callback)new Callback<UsbYubiKeyDevice>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void invoke(@NonNull UsbYubiKeyDevice device) {
                Logger.verbose(TAG, "A YubiKey device was connected");
                Object object = sDeviceLock;
                synchronized (object) {
                    ClientCertAuthChallengeHandler.this.mDevice = device;
                    ClientCertAuthChallengeHandler.this.mDialogHolder.dismissDialog();
                    ClientCertAuthChallengeHandler.this.mDevice.setOnClosed(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            Object object = sDeviceLock;
                            synchronized (object) {
                                Logger.verbose(TAG, "A YubiKey device was disconnected");
                                ClientCertAuthChallengeHandler.this.mDevice = null;
                                PivProviderStatusEvent pivProviderStatusEvent = new PivProviderStatusEvent();
                                if (Security.getProvider(ClientCertAuthChallengeHandler.YUBIKEY_PROVIDER) != null) {
                                    Security.removeProvider(ClientCertAuthChallengeHandler.YUBIKEY_PROVIDER);
                                    Telemetry.emit((BaseEvent)pivProviderStatusEvent.putPivProviderRemoved(true));
                                    Logger.info(TAG, "An instance of PivProvider was removed from Security static list upon YubiKey device connection being closed.");
                                } else {
                                    Telemetry.emit((BaseEvent)pivProviderStatusEvent.putPivProviderRemoved(false));
                                    Logger.info(TAG, "An instance of PivProvider was not present in Security static list upon YubiKey device connection being closed.");
                                }
                                if (ClientCertAuthChallengeHandler.this.mDialogHolder.isDialogShowing()) {
                                    ClientCertAuthChallengeHandler.this.mDialogHolder.onCancelCba();
                                    ClientCertAuthChallengeHandler.this.mDialogHolder.showErrorDialog(R.string.smartcard_early_unplug_dialog_title, R.string.smartcard_early_unplug_dialog_message);
                                    Logger.verbose(TAG, "YubiKey was disconnected while dialog was still displayed.");
                                }
                            }
                        }
                    });
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @RequiresApi(api=21)
    public Void processChallenge(@NonNull ClientCertRequest request) {
        Object object = sDeviceLock;
        synchronized (object) {
            if (this.mDevice != null) {
                this.handleSmartcardCertAuth(request);
                return null;
            }
        }
        this.handleOnDeviceCertAuth(request);
        return null;
    }

    @RequiresApi(api=21)
    private void handleSmartcardCertAuth(final @NonNull ClientCertRequest request) {
        final String methodTag = TAG + ":handleSmartcardCertAuth";
        this.getActivePivSessionAsync(request, new IPivSessionCallback(){

            @Override
            public void onGetSession(@NonNull PivSession piv) {
                try {
                    if (piv.getPinAttempts() == 0) {
                        Logger.info(methodTag, "User has reached the maximum failed attempts allowed.");
                        ClientCertAuthChallengeHandler.this.mDialogHolder.showErrorDialog(R.string.smartcard_max_attempt_dialog_title, R.string.smartcard_max_attempt_dialog_message);
                        request.cancel();
                        return;
                    }
                    List certList = ClientCertAuthChallengeHandler.this.getCertDetailsFromKey(piv);
                    if (certList.isEmpty()) {
                        Logger.info(methodTag, "No PIV certificates found on YubiKey device.");
                        ClientCertAuthChallengeHandler.this.mDialogHolder.showErrorDialog(R.string.smartcard_no_cert_dialog_title, R.string.smartcard_no_cert_dialog_message);
                        request.cancel();
                        return;
                    }
                    ClientCertAuthChallengeHandler.this.mDialogHolder.showCertPickerDialog(certList, ClientCertAuthChallengeHandler.this.getSmartcardCertPickerDialogPositiveButtonListener(request), new SmartcardCertPickerDialog.CancelCbaCallback(){

                        @Override
                        @RequiresApi(api=21)
                        public void onCancel() {
                            ClientCertAuthChallengeHandler.this.mDialogHolder.dismissDialog();
                            request.cancel();
                        }
                    });
                }
                catch (BadResponseException | ApduException | IOException e) {
                    Logger.error(methodTag, e.getMessage(), e);
                    ClientCertAuthChallengeHandler.this.mDialogHolder.showErrorDialog(R.string.smartcard_general_error_dialog_title, R.string.smartcard_general_error_dialog_message);
                    Telemetry.emit((BaseEvent)new ErrorEvent().putException((Exception)e));
                    request.cancel();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresApi(api=21)
    private void getActivePivSessionAsync(final @NonNull ClientCertRequest request, final @NonNull IPivSessionCallback callback) {
        final String methodTag = TAG + "getActivePivSessionAsync:";
        Object object = sDeviceLock;
        synchronized (object) {
            if (this.mDevice == null) {
                Logger.error(methodTag, MDEVICE_NULL_ERROR_MESSAGE, null);
                this.mDialogHolder.showErrorDialog(R.string.smartcard_general_error_dialog_title, R.string.smartcard_general_error_dialog_message);
                request.cancel();
                return;
            }
            this.mDevice.requestConnection(UsbSmartCardConnection.class, (Callback)new Callback<Result<UsbSmartCardConnection, IOException>>(){

                public void invoke(@NonNull Result<UsbSmartCardConnection, IOException> value) {
                    try {
                        SmartCardConnection c = (SmartCardConnection)value.getValue();
                        PivSession piv = new PivSession(c);
                        callback.onGetSession(piv);
                    }
                    catch (ApplicationNotAvailableException | ApduException | IOException e) {
                        Logger.error(methodTag, e.getMessage(), e);
                        ClientCertAuthChallengeHandler.this.mDialogHolder.showErrorDialog(R.string.smartcard_general_error_dialog_title, R.string.smartcard_general_error_dialog_message);
                        Telemetry.emit((BaseEvent)new ErrorEvent().putException((Exception)e));
                        request.cancel();
                    }
                }
            });
        }
    }

    private List<YubiKitCertDetails> getCertDetailsFromKey(@NonNull PivSession piv) throws IOException, ApduException, BadResponseException {
        ArrayList<YubiKitCertDetails> certList = new ArrayList<YubiKitCertDetails>();
        this.getAndPutCertDetailsInList(Slot.AUTHENTICATION, piv, certList);
        this.getAndPutCertDetailsInList(Slot.SIGNATURE, piv, certList);
        this.getAndPutCertDetailsInList(Slot.KEY_MANAGEMENT, piv, certList);
        this.getAndPutCertDetailsInList(Slot.CARD_AUTH, piv, certList);
        return certList;
    }

    private void getAndPutCertDetailsInList(@NonNull Slot slot, @NonNull PivSession piv, @NonNull List<YubiKitCertDetails> certList) throws IOException, ApduException, BadResponseException {
        String methodTag = TAG + ":getAndPutCertDetailsInList";
        try {
            X509Certificate cert = piv.getCertificate(slot);
            certList.add(new YubiKitCertDetails(cert, slot));
        }
        catch (ApduException e) {
            if (e.getSw() == 27266) {
                Logger.verbose(methodTag, slot + " slot is empty.");
            }
            throw e;
        }
    }

    private SmartcardCertPickerDialog.PositiveButtonListener getSmartcardCertPickerDialogPositiveButtonListener(final @NonNull ClientCertRequest request) {
        return new SmartcardCertPickerDialog.PositiveButtonListener(){

            @Override
            @RequiresApi(api=21)
            public void onClick(@NonNull YubiKitCertDetails certDetails) {
                ClientCertAuthChallengeHandler.this.mDialogHolder.showPinDialog(ClientCertAuthChallengeHandler.this.getSmartcardPinDialogPositiveButtonListener(certDetails, request), new SmartcardPinDialog.CancelCbaCallback(){

                    @Override
                    @RequiresApi(api=21)
                    public void onCancel() {
                        ClientCertAuthChallengeHandler.this.mDialogHolder.dismissDialog();
                        request.cancel();
                    }
                });
            }
        };
    }

    private SmartcardPinDialog.PositiveButtonListener getSmartcardPinDialogPositiveButtonListener(final @NonNull YubiKitCertDetails certDetails, final @NonNull ClientCertRequest request) {
        final String methodTag = TAG + ":getSmartcardPinDialogPositiveButtonListener";
        return new SmartcardPinDialog.PositiveButtonListener(){

            @Override
            @RequiresApi(api=21)
            public void onClick(final @NonNull char[] pin) {
                ClientCertAuthChallengeHandler.this.getActivePivSessionAsync(request, new IPivSessionCallback(){

                    @Override
                    public void onGetSession(@NonNull PivSession piv) {
                        try {
                            ClientCertAuthChallengeHandler.this.tryUsingSmartcardWithPin(pin, certDetails, request, piv);
                        }
                        catch (BadResponseException | ApduException | IOException e) {
                            Logger.error(methodTag, e.getMessage(), e);
                            ClientCertAuthChallengeHandler.this.mDialogHolder.showErrorDialog(R.string.smartcard_general_error_dialog_title, R.string.smartcard_general_error_dialog_message);
                            Telemetry.emit((BaseEvent)new ErrorEvent().putException((Exception)e));
                            request.cancel();
                        }
                        finally {
                            ClientCertAuthChallengeHandler.this.clearPin(pin);
                        }
                    }
                });
            }
        };
    }

    @RequiresApi(api=21)
    private void tryUsingSmartcardWithPin(@NonNull char[] pin, @NonNull YubiKitCertDetails certDetails, @NonNull ClientCertRequest request, @NonNull PivSession piv) throws IOException, ApduException, BadResponseException {
        String methodTag = TAG + ":tryUsingSmartcardWithPin";
        try {
            piv.verifyPin(pin);
            this.useSmartcardCertForAuth(certDetails.getCertificate(), pin, certDetails.getSlot().getStringAlias(), piv, request);
        }
        catch (InvalidPinException e) {
            int pinAttemptsRemaining = piv.getPinAttempts();
            if (pinAttemptsRemaining == 0) {
                Logger.info(methodTag, "User has reached the maximum failed attempts allowed.");
                this.mDialogHolder.showErrorDialog(R.string.smartcard_max_attempt_dialog_title, R.string.smartcard_max_attempt_dialog_message);
                request.cancel();
            }
            this.mDialogHolder.setPinDialogErrorMode();
        }
    }

    @RequiresApi(api=21)
    private void useSmartcardCertForAuth(@NonNull X509Certificate cert, @NonNull char[] pin, @NonNull String slotAlias, @NonNull PivSession piv, @NonNull ClientCertRequest request) {
        String methodTag = TAG + "useSmartcardCertForAuth:";
        PivProviderStatusEvent pivProviderStatusEvent = new PivProviderStatusEvent();
        if (Security.getProvider(YUBIKEY_PROVIDER) != null) {
            Security.removeProvider(YUBIKEY_PROVIDER);
            Telemetry.emit((BaseEvent)pivProviderStatusEvent.putIsExistingPivProviderPresent(true));
            Logger.info(methodTag, "Existing PivProvider was present in Security static list.");
        } else {
            Telemetry.emit((BaseEvent)pivProviderStatusEvent.putIsExistingPivProviderPresent(false));
            Logger.info(methodTag, "Security static list does not have existing PivProvider.");
        }
        Security.insertProviderAt((Provider)new PivProvider(this.getPivProviderCallback()), 1);
        Logger.info(methodTag, "An instance of PivProvider was added to Security static list.");
        try {
            KeyStore keyStore = KeyStore.getInstance(YUBIKEY_PROVIDER, (Provider)new PivProvider(piv));
            keyStore.load(null);
            Key key = keyStore.getKey(slotAlias, pin);
            if (!(key instanceof PivPrivateKey)) {
                Logger.error(methodTag, "Private key retrieved from YKPiv keystore is not of type PivPrivateKey.", null);
                this.mDialogHolder.showErrorDialog(R.string.smartcard_general_error_dialog_title, R.string.smartcard_general_error_dialog_message);
                request.cancel();
                return;
            }
            PivPrivateKey pivPrivateKey = (PivPrivateKey)key;
            X509Certificate[] chain = new X509Certificate[]{cert};
            this.mDialogHolder.dismissDialog();
            this.mIsSmartcardCertBasedAuthProceeding = true;
            request.proceed((PrivateKey)pivPrivateKey, chain);
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException e) {
            Logger.error(methodTag, e.getMessage(), e);
            this.mDialogHolder.showErrorDialog(R.string.smartcard_general_error_dialog_title, R.string.smartcard_general_error_dialog_message);
            Telemetry.emit((BaseEvent)new ErrorEvent().putException(e));
            request.cancel();
        }
    }

    private void clearPin(@NonNull char[] pin) {
        Arrays.fill(pin, '\u0000');
    }

    private Callback<Callback<Result<PivSession, Exception>>> getPivProviderCallback() {
        final String methodTag = TAG + "getPivProviderCallback:";
        return new Callback<Callback<Result<PivSession, Exception>>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @RequiresApi(api=21)
            public void invoke(final @NonNull Callback<Result<PivSession, Exception>> callback) {
                Object object = sDeviceLock;
                synchronized (object) {
                    if (ClientCertAuthChallengeHandler.this.mDevice == null) {
                        Logger.error(methodTag, ClientCertAuthChallengeHandler.MDEVICE_NULL_ERROR_MESSAGE, null);
                        callback.invoke((Object)Result.failure((Throwable)new Exception(ClientCertAuthChallengeHandler.MDEVICE_NULL_ERROR_MESSAGE)));
                        return;
                    }
                    ClientCertAuthChallengeHandler.this.mDevice.requestConnection(UsbSmartCardConnection.class, (Callback)new Callback<Result<UsbSmartCardConnection, IOException>>(){

                        public void invoke(final @NonNull Result<UsbSmartCardConnection, IOException> value) {
                            callback.invoke((Object)Result.of((Callable)new Callable<PivSession>(){

                                @Override
                                public PivSession call() throws Exception {
                                    return new PivSession((SmartCardConnection)value.getValue());
                                }
                            }));
                        }
                    });
                }
            }
        };
    }

    @TargetApi(value=21)
    private void handleOnDeviceCertAuth(final @NonNull ClientCertRequest request) {
        final String methodTag = TAG + ":handleOnDeviceCertAuth";
        Principal[] acceptableCertIssuers = request.getPrincipals();
        if (acceptableCertIssuers != null) {
            for (Principal issuer : acceptableCertIssuers) {
                if (!issuer.getName().contains(ACCEPTABLE_ISSUER)) continue;
                Logger.info(methodTag, "Cancelling the TLS request, not respond to TLS challenge triggered by device authentication.");
                request.cancel();
                return;
            }
        }
        KeyChain.choosePrivateKeyAlias((Activity)this.mActivity, (KeyChainAliasCallback)new KeyChainAliasCallback(){

            public void alias(String alias) {
                if (alias == null) {
                    Logger.info(methodTag, "No certificate chosen by user, cancelling the TLS request.");
                    request.cancel();
                    return;
                }
                try {
                    X509Certificate[] certChain = KeyChain.getCertificateChain((Context)ClientCertAuthChallengeHandler.this.mActivity.getApplicationContext(), (String)alias);
                    PrivateKey privateKey = KeyChain.getPrivateKey((Context)ClientCertAuthChallengeHandler.this.mActivity, (String)alias);
                    Logger.info(methodTag, "Certificate is chosen by user, proceed with TLS request.");
                    ClientCertAuthChallengeHandler.this.mIsOnDeviceCertBasedAuthProceeding = true;
                    request.proceed(privateKey, certChain);
                    return;
                }
                catch (KeyChainException e) {
                    Logger.errorPII(methodTag, "KeyChain exception", e);
                }
                catch (InterruptedException e) {
                    Logger.errorPII(methodTag, "InterruptedException exception", e);
                }
                request.cancel();
            }
        }, (String[])request.getKeyTypes(), (Principal[])request.getPrincipals(), (String)request.getHost(), (int)request.getPort(), null);
    }

    public void stopYubiKitManagerUsbDiscovery() {
        this.mYubiKitManager.stopUsbDiscovery();
    }

    public void emitTelemetryForCertBasedAuthResults(@NonNull RawAuthorizationResult response) {
        if (this.mIsOnDeviceCertBasedAuthProceeding || this.mIsSmartcardCertBasedAuthProceeding) {
            CertBasedAuthResultEvent certBasedAuthResultEvent;
            if (this.mIsOnDeviceCertBasedAuthProceeding) {
                certBasedAuthResultEvent = new CertBasedAuthResultEvent("cert_based_auth_result_on_device_event");
                this.mIsOnDeviceCertBasedAuthProceeding = false;
            } else {
                certBasedAuthResultEvent = new CertBasedAuthResultEvent("cert_based_auth_result_smartcard_event");
                this.mIsSmartcardCertBasedAuthProceeding = false;
            }
            Telemetry.emit((BaseEvent)certBasedAuthResultEvent.putResponseCode(response.getResultCode().toString()));
            BaseException exception = response.getException();
            if (exception != null) {
                Telemetry.emit((BaseEvent)new ErrorEvent().putException((Exception)exception));
            }
        }
    }

    public static interface IPivSessionCallback {
        public void onGetSession(@NonNull PivSession var1);
    }

    public static class YubiKitCertDetails {
        private final X509Certificate cert;
        private final Slot slot;

        public YubiKitCertDetails(@NonNull X509Certificate cert, @NonNull Slot slot) {
            this.cert = cert;
            this.slot = slot;
        }

        @NonNull
        public X509Certificate getCertificate() {
            return this.cert;
        }

        @Nonnull
        public Slot getSlot() {
            return this.slot;
        }
    }
}

