/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.broker;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.gson.annotations.SerializedName;
import com.microsoft.identity.common.java.authscheme.AbstractAuthenticationScheme;
import com.microsoft.identity.common.java.request.SdkType;
import java.io.Serializable;

public class BrokerRequest
implements Serializable {
    private static final long serialVersionUID = -543392127065130474L;
    @SerializedName(value="authority")
    @NonNull
    private String mAuthority;
    @SerializedName(value="scopes")
    @NonNull
    private String mScope;
    @SerializedName(value="redirect_uri")
    @NonNull
    private String mRedirect;
    @SerializedName(value="client_id")
    @NonNull
    private String mClientId;
    @SerializedName(value="username")
    @Nullable
    private String mUserName;
    @SerializedName(value="home_account_id")
    @Nullable
    private String mHomeAccountId;
    @SerializedName(value="local_account_id")
    private String mLocalAccountId;
    @SerializedName(value="extra_query_param")
    @Nullable
    private String mExtraQueryStringParameter;
    @SerializedName(value="extra_options")
    @Nullable
    private String mExtraOptions;
    @SerializedName(value="correlation_id")
    @NonNull
    private String mCorrelationId;
    @SerializedName(value="prompt")
    @Nullable
    private String mPrompt;
    @SerializedName(value="claims")
    @Nullable
    private String mClaims;
    @SerializedName(value="force_refresh")
    @Nullable
    private boolean mForceRefresh;
    @SerializedName(value="client_app_name")
    @NonNull
    private String mApplicationName;
    @SerializedName(value="client_app_version")
    @NonNull
    private String mApplicationVersion;
    @SerializedName(value="client_version")
    @NonNull
    private String mMsalVersion;
    @SerializedName(value="client_sdk_type")
    @NonNull
    private SdkType mSdkType;
    @SerializedName(value="environment")
    @NonNull
    private String mEnvironment;
    @SerializedName(value="multiple_clouds_supported")
    @NonNull
    private boolean mMultipleCloudsSupported;
    @SerializedName(value="authorization_agent")
    @Nullable
    private String mAuthorizationAgent;
    @SerializedName(value="authentication_scheme")
    @Nullable
    private AbstractAuthenticationScheme mAuthenticationScheme;
    @SerializedName(value="power_opt_check_enabled")
    @Nullable
    private boolean mPowerOptCheckEnabled;

    BrokerRequest(@NonNull String authority, @NonNull String scope, @NonNull String redirect, @NonNull String clientId, @Nullable String userName, @Nullable String homeAccountId, String localAccountId, @Nullable String extraQueryStringParameter, @Nullable String extraOptions, @NonNull String correlationId, @Nullable String prompt, @Nullable String claims, @Nullable boolean forceRefresh, @NonNull String applicationName, @NonNull String applicationVersion, @NonNull String msalVersion, @NonNull SdkType sdkType, @NonNull String environment, @NonNull boolean multipleCloudsSupported, @Nullable String authorizationAgent, @Nullable AbstractAuthenticationScheme authenticationScheme, @Nullable boolean powerOptCheckEnabled) {
        if (authority == null) {
            throw new NullPointerException("authority is marked non-null but is null");
        }
        if (scope == null) {
            throw new NullPointerException("scope is marked non-null but is null");
        }
        if (redirect == null) {
            throw new NullPointerException("redirect is marked non-null but is null");
        }
        if (clientId == null) {
            throw new NullPointerException("clientId is marked non-null but is null");
        }
        if (correlationId == null) {
            throw new NullPointerException("correlationId is marked non-null but is null");
        }
        if (applicationName == null) {
            throw new NullPointerException("applicationName is marked non-null but is null");
        }
        if (applicationVersion == null) {
            throw new NullPointerException("applicationVersion is marked non-null but is null");
        }
        if (msalVersion == null) {
            throw new NullPointerException("msalVersion is marked non-null but is null");
        }
        if (sdkType == null) {
            throw new NullPointerException("sdkType is marked non-null but is null");
        }
        if (environment == null) {
            throw new NullPointerException("environment is marked non-null but is null");
        }
        this.mAuthority = authority;
        this.mScope = scope;
        this.mRedirect = redirect;
        this.mClientId = clientId;
        this.mUserName = userName;
        this.mHomeAccountId = homeAccountId;
        this.mLocalAccountId = localAccountId;
        this.mExtraQueryStringParameter = extraQueryStringParameter;
        this.mExtraOptions = extraOptions;
        this.mCorrelationId = correlationId;
        this.mPrompt = prompt;
        this.mClaims = claims;
        this.mForceRefresh = forceRefresh;
        this.mApplicationName = applicationName;
        this.mApplicationVersion = applicationVersion;
        this.mMsalVersion = msalVersion;
        this.mSdkType = sdkType;
        this.mEnvironment = environment;
        this.mMultipleCloudsSupported = multipleCloudsSupported;
        this.mAuthorizationAgent = authorizationAgent;
        this.mAuthenticationScheme = authenticationScheme;
        this.mPowerOptCheckEnabled = powerOptCheckEnabled;
    }

    public static BrokerRequestBuilder builder() {
        return new BrokerRequestBuilder();
    }

    @NonNull
    public String getAuthority() {
        return this.mAuthority;
    }

    @NonNull
    public String getScope() {
        return this.mScope;
    }

    @NonNull
    public String getRedirect() {
        return this.mRedirect;
    }

    @NonNull
    public String getClientId() {
        return this.mClientId;
    }

    @Nullable
    public String getUserName() {
        return this.mUserName;
    }

    @Nullable
    public String getHomeAccountId() {
        return this.mHomeAccountId;
    }

    public String getLocalAccountId() {
        return this.mLocalAccountId;
    }

    @Nullable
    public String getExtraQueryStringParameter() {
        return this.mExtraQueryStringParameter;
    }

    @Nullable
    public String getExtraOptions() {
        return this.mExtraOptions;
    }

    @NonNull
    public String getCorrelationId() {
        return this.mCorrelationId;
    }

    @Nullable
    public String getPrompt() {
        return this.mPrompt;
    }

    @Nullable
    public String getClaims() {
        return this.mClaims;
    }

    @Nullable
    public boolean isForceRefresh() {
        return this.mForceRefresh;
    }

    @NonNull
    public String getApplicationName() {
        return this.mApplicationName;
    }

    @NonNull
    public String getApplicationVersion() {
        return this.mApplicationVersion;
    }

    @NonNull
    public String getMsalVersion() {
        return this.mMsalVersion;
    }

    @NonNull
    public SdkType getSdkType() {
        return this.mSdkType;
    }

    @NonNull
    public String getEnvironment() {
        return this.mEnvironment;
    }

    @NonNull
    public boolean isMultipleCloudsSupported() {
        return this.mMultipleCloudsSupported;
    }

    @Nullable
    public String getAuthorizationAgent() {
        return this.mAuthorizationAgent;
    }

    @Nullable
    public AbstractAuthenticationScheme getAuthenticationScheme() {
        return this.mAuthenticationScheme;
    }

    @Nullable
    public boolean isPowerOptCheckEnabled() {
        return this.mPowerOptCheckEnabled;
    }

    public static class BrokerRequestBuilder {
        private String authority;
        private String scope;
        private String redirect;
        private String clientId;
        private String userName;
        private String homeAccountId;
        private String localAccountId;
        private String extraQueryStringParameter;
        private String extraOptions;
        private String correlationId;
        private String prompt;
        private String claims;
        private boolean forceRefresh;
        private String applicationName;
        private String applicationVersion;
        private String msalVersion;
        private SdkType sdkType;
        private String environment;
        private boolean multipleCloudsSupported;
        private String authorizationAgent;
        private AbstractAuthenticationScheme authenticationScheme;
        private boolean powerOptCheckEnabled;

        BrokerRequestBuilder() {
        }

        public BrokerRequestBuilder authority(@NonNull String authority) {
            this.authority = authority;
            return this;
        }

        public BrokerRequestBuilder scope(@NonNull String scope) {
            this.scope = scope;
            return this;
        }

        public BrokerRequestBuilder redirect(@NonNull String redirect) {
            this.redirect = redirect;
            return this;
        }

        public BrokerRequestBuilder clientId(@NonNull String clientId) {
            this.clientId = clientId;
            return this;
        }

        public BrokerRequestBuilder userName(@Nullable String userName) {
            this.userName = userName;
            return this;
        }

        public BrokerRequestBuilder homeAccountId(@Nullable String homeAccountId) {
            this.homeAccountId = homeAccountId;
            return this;
        }

        public BrokerRequestBuilder localAccountId(String localAccountId) {
            this.localAccountId = localAccountId;
            return this;
        }

        public BrokerRequestBuilder extraQueryStringParameter(@Nullable String extraQueryStringParameter) {
            this.extraQueryStringParameter = extraQueryStringParameter;
            return this;
        }

        public BrokerRequestBuilder extraOptions(@Nullable String extraOptions) {
            this.extraOptions = extraOptions;
            return this;
        }

        public BrokerRequestBuilder correlationId(@NonNull String correlationId) {
            this.correlationId = correlationId;
            return this;
        }

        public BrokerRequestBuilder prompt(@Nullable String prompt) {
            this.prompt = prompt;
            return this;
        }

        public BrokerRequestBuilder claims(@Nullable String claims) {
            this.claims = claims;
            return this;
        }

        public BrokerRequestBuilder forceRefresh(@Nullable boolean forceRefresh) {
            this.forceRefresh = forceRefresh;
            return this;
        }

        public BrokerRequestBuilder applicationName(@NonNull String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public BrokerRequestBuilder applicationVersion(@NonNull String applicationVersion) {
            this.applicationVersion = applicationVersion;
            return this;
        }

        public BrokerRequestBuilder msalVersion(@NonNull String msalVersion) {
            this.msalVersion = msalVersion;
            return this;
        }

        public BrokerRequestBuilder sdkType(@NonNull SdkType sdkType) {
            this.sdkType = sdkType;
            return this;
        }

        public BrokerRequestBuilder environment(@NonNull String environment) {
            this.environment = environment;
            return this;
        }

        public BrokerRequestBuilder multipleCloudsSupported(@NonNull boolean multipleCloudsSupported) {
            this.multipleCloudsSupported = multipleCloudsSupported;
            return this;
        }

        public BrokerRequestBuilder authorizationAgent(@Nullable String authorizationAgent) {
            this.authorizationAgent = authorizationAgent;
            return this;
        }

        public BrokerRequestBuilder authenticationScheme(@Nullable AbstractAuthenticationScheme authenticationScheme) {
            this.authenticationScheme = authenticationScheme;
            return this;
        }

        public BrokerRequestBuilder powerOptCheckEnabled(@Nullable boolean powerOptCheckEnabled) {
            this.powerOptCheckEnabled = powerOptCheckEnabled;
            return this;
        }

        public BrokerRequest build() {
            return new BrokerRequest(this.authority, this.scope, this.redirect, this.clientId, this.userName, this.homeAccountId, this.localAccountId, this.extraQueryStringParameter, this.extraOptions, this.correlationId, this.prompt, this.claims, this.forceRefresh, this.applicationName, this.applicationVersion, this.msalVersion, this.sdkType, this.environment, this.multipleCloudsSupported, this.authorizationAgent, this.authenticationScheme, this.powerOptCheckEnabled);
        }

        public String toString() {
            return "BrokerRequest.BrokerRequestBuilder(authority=" + this.authority + ", scope=" + this.scope + ", redirect=" + this.redirect + ", clientId=" + this.clientId + ", userName=" + this.userName + ", homeAccountId=" + this.homeAccountId + ", localAccountId=" + this.localAccountId + ", extraQueryStringParameter=" + this.extraQueryStringParameter + ", extraOptions=" + this.extraOptions + ", correlationId=" + this.correlationId + ", prompt=" + this.prompt + ", claims=" + this.claims + ", forceRefresh=" + this.forceRefresh + ", applicationName=" + this.applicationName + ", applicationVersion=" + this.applicationVersion + ", msalVersion=" + this.msalVersion + ", sdkType=" + this.sdkType + ", environment=" + this.environment + ", multipleCloudsSupported=" + this.multipleCloudsSupported + ", authorizationAgent=" + this.authorizationAgent + ", authenticationScheme=" + this.authenticationScheme + ", powerOptCheckEnabled=" + this.powerOptCheckEnabled + ")";
        }
    }

    private static final class SerializedNames {
        static final String EXTRA_OPTIONS = "extra_options";
        static final String AUTHORITY = "authority";
        static final String SCOPE = "scopes";
        static final String REDIRECT = "redirect_uri";
        static final String CLIENT_ID = "client_id";
        static final String HOME_ACCOUNT_ID = "home_account_id";
        static final String LOCAL_ACCOUNT_ID = "local_account_id";
        static final String USERNAME = "username";
        static final String EXTRA_QUERY_STRING_PARAMETER = "extra_query_param";
        static final String CORRELATION_ID = "correlation_id";
        static final String PROMPT = "prompt";
        static final String CLAIMS = "claims";
        static final String FORCE_REFRESH = "force_refresh";
        static final String CLIENT_APP_NAME = "client_app_name";
        static final String CLIENT_APP_VERSION = "client_app_version";
        static final String CLIENT_VERSION = "client_version";
        static final String CLIENT_SDK_TYPE = "client_sdk_type";
        static final String ENVIRONMENT = "environment";
        static final String MULTIPLE_CLOUDS_SUPPORTED = "multiple_clouds_supported";
        static final String AUTHORIZATION_AGENT = "authorization_agent";
        static final String AUTHENTICATION_SCHEME = "authentication_scheme";
        static final String POWER_OPT_CHECK_ENABLED = "power_opt_check_enabled";

        private SerializedNames() {
        }
    }
}

