/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.crypto;

import android.content.Context;
import android.content.SharedPreferences;
import android.preference.PreferenceManager;
import androidx.annotation.Nullable;
import com.microsoft.identity.common.adal.internal.AuthenticationSettings;
import com.microsoft.identity.common.crypto.AndroidWrappedKeyLoader;
import com.microsoft.identity.common.java.crypto.StorageEncryptionManager;
import com.microsoft.identity.common.java.crypto.key.AbstractSecretKeyLoader;
import com.microsoft.identity.common.java.crypto.key.PredefinedKeyLoader;
import com.microsoft.identity.common.java.telemetry.ITelemetryCallback;
import com.microsoft.identity.common.logging.Logger;
import java.util.ArrayList;
import java.util.List;
import lombok.NonNull;

public class AndroidBrokerStorageEncryptionManager
extends StorageEncryptionManager {
    private static final String TAG = AndroidBrokerStorageEncryptionManager.class.getSimpleName();
    static final String KEY_STORE_ALIAS = "AdalKey";
    private static final String CURRENT_ACTIVE_BROKER_SHARED_PREF_KEY = "current_active_broker";
    protected final String LEGACY_AUTHENTICATOR_APP_KEY_ALIAS = "LEGACY_AUTHENTICATOR_APP_KEY";
    protected final String LEGACY_COMPANY_PORTAL_KEY_ALIAS = "LEGACY_COMPANY_PORTAL_KEY";
    private final Context mContext;
    private final ITelemetryCallback mTelemetryCallback;
    private final PredefinedKeyLoader mLegacyAuthAppKeyLoader;
    private final PredefinedKeyLoader mLegacyCPKeyLoader;
    private final AndroidWrappedKeyLoader mKeyStoreKeyLoader;

    public AndroidBrokerStorageEncryptionManager(@NonNull Context context, @Nullable ITelemetryCallback telemetryCallback) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        this.mContext = context;
        this.mTelemetryCallback = telemetryCallback;
        this.mLegacyAuthAppKeyLoader = new PredefinedKeyLoader("LEGACY_AUTHENTICATOR_APP_KEY", AuthenticationSettings.INSTANCE.getBrokerSecretKeys().get("com.azure.authenticator"));
        this.mLegacyCPKeyLoader = new PredefinedKeyLoader("LEGACY_COMPANY_PORTAL_KEY", AuthenticationSettings.INSTANCE.getBrokerSecretKeys().get("com.microsoft.windowsintune.companyportal"));
        this.mKeyStoreKeyLoader = new AndroidWrappedKeyLoader(KEY_STORE_ALIAS, context, telemetryCallback);
    }

    protected String getPackageName() {
        return this.mContext.getPackageName();
    }

    @NonNull
    public AbstractSecretKeyLoader getKeyLoaderForEncryption() {
        String packageName = this.getPackageName();
        if ("com.azure.authenticator".equalsIgnoreCase(packageName)) {
            return this.mLegacyAuthAppKeyLoader;
        }
        if ("com.microsoft.windowsintune.companyportal".equalsIgnoreCase(packageName) || "com.microsoft.identity.testuserapp".equalsIgnoreCase(packageName)) {
            return this.mLegacyCPKeyLoader;
        }
        throw new IllegalStateException("Matching encryption key not found, package name in use was " + packageName);
    }

    @NonNull
    public List<AbstractSecretKeyLoader> getKeyLoaderForDecryption(@NonNull byte[] cipherText) {
        if (cipherText == null) {
            throw new NullPointerException("cipherText is marked non-null but is null");
        }
        String methodTag = TAG + ":getKeyLoaderForDecryption";
        String packageName = this.getPackageName();
        ArrayList<AbstractSecretKeyLoader> keyLoaders = new ArrayList<AbstractSecretKeyLoader>();
        if (AndroidBrokerStorageEncryptionManager.isEncryptedByThisKeyIdentifier((byte[])cipherText, (String)"U001")) {
            if ("com.microsoft.windowsintune.companyportal".equalsIgnoreCase(packageName) || "com.microsoft.identity.testuserapp".equalsIgnoreCase(packageName)) {
                keyLoaders.add((AbstractSecretKeyLoader)this.mLegacyCPKeyLoader);
                keyLoaders.add((AbstractSecretKeyLoader)this.mLegacyAuthAppKeyLoader);
                return keyLoaders;
            }
            if ("com.azure.authenticator".equalsIgnoreCase(packageName)) {
                keyLoaders.add((AbstractSecretKeyLoader)this.mLegacyAuthAppKeyLoader);
                keyLoaders.add((AbstractSecretKeyLoader)this.mLegacyCPKeyLoader);
                return keyLoaders;
            }
            Logger.warn(methodTag, "Unexpected Broker package name. Cannot load key.");
            throw new IllegalStateException("Unexpected Broker package name. Cannot load key.");
        }
        if (AndroidBrokerStorageEncryptionManager.isEncryptedByThisKeyIdentifier((byte[])cipherText, (String)"A001")) {
            keyLoaders.add((AbstractSecretKeyLoader)this.mKeyStoreKeyLoader);
            return keyLoaders;
        }
        Logger.warn(methodTag, "Cannot find a matching key to decrypt the given blob");
        return keyLoaders;
    }

    protected void handleDecryptionFailure(@NonNull String keyAlias, @NonNull Exception exception) {
        String activeBroker;
        if (keyAlias == null) {
            throw new NullPointerException("keyAlias is marked non-null but is null");
        }
        if (exception == null) {
            throw new NullPointerException("exception is marked non-null but is null");
        }
        String methodTag = TAG + ":handleDecryptionFailure";
        SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)this.mContext);
        String previousActiveBroker = sharedPreferences.getString(CURRENT_ACTIVE_BROKER_SHARED_PREF_KEY, "");
        if (!previousActiveBroker.equalsIgnoreCase(activeBroker = this.mContext.getPackageName())) {
            String message = "Decryption failed with key: " + keyAlias + " Active broker: " + activeBroker + " Exception: " + exception.toString();
            Logger.info(methodTag, message);
            if (this.mTelemetryCallback != null) {
                this.mTelemetryCallback.logEvent("decryption_error_v2", Boolean.valueOf(true), message);
            }
            sharedPreferences.edit().putString(CURRENT_ACTIVE_BROKER_SHARED_PREF_KEY, activeBroker).apply();
        }
    }
}

