/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.util;

import android.os.Build;
import com.microsoft.identity.common.java.exception.ClientException;
import com.microsoft.identity.common.java.logging.Logger;
import com.microsoft.identity.common.java.util.ported.DateUtilities;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Locale;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import lombok.NonNull;

public class AndroidKeyStoreUtil {
    private static final String TAG = AndroidKeyStoreUtil.class.getSimpleName();
    private static final String ANDROID_KEY_STORE_TYPE = "AndroidKeyStore";
    private static KeyStore mKeyStore;

    private AndroidKeyStoreUtil() {
    }

    private static synchronized KeyStore getKeyStore() throws KeyStoreException, CertificateException, NoSuchAlgorithmException, IOException {
        if (mKeyStore == null) {
            mKeyStore = KeyStore.getInstance(ANDROID_KEY_STORE_TYPE);
            mKeyStore.load(null);
        }
        return mKeyStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NonNull
    public static synchronized KeyPair generateKeyPair(@NonNull String algorithm, @NonNull AlgorithmParameterSpec algorithmSpec) throws ClientException {
        if (algorithm == null) {
            throw new NullPointerException("algorithm is marked non-null but is null");
        }
        if (algorithmSpec == null) {
            throw new NullPointerException("algorithmSpec is marked non-null but is null");
        }
        String methodTag = TAG + ":generateKeyPair";
        Object object = DateUtilities.isLocaleCalendarNonGregorian((Locale)Locale.getDefault()) ? DateUtilities.LOCALE_CHANGE_LOCK : new Object();
        synchronized (object) {
            Exception exception;
            String errCode;
            Locale currentLocale = Locale.getDefault();
            AndroidKeyStoreUtil.applyKeyStoreLocaleWorkarounds(currentLocale);
            try {
                Logger.info((String)methodTag, (String)"Generating KeyPair from KeyStore");
                KeyPairGenerator generator = KeyPairGenerator.getInstance(algorithm, ANDROID_KEY_STORE_TYPE);
                generator.initialize(algorithmSpec);
                KeyPair keyPair = generator.generateKeyPair();
                if (keyPair == null) {
                    Logger.error((String)methodTag, (String)"Failed to generate a keypair. The way we're generating it might be incorrect.", null);
                    throw new ClientException("invalid_key", "Failed to generate a keypair");
                }
                KeyPair keyPair2 = keyPair;
                return keyPair2;
            }
            catch (IllegalStateException e) {
                errCode = "android_keystore_unavailable";
                exception = e;
            }
            catch (NoSuchAlgorithmException e) {
                errCode = "no_such_algorithm";
                exception = e;
            }
            catch (InvalidAlgorithmParameterException e) {
                errCode = "invalid_algorithm_parameter";
                exception = e;
            }
            catch (NoSuchProviderException e) {
                errCode = "no_such_provider";
                exception = e;
            }
            finally {
                Locale.setDefault(currentLocale);
            }
            ClientException clientException = new ClientException(errCode, exception.getMessage(), (Throwable)exception);
            Logger.error((String)methodTag, (String)errCode, (Throwable)exception);
            throw clientException;
        }
    }

    public static synchronized boolean canLoadKey(@NonNull String keyAlias) {
        if (keyAlias == null) {
            throw new NullPointerException("keyAlias is marked non-null but is null");
        }
        String methodTag = TAG + ":hasKey";
        try {
            return AndroidKeyStoreUtil.getKeyStore().containsAlias(keyAlias);
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            Logger.error((String)methodTag, (String)"Failed to check keystore key", (Throwable)e);
            return false;
        }
    }

    @Nullable
    public static synchronized KeyPair readKey(@NonNull String keyAlias) throws ClientException {
        Exception exception;
        String errCode;
        if (keyAlias == null) {
            throw new NullPointerException("keyAlias is marked non-null but is null");
        }
        String methodTag = TAG + ":readKeyPair";
        Logger.verbose((String)methodTag, (String)"Reading Key from KeyStore");
        try {
            KeyStore keyStore = AndroidKeyStoreUtil.getKeyStore();
            Certificate cert = keyStore.getCertificate(keyAlias);
            Key privateKey = keyStore.getKey(keyAlias, null);
            if (cert == null || privateKey == null) {
                Logger.verbose((String)methodTag, (String)"Key entry doesn't exist.");
                return null;
            }
            Logger.verbose((String)methodTag, (String)"Key read from KeyStore");
            return new KeyPair(cert.getPublicKey(), (PrivateKey)privateKey);
        }
        catch (RuntimeException e) {
            errCode = "android_keystore_unavailable";
            exception = e;
        }
        catch (IOException e) {
            errCode = "io_error";
            exception = e;
        }
        catch (CertificateException e) {
            errCode = "certificate_load_failure";
            exception = e;
        }
        catch (NoSuchAlgorithmException e) {
            errCode = "no_such_algorithm";
            exception = e;
        }
        catch (KeyStoreException e) {
            errCode = "android_keystore_unavailable";
            exception = e;
        }
        catch (UnrecoverableKeyException e) {
            errCode = "invalid_key_private_key_missing";
            exception = e;
        }
        ClientException clientException = new ClientException(errCode, exception.getMessage(), (Throwable)exception);
        Logger.error((String)methodTag, (String)errCode, (Throwable)exception);
        throw clientException;
    }

    private static synchronized void applyKeyStoreLocaleWorkarounds(@NonNull Locale currentLocale) {
        if (currentLocale == null) {
            throw new NullPointerException("currentLocale is marked non-null but is null");
        }
        if (Build.VERSION.SDK_INT <= 23 && DateUtilities.isLocaleCalendarNonGregorian((Locale)currentLocale)) {
            Locale.setDefault(Locale.ENGLISH);
        }
    }

    public static synchronized void deleteKey(@NonNull String aliasOfKeyToDelete) throws ClientException {
        Exception exception;
        String errCode;
        if (aliasOfKeyToDelete == null) {
            throw new NullPointerException("aliasOfKeyToDelete is marked non-null but is null");
        }
        String methodTag = TAG + ":deleteKeyFromKeyStore";
        try {
            KeyStore keyStore = KeyStore.getInstance(ANDROID_KEY_STORE_TYPE);
            keyStore.load(null);
            keyStore.deleteEntry(aliasOfKeyToDelete);
            return;
        }
        catch (KeyStoreException e) {
            errCode = "android_keystore_unavailable";
            exception = e;
        }
        catch (CertificateException e) {
            errCode = "certificate_load_failure";
            exception = e;
        }
        catch (NoSuchAlgorithmException e) {
            errCode = "no_such_algorithm";
            exception = e;
        }
        catch (IOException e) {
            errCode = "io_error";
            exception = e;
        }
        ClientException clientException = new ClientException(errCode, exception.getMessage(), (Throwable)exception);
        Logger.error((String)methodTag, (String)errCode, (Throwable)exception);
        throw clientException;
    }

    public static byte[] wrap(@NonNull SecretKey key, @NonNull KeyPair keyToWrap, @NonNull String wrapAlgorithm) throws ClientException {
        GeneralSecurityException exception;
        String errCode;
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (keyToWrap == null) {
            throw new NullPointerException("keyToWrap is marked non-null but is null");
        }
        if (wrapAlgorithm == null) {
            throw new NullPointerException("wrapAlgorithm is marked non-null but is null");
        }
        String methodTag = TAG + ":wrap";
        try {
            Logger.verbose((String)methodTag, (String)"Wrap secret key with a KeyPair.");
            Cipher wrapCipher = Cipher.getInstance(wrapAlgorithm);
            wrapCipher.init(3, keyToWrap.getPublic());
            return wrapCipher.wrap(key);
        }
        catch (NoSuchPaddingException e) {
            errCode = "no_such_padding";
            exception = e;
        }
        catch (NoSuchAlgorithmException e) {
            errCode = "no_such_algorithm";
            exception = e;
        }
        catch (InvalidKeyException e) {
            errCode = "invalid_key";
            exception = e;
        }
        catch (IllegalBlockSizeException e) {
            errCode = "invalid_block_size";
            exception = e;
        }
        ClientException clientException = new ClientException(errCode, exception.getMessage(), (Throwable)exception);
        Logger.error((String)methodTag, (String)errCode, (Throwable)exception);
        throw clientException;
    }

    public static SecretKey unwrap(@NonNull byte[] wrappedKeyBlob, @NonNull String wrappedKeyAlgorithm, @NonNull KeyPair keyPairForUnwrapping, @NonNull String wrapAlgorithm) throws ClientException {
        Exception exception;
        String errCode;
        if (wrappedKeyBlob == null) {
            throw new NullPointerException("wrappedKeyBlob is marked non-null but is null");
        }
        if (wrappedKeyAlgorithm == null) {
            throw new NullPointerException("wrappedKeyAlgorithm is marked non-null but is null");
        }
        if (keyPairForUnwrapping == null) {
            throw new NullPointerException("keyPairForUnwrapping is marked non-null but is null");
        }
        if (wrapAlgorithm == null) {
            throw new NullPointerException("wrapAlgorithm is marked non-null but is null");
        }
        String methodTag = TAG + ":unwrap";
        try {
            Cipher wrapCipher = Cipher.getInstance(wrapAlgorithm);
            wrapCipher.init(4, keyPairForUnwrapping.getPrivate());
            return (SecretKey)wrapCipher.unwrap(wrappedKeyBlob, wrappedKeyAlgorithm, 3);
        }
        catch (IllegalArgumentException e) {
            errCode = "android_keystore_unavailable";
            exception = e;
        }
        catch (NoSuchPaddingException e) {
            errCode = "no_such_padding";
            exception = e;
        }
        catch (NoSuchAlgorithmException e) {
            errCode = "no_such_algorithm";
            exception = e;
        }
        catch (InvalidKeyException e) {
            errCode = "invalid_key";
            exception = e;
        }
        ClientException clientException = new ClientException(errCode, exception.getMessage(), (Throwable)exception);
        Logger.error((String)methodTag, (String)errCode, (Throwable)exception);
        throw clientException;
    }
}

