/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.platform;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Build;
import android.security.KeyPairGeneratorSpec;
import android.security.keystore.KeyGenParameterSpec;
import android.security.keystore.KeyInfo;
import android.security.keystore.KeyPermanentlyInvalidatedException;
import android.security.keystore.StrongBoxUnavailableException;
import androidx.annotation.RequiresApi;
import com.microsoft.identity.common.adal.internal.cache.StorageHelper;
import com.microsoft.identity.common.internal.platform.AndroidDeviceKeyManager;
import com.microsoft.identity.common.java.crypto.IKeyStoreKeyManager;
import com.microsoft.identity.common.java.crypto.SecureHardwareState;
import com.microsoft.identity.common.java.platform.AbstractDevicePopManager;
import com.microsoft.identity.common.java.util.ported.DateUtilities;
import com.microsoft.identity.common.logging.Logger;
import com.nimbusds.jose.crypto.impl.RSAKeyUtils;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.ProviderException;
import java.security.cert.CertificateException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAKeyGenParameterSpec;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import javax.security.auth.x500.X500Principal;
import lombok.NonNull;

public class AndroidDevicePopManager
extends AbstractDevicePopManager {
    private static final String TAG = AndroidDevicePopManager.class.getSimpleName();
    private static final String ANDROID_KEYSTORE = "AndroidKeyStore";
    public static final String STRONG_BOX_UNAVAILABLE_EXCEPTION = "StrongBoxUnavailableException";
    public static final String FAILED_TO_GENERATE_ATTESTATION_CERTIFICATE_CHAIN = "Failed to generate attestation certificate chain";
    private static final int RSA_KEY_SIZE = 2048;
    private final Context mContext;

    public AndroidDevicePopManager(@NonNull Context context) throws KeyStoreException, CertificateException, NoSuchAlgorithmException, IOException {
        this(context, "microsoft-device-pop");
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
    }

    public AndroidDevicePopManager(@NonNull Context context, @NonNull String alias) throws CertificateException, NoSuchAlgorithmException, KeyStoreException, IOException {
        super(AndroidDevicePopManager.createKeyStoreKeyManager(alias));
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (alias == null) {
            throw new NullPointerException("alias is marked non-null but is null");
        }
        this.mContext = context;
    }

    private static IKeyStoreKeyManager<KeyStore.PrivateKeyEntry> createKeyStoreKeyManager(@NonNull String alias) throws CertificateException, NoSuchAlgorithmException, IOException, KeyStoreException {
        if (alias == null) {
            throw new NullPointerException("alias is marked non-null but is null");
        }
        KeyStore instance = KeyStore.getInstance(ANDROID_KEYSTORE);
        instance.load(null);
        return AndroidDeviceKeyManager.builder().keyAlias(alias).keyStore(instance).build();
    }

    public KeyPair generateNewRsaKeyPair(int keySize) throws UnsupportedOperationException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, NoSuchProviderException {
        return this.generateNewRsaKeyPair(this.mContext, keySize);
    }

    protected SecureHardwareState getSecureHardwareState(@NonNull KeyPair kp) {
        if (kp == null) {
            throw new NullPointerException("kp is marked non-null but is null");
        }
        if (Build.VERSION.SDK_INT >= 23) {
            try {
                PrivateKey privateKey = kp.getPrivate();
                KeyFactory factory = KeyFactory.getInstance(privateKey.getAlgorithm(), ANDROID_KEYSTORE);
                KeyInfo info = factory.getKeySpec(privateKey, KeyInfo.class);
                boolean isInsideSecureHardware = info.isInsideSecureHardware();
                Logger.info(TAG, "SecretKey is secure hardware backed? " + isInsideSecureHardware);
                return isInsideSecureHardware ? SecureHardwareState.TRUE_UNATTESTED : SecureHardwareState.FALSE;
            }
            catch (NoSuchAlgorithmException | NoSuchProviderException | InvalidKeySpecException e) {
                Logger.error(TAG, "Failed to query secure hardware state.", e);
                return SecureHardwareState.UNKNOWN_QUERY_ERROR;
            }
        }
        Logger.info(TAG, "Cannot query secure hardware state (API unavailable <23)");
        return SecureHardwareState.UNKNOWN_DOWNLEVEL;
    }

    protected void performCleanupIfMintShrFails(@NonNull Exception e) {
        if (e == null) {
            throw new NullPointerException("e is marked non-null but is null");
        }
        if (Build.VERSION.SDK_INT >= 23 && e.getCause() instanceof KeyPermanentlyInvalidatedException) {
            Logger.warn(TAG, "Unable to access asymmetric key - clearing.");
            this.clearAsymmetricKey();
        }
    }

    @SuppressLint(value={"NewApi"})
    private KeyPair generateNewRsaKeyPair(@androidx.annotation.NonNull Context context, int minKeySize) throws UnsupportedOperationException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, NoSuchProviderException {
        int MAX_RETRIES = 4;
        for (int ii = 0; ii < 4; ++ii) {
            KeyPair kp = null;
            boolean tryStrongBox = true;
            boolean tryImport = true;
            boolean trySetAttestationChallenge = true;
            boolean generated = false;
            while (!generated) {
                try {
                    kp = this.generateNewKeyPair(context, tryStrongBox, tryImport, trySetAttestationChallenge);
                    generated = true;
                }
                catch (ProviderException e) {
                    if (tryStrongBox && AndroidDevicePopManager.isStrongBoxUnavailableException(e)) {
                        tryStrongBox = false;
                        continue;
                    }
                    if (tryImport && e.getClass().getSimpleName().equals("SecureKeyImportUnavailableException")) {
                        Logger.error(TAG, "Import unsupported - skipping import flags.", e);
                        tryImport = false;
                        if (!tryStrongBox || null == e.getCause() || !AndroidDevicePopManager.isStrongBoxUnavailableException(e.getCause())) continue;
                        tryStrongBox = false;
                        continue;
                    }
                    if (trySetAttestationChallenge && FAILED_TO_GENERATE_ATTESTATION_CERTIFICATE_CHAIN.equalsIgnoreCase(e.getMessage())) {
                        Logger.error(TAG, "Failed to generate attestation cert - skipping flag.", e);
                        trySetAttestationChallenge = false;
                        continue;
                    }
                    this.clearAsymmetricKey();
                    throw e;
                }
            }
            int length = RSAKeyUtils.keyBitLength((PrivateKey)kp.getPrivate());
            if (length < minKeySize && length >= 0) continue;
            this.getSecureHardwareState(kp);
            return kp;
        }
        this.clearAsymmetricKey();
        throw new UnsupportedOperationException("Failed to generate valid KeyPair. Attempted 4 times.");
    }

    private static boolean isStrongBoxUnavailableException(@androidx.annotation.NonNull Throwable t) {
        boolean isStrongBoxException = t.getClass().getSimpleName().equals(STRONG_BOX_UNAVAILABLE_EXCEPTION);
        if (isStrongBoxException) {
            Logger.error(TAG + ":isStrongBoxUnavailableException", "StrongBox not supported.", t);
        }
        return isStrongBoxException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresApi(api=18)
    private KeyPair generateNewKeyPair(@androidx.annotation.NonNull Context context, boolean useStrongbox, boolean enableImport, boolean trySetAttestationChallenge) throws InvalidAlgorithmParameterException, NoSuchAlgorithmException, NoSuchProviderException, StrongBoxUnavailableException {
        Object object = DateUtilities.isLocaleCalendarNonGregorian((Locale)Locale.getDefault()) ? DateUtilities.LOCALE_CHANGE_LOCK : new Object();
        synchronized (object) {
            KeyPair keyPair;
            Locale currentLocale = Locale.getDefault();
            StorageHelper.applyKeyStoreLocaleWorkarounds(currentLocale);
            try {
                KeyPair keyPair2;
                KeyPairGenerator kpg = this.getInitializedRsaKeyPairGenerator(context, 2048, useStrongbox, enableImport, trySetAttestationChallenge);
                keyPair = keyPair2 = kpg.generateKeyPair();
            }
            catch (Throwable throwable) {
                Locale.setDefault(currentLocale);
                throw throwable;
            }
            Locale.setDefault(currentLocale);
            return keyPair;
        }
    }

    @RequiresApi(api=18)
    private KeyPairGenerator getInitializedRsaKeyPairGenerator(@androidx.annotation.NonNull Context context, int keySize, boolean useStrongbox, boolean enableImport, boolean trySetAttestationChallenge) throws InvalidAlgorithmParameterException, NoSuchProviderException, NoSuchAlgorithmException {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA", ANDROID_KEYSTORE);
        this.initialize(context, keyPairGenerator, keySize, useStrongbox, enableImport, trySetAttestationChallenge);
        return keyPairGenerator;
    }

    @RequiresApi(api=18)
    private void initialize(@androidx.annotation.NonNull Context context, @androidx.annotation.NonNull KeyPairGenerator keyPairGenerator, int keySize, boolean useStrongbox, boolean enableImport, boolean trySetAttestationChallenge) throws InvalidAlgorithmParameterException {
        if (Build.VERSION.SDK_INT < 23) {
            this.initializePre23(context, keyPairGenerator, keySize);
        } else if (Build.VERSION.SDK_INT < 28) {
            this.initialize23(keyPairGenerator, keySize, useStrongbox, trySetAttestationChallenge);
        } else {
            this.initialize28(keyPairGenerator, keySize, useStrongbox, enableImport, trySetAttestationChallenge);
        }
    }

    @SuppressLint(value={"InlinedApi"})
    @RequiresApi(api=23)
    private void initialize23(@androidx.annotation.NonNull KeyPairGenerator keyPairGenerator, int keySize, boolean useStrongbox, boolean trySetAttestationChallenge) throws InvalidAlgorithmParameterException {
        KeyGenParameterSpec.Builder builder = new KeyGenParameterSpec.Builder(this.mKeyManager.getKeyAlias(), 15).setKeySize(keySize).setSignaturePaddings(new String[]{"PKCS1"}).setDigests(new String[]{"NONE", "SHA-1", "SHA-256"}).setEncryptionPaddings(new String[]{"OAEPPadding", "PKCS1Padding"});
        if (trySetAttestationChallenge && Build.VERSION.SDK_INT >= 24) {
            builder = this.setAttestationChallenge(builder);
        }
        if (Build.VERSION.SDK_INT >= 28 && useStrongbox) {
            Logger.verbose(TAG, "Attempting to apply StrongBox isolation.");
            builder = AndroidDevicePopManager.applyHardwareIsolation(builder);
        }
        KeyGenParameterSpec spec = builder.build();
        keyPairGenerator.initialize((AlgorithmParameterSpec)spec);
    }

    @SuppressLint(value={"NewApi"})
    @RequiresApi(value=24)
    @androidx.annotation.NonNull
    private KeyGenParameterSpec.Builder setAttestationChallenge(@androidx.annotation.NonNull KeyGenParameterSpec.Builder builder) {
        return builder.setAttestationChallenge(null);
    }

    @SuppressLint(value={"NewApi"})
    @RequiresApi(value=28)
    @androidx.annotation.NonNull
    private static KeyGenParameterSpec.Builder applyHardwareIsolation(@androidx.annotation.NonNull KeyGenParameterSpec.Builder builder) {
        return builder.setIsStrongBoxBacked(true);
    }

    @SuppressLint(value={"InlinedApi"})
    @RequiresApi(api=28)
    private void initialize28(@androidx.annotation.NonNull KeyPairGenerator keyPairGenerator, int keySize, boolean useStrongbox, boolean enableImport, boolean trySetAttestationChallenge) throws InvalidAlgorithmParameterException {
        int purposes = 15;
        if (enableImport && Build.VERSION.SDK_INT >= 28) {
            purposes |= 0x20;
        }
        KeyGenParameterSpec.Builder builder = new KeyGenParameterSpec.Builder(this.mKeyManager.getKeyAlias(), purposes).setKeySize(keySize).setSignaturePaddings(new String[]{"PKCS1"}).setDigests(new String[]{"NONE", "SHA-1", "SHA-256"}).setEncryptionPaddings(new String[]{"OAEPPadding", "PKCS1Padding"});
        if (trySetAttestationChallenge && Build.VERSION.SDK_INT >= 24) {
            builder = this.setAttestationChallenge(builder);
        }
        if (Build.VERSION.SDK_INT >= 28 && useStrongbox) {
            Logger.verbose(TAG, "Attempting to apply StrongBox isolation.");
            builder = AndroidDevicePopManager.applyHardwareIsolation(builder);
        }
        KeyGenParameterSpec spec = builder.build();
        keyPairGenerator.initialize((AlgorithmParameterSpec)spec);
    }

    @SuppressLint(value={"NewApi"})
    @RequiresApi(api=18)
    private void initializePre23(@androidx.annotation.NonNull Context context, @androidx.annotation.NonNull KeyPairGenerator keyPairGenerator, int keySize) throws InvalidAlgorithmParameterException {
        Calendar calendar = Calendar.getInstance();
        Date start = AndroidDevicePopManager.getNow((Calendar)calendar);
        calendar.add(1, 99);
        Date end = calendar.getTime();
        KeyPairGeneratorSpec.Builder specBuilder = new KeyPairGeneratorSpec.Builder(context).setAlias(this.mKeyManager.getKeyAlias()).setStartDate(start).setEndDate(end).setSerialNumber(AbstractDevicePopManager.CertificateProperties.SERIAL_NUMBER).setSubject(new X500Principal("CN=device-pop"));
        if (Build.VERSION.SDK_INT >= 19) {
            specBuilder.setAlgorithmParameterSpec((AlgorithmParameterSpec)new RSAKeyGenParameterSpec(keySize, RSAKeyGenParameterSpec.F4));
        }
        KeyPairGeneratorSpec spec = specBuilder.build();
        keyPairGenerator.initialize((AlgorithmParameterSpec)spec);
    }
}

