/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.ui.browser;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import android.os.Build;
import androidx.annotation.NonNull;
import com.microsoft.identity.common.internal.broker.PackageHelper;
import com.microsoft.identity.common.internal.ui.browser.Browser;
import com.microsoft.identity.common.internal.util.StringUtil;
import com.microsoft.identity.common.java.exception.ClientException;
import com.microsoft.identity.common.java.ui.BrowserDescriptor;
import com.microsoft.identity.common.logging.Logger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class BrowserSelector {
    private static final String TAG = BrowserSelector.class.getSimpleName();
    private static final String SCHEME_HTTP = "http";
    private static final String SCHEME_HTTPS = "https";

    public static Browser select(Context context, List<BrowserDescriptor> browserSafeList) throws ClientException {
        String methodTag = TAG + ":select";
        List<Browser> allBrowsers = BrowserSelector.getAllBrowsers(context);
        Logger.verbose(methodTag, "Select the browser to launch.");
        for (Browser browser : allBrowsers) {
            for (BrowserDescriptor browserDescriptor : browserSafeList) {
                if (!BrowserSelector.matches(browserDescriptor, browser)) continue;
                Logger.info(methodTag, "Browser's package name: " + browser.getPackageName() + " version: " + browser.getVersion());
                return browser;
            }
        }
        Logger.error(methodTag, "No available browser installed on the device.", null);
        throw new ClientException("No available browser installed on the device.", "No available browser installed on the device.");
    }

    private static boolean matches(@NonNull BrowserDescriptor browserDescriptor, @NonNull Browser browser) {
        BrowserDescriptor descriptor;
        try {
            descriptor = browserDescriptor;
        }
        catch (ClassCastException e) {
            Logger.error(TAG + ":matches", "Cannot cast IBrowserDescriptor to BrowserDescriptor", e);
            return false;
        }
        if (!StringUtil.equalsIgnoreCase(descriptor.getPackageName(), browser.getPackageName())) {
            return false;
        }
        if (!descriptor.getSignatureHashes().equals(browser.getSignatureHashes())) {
            return false;
        }
        if (!StringUtil.isEmpty(descriptor.getVersionLowerBound()) && StringUtil.compareSemanticVersion(browser.getVersion(), descriptor.getVersionLowerBound()) == -1) {
            return false;
        }
        return StringUtil.isEmpty(descriptor.getVersionUpperBound()) || StringUtil.compareSemanticVersion(browser.getVersion(), descriptor.getVersionUpperBound()) != 1;
    }

    public static List<Browser> getAllBrowsers(Context context) {
        String methodTag = TAG + ":getAllBrowsers";
        Intent BROWSER_INTENT = new Intent("android.intent.action.VIEW", Uri.parse((String)"http://www.example.com"));
        ArrayList<Browser> browserList = new ArrayList<Browser>();
        PackageManager pm = context.getPackageManager();
        int queryFlag = 64;
        if (Build.VERSION.SDK_INT >= 23) {
            queryFlag |= 0x10000;
        }
        List resolvedActivityList = pm.queryIntentActivities(BROWSER_INTENT, queryFlag);
        for (ResolveInfo info : resolvedActivityList) {
            if (!BrowserSelector.isFullBrowser(info)) continue;
            try {
                PackageInfo packageInfo = PackageHelper.getPackageInfo(pm, info.activityInfo.packageName);
                if (BrowserSelector.isCustomTabsServiceSupported(context, packageInfo)) {
                    browserList.add(new Browser(packageInfo, true));
                    continue;
                }
                browserList.add(new Browser(packageInfo, false));
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {}
        }
        Logger.verbose(methodTag, null, "Found " + browserList.size() + " browsers.");
        return browserList;
    }

    private static boolean isCustomTabsServiceSupported(@NonNull Context context, @NonNull PackageInfo packageInfo) {
        Intent serviceIntent = new Intent("android" + ".support.customtabs.action.CustomTabsService");
        serviceIntent.setPackage(packageInfo.packageName);
        List resolveInfos = context.getPackageManager().queryIntentServices(serviceIntent, 0);
        return resolveInfos != null && !resolveInfos.isEmpty();
    }

    private static boolean isFullBrowser(ResolveInfo resolveInfo) {
        if (!resolveInfo.filter.hasAction("android.intent.action.VIEW") || !resolveInfo.filter.hasCategory("android.intent.category.BROWSABLE") || resolveInfo.filter.schemesIterator() == null) {
            return false;
        }
        if (resolveInfo.filter.authoritiesIterator() != null) {
            return false;
        }
        boolean supportsHttp = false;
        boolean supportsHttps = false;
        Iterator schemeIter = resolveInfo.filter.schemesIterator();
        while (schemeIter.hasNext()) {
            String scheme = (String)schemeIter.next();
            if (!(supportsHttp |= SCHEME_HTTP.equals(scheme)) || !(supportsHttps |= SCHEME_HTTPS.equals(scheme))) continue;
            return true;
        }
        return false;
    }
}

