/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.providers.oauth2;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.microsoft.identity.common.internal.providers.oauth2.BrowserAuthorizationFragment;
import com.microsoft.identity.common.internal.providers.oauth2.CurrentTaskAuthorizationActivity;
import com.microsoft.identity.common.internal.providers.oauth2.CurrentTaskAuthorizationFragment;
import com.microsoft.identity.common.internal.telemetry.Telemetry;
import com.microsoft.identity.common.internal.telemetry.events.UiEndEvent;
import com.microsoft.identity.common.java.exception.BaseException;
import com.microsoft.identity.common.java.exception.ClientException;
import com.microsoft.identity.common.java.providers.RawAuthorizationResult;
import com.microsoft.identity.common.java.telemetry.events.BaseEvent;
import com.microsoft.identity.common.java.util.UrlUtil;
import com.microsoft.identity.common.logging.Logger;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.net.URI;
import java.util.Map;

public class CurrentTaskBrowserAuthorizationFragment
extends CurrentTaskAuthorizationFragment {
    private static final String TAG = BrowserAuthorizationFragment.class.getSimpleName();
    private static final String BROWSER_FLOW_STARTED = "browserFlowStarted";
    private boolean mBrowserFlowStarted = false;
    private Intent mAuthIntent;
    private boolean mResponseReceived = false;

    @Nullable
    public static Intent createCustomTabResponseIntent(@NonNull Context context, @NonNull String responseUri) {
        Intent intent = new Intent(context, CurrentTaskAuthorizationActivity.class);
        intent.setAction("redirect_returned_action");
        intent.addFlags(0x64000000);
        intent.putExtra("RESPONSE_URI", responseUri);
        return intent;
    }

    @Override
    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Bundle arguments = this.getArguments();
        if (arguments != null) {
            this.mResponseReceived = arguments.getBoolean("RESPONSE", false);
        }
    }

    public void onSaveInstanceState(@NonNull Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putParcelable("com.microsoft.identity.auth.intent", (Parcelable)this.mAuthIntent);
        outState.putBoolean(BROWSER_FLOW_STARTED, this.mBrowserFlowStarted);
    }

    @Override
    void extractState(@NonNull Bundle state) {
        super.extractState(state);
        this.mAuthIntent = (Intent)state.getParcelable("com.microsoft.identity.auth.intent");
        this.mBrowserFlowStarted = state.getBoolean(BROWSER_FLOW_STARTED, false);
    }

    public void onResume() {
        super.onResume();
        if (this.mResponseReceived) {
            this.finish();
        }
        if (!this.mBrowserFlowStarted) {
            this.mBrowserFlowStarted = true;
            if (this.mAuthIntent != null) {
                this.startActivity(this.mAuthIntent);
            } else {
                this.sendResult(RawAuthorizationResult.fromException((BaseException)new ClientException("Authorization intent is null.")));
                this.finish();
            }
        } else {
            this.cancelAuthorization(true);
        }
    }

    public void completeAuthorizationInBrowserFlow(@NonNull String customTabResponseUri) {
        String methodTag = TAG + ":completeAuthorizationInBrowserFlow";
        Logger.info(methodTag, null, "Received redirect from customTab/browser.");
        RawAuthorizationResult data = RawAuthorizationResult.fromRedirectUri((String)customTabResponseUri);
        switch (data.getResultCode()) {
            case BROKER_INSTALLATION_TRIGGERED: {
                Map urlQueryParameters = UrlUtil.getParameters((URI)data.getAuthorizationFinalUri());
                String appLink = (String)urlQueryParameters.get("app_link");
                Intent browserIntent = new Intent("android.intent.action.VIEW", Uri.parse((String)appLink));
                this.startActivity(browserIntent);
                break;
            }
            case COMPLETED: {
                Telemetry.emit((BaseEvent)new UiEndEvent().isUiComplete());
                break;
            }
            case CANCELLED: {
                Telemetry.emit((BaseEvent)new UiEndEvent().isUserCancelled());
                break;
            }
        }
        this.sendResult(data);
        this.finish();
    }
}

