/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.providers.oauth2;

import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import com.microsoft.identity.common.internal.providers.oauth2.AuthorizationActivity;
import com.microsoft.identity.common.internal.providers.oauth2.AuthorizationFragment;
import com.microsoft.identity.common.internal.telemetry.Telemetry;
import com.microsoft.identity.common.internal.telemetry.events.UiEndEvent;
import com.microsoft.identity.common.java.logging.IRequestContext;
import com.microsoft.identity.common.java.logging.RequestContext;
import com.microsoft.identity.common.java.providers.RawAuthorizationResult;
import com.microsoft.identity.common.java.telemetry.events.BaseEvent;
import com.microsoft.identity.common.java.util.ported.LocalBroadcaster;
import com.microsoft.identity.common.java.util.ported.PropertyBag;
import com.microsoft.identity.common.logging.DiagnosticContext;
import com.microsoft.identity.common.logging.Logger;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Serializable;

public abstract class CurrentTaskAuthorizationFragment
extends AuthorizationFragment {
    private static final String TAG = CurrentTaskAuthorizationFragment.class.getSimpleName();
    private Bundle mInstanceState;
    private final LocalBroadcaster.IReceiverCallback mCancelRequestReceiver = new LocalBroadcaster.IReceiverCallback(){

        public void onReceive(@NonNull PropertyBag propertyBag) {
            CurrentTaskAuthorizationFragment.this.cancelAuthorization((Boolean)propertyBag.getOrDefault("cancel_authorization_request", (Serializable)Boolean.valueOf(false)));
        }
    };

    @Override
    void setInstanceState(@NonNull Bundle instanceStateBundle) {
        this.mInstanceState = instanceStateBundle;
    }

    @Override
    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    public void onCreate(@Nullable Bundle savedInstanceState) {
        String methodTag = TAG + ":onCreate";
        super.onCreate(savedInstanceState);
        LocalBroadcaster.INSTANCE.registerCallback("cancel_authorization_request", this.mCancelRequestReceiver);
        if (savedInstanceState == null) {
            Logger.verbose(methodTag, "Extract state from the intent bundle.");
            this.extractState(this.mInstanceState);
        } else {
            Logger.verbose(methodTag, "Extract state from the saved bundle.");
            this.extractState(savedInstanceState);
        }
    }

    @Override
    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    void finish() {
        FragmentActivity activity = this.getActivity();
        if (activity instanceof AuthorizationActivity) {
            activity.finish();
        } else if (this.getFragmentManager() != null) {
            this.getFragmentManager().beginTransaction().setTransitionStyle(4099).remove((Fragment)this).commit();
        }
    }

    @Override
    void extractState(@NonNull Bundle state) {
        CurrentTaskAuthorizationFragment.setDiagnosticContextForNewThread(state.getString("correlation_id"));
    }

    private static String setDiagnosticContextForNewThread(@NonNull String correlationId) {
        String methodTag = TAG + ":setDiagnosticContextForAuthorizationActivity";
        RequestContext rc = new RequestContext();
        rc.put((Object)"correlation_id", (Object)correlationId);
        DiagnosticContext.setRequestContext((IRequestContext)rc);
        Logger.verbose(methodTag, "Initializing diagnostic context for CurrentTaskAuthorizationActivity");
        return correlationId;
    }

    @Override
    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    public void onDestroy() {
        LocalBroadcaster.INSTANCE.unregisterCallback("cancel_authorization_request");
        super.onDestroy();
    }

    @Override
    public boolean onBackPressed() {
        return false;
    }

    @Override
    void sendResult(RawAuthorizationResult.ResultCode resultCode) {
        this.sendResult(RawAuthorizationResult.fromResultCode((RawAuthorizationResult.ResultCode)resultCode));
    }

    @Override
    void sendResult(@NonNull RawAuthorizationResult result) {
        String methodTag = TAG + ":sendResult";
        Logger.info(methodTag, "Sending result from Authorization Activity, resultCode: " + result.getResultCode());
        PropertyBag propertyBag = RawAuthorizationResult.toPropertyBag((RawAuthorizationResult)result);
        propertyBag.put("com.microsoft.identity.client.request.code", (Serializable)Integer.valueOf(1001));
        LocalBroadcaster.INSTANCE.broadcast("return_authorization_request_result", propertyBag);
    }

    @Override
    void cancelAuthorization(boolean isCancelledByUser) {
        String methodTag = TAG + ":cancelAuthorization";
        if (isCancelledByUser) {
            Logger.info(methodTag, "Received Authorization flow cancelled by the user");
            this.sendResult(RawAuthorizationResult.ResultCode.CANCELLED);
        } else {
            Logger.info(methodTag, "Received Authorization flow cancel request from SDK");
            this.sendResult(RawAuthorizationResult.ResultCode.SDK_CANCELLED);
        }
        Telemetry.emit((BaseEvent)new UiEndEvent().isUserCancelled());
        this.finish();
    }
}

