/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.platform;

import androidx.annotation.RequiresApi;
import com.microsoft.identity.common.internal.platform.DeviceKeyManager;
import com.microsoft.identity.common.internal.platform.IManagedKeyAccessor;
import com.microsoft.identity.common.java.crypto.CryptoSuite;
import com.microsoft.identity.common.java.crypto.IAndroidKeyStoreKeyManager;
import com.microsoft.identity.common.java.crypto.IKeyAccessor;
import com.microsoft.identity.common.java.crypto.SecureHardwareState;
import com.microsoft.identity.common.java.exception.ClientException;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableEntryException;
import java.security.cert.Certificate;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.GCMParameterSpec;
import lombok.NonNull;

public class SecretKeyAccessor
implements IManagedKeyAccessor<KeyStore.SecretKeyEntry> {
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private final DeviceKeyManager<KeyStore.SecretKeyEntry> mKeyManager;
    private final CryptoSuite suite;

    @RequiresApi(api=19)
    public byte[] encrypt(@NonNull byte[] plaintext) throws ClientException {
        GeneralSecurityException exception;
        String errCode;
        if (plaintext == null) {
            throw new NullPointerException("plaintext is marked non-null but is null");
        }
        try {
            KeyStore.SecretKeyEntry entry = this.mKeyManager.getEntry();
            SecretKey key = entry.getSecretKey();
            Cipher c = Cipher.getInstance(this.suite.cipher().name());
            c.init(1, key);
            byte[] iv = c.getIV();
            byte[] enc = c.doFinal(plaintext);
            byte[] out = new byte[iv.length + enc.length];
            System.arraycopy(iv, 0, out, 0, iv.length);
            System.arraycopy(enc, 0, out, iv.length, enc.length);
            return out;
        }
        catch (UnrecoverableEntryException e) {
            errCode = "protection_params_invalid";
            exception = e;
        }
        catch (NoSuchAlgorithmException e) {
            errCode = "no_such_algorithm";
            exception = e;
        }
        catch (KeyStoreException e) {
            errCode = "keystore_not_initialized";
            exception = e;
        }
        catch (NoSuchPaddingException e) {
            errCode = "no_such_padding";
            exception = e;
        }
        catch (IllegalBlockSizeException e) {
            errCode = "invalid_block_size";
            exception = e;
        }
        catch (BadPaddingException e) {
            errCode = "bad_padding";
            exception = e;
        }
        catch (InvalidKeyException e) {
            errCode = "invalid_key";
            exception = e;
        }
        throw new ClientException(errCode, exception.getMessage(), (Throwable)exception);
    }

    @RequiresApi(api=19)
    public byte[] decrypt(@NonNull byte[] ciphertext) throws ClientException {
        GeneralSecurityException exception;
        String errCode;
        if (ciphertext == null) {
            throw new NullPointerException("ciphertext is marked non-null but is null");
        }
        try {
            KeyStore.SecretKeyEntry entry = this.mKeyManager.getEntry();
            SecretKey key = entry.getSecretKey();
            Cipher c = Cipher.getInstance(this.suite.cipher().name());
            GCMParameterSpec ivSpec = new GCMParameterSpec(128, ciphertext, 0, 12);
            c.init(2, (Key)key, ivSpec);
            byte[] out = Arrays.copyOfRange(ciphertext, 12, ciphertext.length);
            return c.doFinal(out);
        }
        catch (UnrecoverableEntryException e) {
            errCode = "protection_params_invalid";
            exception = e;
        }
        catch (NoSuchAlgorithmException e) {
            errCode = "no_such_algorithm";
            exception = e;
        }
        catch (KeyStoreException e) {
            errCode = "keystore_not_initialized";
            exception = e;
        }
        catch (NoSuchPaddingException e) {
            errCode = "no_such_padding";
            exception = e;
        }
        catch (IllegalBlockSizeException e) {
            errCode = "invalid_block_size";
            exception = e;
        }
        catch (BadPaddingException e) {
            errCode = "bad_padding";
            exception = e;
        }
        catch (InvalidKeyException e) {
            errCode = "invalid_key";
            exception = e;
        }
        catch (InvalidAlgorithmParameterException e) {
            errCode = "invalid_algorithm_parameter";
            exception = e;
        }
        throw new ClientException(errCode, exception.getMessage(), (Throwable)exception);
    }

    public byte[] sign(@NonNull byte[] text) throws ClientException {
        GeneralSecurityException exception;
        String errCode;
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        try {
            KeyStore.SecretKeyEntry entry = this.mKeyManager.getEntry();
            SecretKey key = entry.getSecretKey();
            Mac c = Mac.getInstance(this.suite.macName());
            c.init(key);
            return c.doFinal(text);
        }
        catch (UnrecoverableEntryException e) {
            errCode = "protection_params_invalid";
            exception = e;
        }
        catch (NoSuchAlgorithmException e) {
            errCode = "no_such_algorithm";
            exception = e;
        }
        catch (KeyStoreException e) {
            errCode = "keystore_not_initialized";
            exception = e;
        }
        catch (InvalidKeyException e) {
            errCode = "invalid_key";
            exception = e;
        }
        throw new ClientException(errCode, exception.getMessage(), (Throwable)exception);
    }

    public boolean verify(@NonNull byte[] text, @NonNull byte[] signature) throws ClientException {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        if (signature == null) {
            throw new NullPointerException("signature is marked non-null but is null");
        }
        return Arrays.equals(signature, this.sign(text));
    }

    public byte[] getThumbprint() throws ClientException {
        return this.mKeyManager.getThumbprint();
    }

    public Certificate[] getCertificateChain() throws ClientException {
        return this.mKeyManager.getCertificateChain();
    }

    public SecureHardwareState getSecureHardwareState() throws ClientException {
        return this.mKeyManager.getSecureHardwareState();
    }

    public IKeyAccessor generateDerivedKey(byte[] label, byte[] ctx, CryptoSuite suite) throws ClientException {
        throw new UnsupportedOperationException("This operation is not supported by inaccessible keys");
    }

    @Override
    public IAndroidKeyStoreKeyManager<KeyStore.SecretKeyEntry> getManager() {
        return this.mKeyManager;
    }

    SecretKeyAccessor(DeviceKeyManager<KeyStore.SecretKeyEntry> keyManager, CryptoSuite suite) {
        this.mKeyManager = keyManager;
        this.suite = suite;
    }

    public static SecretKeyAccessorBuilder builder() {
        return new SecretKeyAccessorBuilder();
    }

    public static class SecretKeyAccessorBuilder {
        private DeviceKeyManager<KeyStore.SecretKeyEntry> keyManager;
        private CryptoSuite suite;

        SecretKeyAccessorBuilder() {
        }

        public SecretKeyAccessorBuilder keyManager(DeviceKeyManager<KeyStore.SecretKeyEntry> keyManager) {
            this.keyManager = keyManager;
            return this;
        }

        public SecretKeyAccessorBuilder suite(CryptoSuite suite) {
            this.suite = suite;
            return this;
        }

        public SecretKeyAccessor build() {
            return new SecretKeyAccessor(this.keyManager, this.suite);
        }

        public String toString() {
            return "SecretKeyAccessor.SecretKeyAccessorBuilder(keyManager=" + this.keyManager + ", suite=" + this.suite + ")";
        }
    }
}

