/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.platform;

import androidx.annotation.NonNull;
import com.microsoft.identity.common.java.authscheme.IPoPAuthenticationSchemeParams;
import com.microsoft.identity.common.java.crypto.IDevicePopManager;
import com.microsoft.identity.common.java.exception.ClientException;
import com.microsoft.identity.common.java.interfaces.IPlatformComponents;
import com.microsoft.identity.common.java.result.GenerateShrResult;
import java.net.URL;

public class DevicePoPUtils {
    private DevicePoPUtils() {
    }

    public static synchronized GenerateShrResult generateSignedHttpRequest(@NonNull IPlatformComponents platformComponents, @NonNull IPoPAuthenticationSchemeParams popSchemeParams) throws ClientException {
        long ONE_SECOND_MILLIS = 1000L;
        long timestampMillis = platformComponents.getClockSkewManager().getAdjustedReferenceTime().getTime();
        String httpMethodStr = popSchemeParams.getHttpMethod();
        URL resourceUrl = popSchemeParams.getUrl();
        String nonce = popSchemeParams.getNonce();
        String clientClaims = popSchemeParams.getClientClaims();
        IDevicePopManager popMgr = platformComponents.getDefaultDevicePopManager();
        if (!popMgr.asymmetricKeyExists()) {
            popMgr.generateAsymmetricKey();
        }
        String shr = popMgr.mintSignedHttpRequest(httpMethodStr, timestampMillis / 1000L, resourceUrl, nonce, clientClaims);
        GenerateShrResult result = new GenerateShrResult();
        result.setShr(shr);
        return result;
    }
}

