/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.broker;

import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.RemoteException;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.microsoft.identity.common.exception.BrokerCommunicationException;
import com.microsoft.identity.common.internal.broker.BoundServiceConnection;
import com.microsoft.identity.common.internal.broker.ipc.BrokerOperationBundle;
import com.microsoft.identity.common.internal.broker.ipc.IIpcStrategy;
import com.microsoft.identity.common.java.util.ResultFuture;
import com.microsoft.identity.common.logging.Logger;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public abstract class BoundServiceClient<T extends IInterface> {
    private static final String TAG = BoundServiceClient.class.getSimpleName();
    private static final int DEFAULT_BIND_TIMEOUT_IN_SECONDS = 30;
    protected final Context mContext;
    private final int mTimeOutInSeconds;
    private final String mTargetServiceClassName;
    private final String mTargetServiceIntentFilter;
    private BoundServiceConnection mConnection;
    private boolean mHasStartedBinding;

    @Nullable
    abstract Bundle performOperationInternal(@NonNull BrokerOperationBundle var1, @NonNull T var2) throws RemoteException, BrokerCommunicationException;

    @NonNull
    abstract T getInterfaceFromIBinder(@NonNull IBinder var1);

    public BoundServiceClient(@NonNull Context context, @NonNull String targetServiceClassName, @NonNull String targetServiceIntentFilter) {
        this(context, targetServiceClassName, targetServiceIntentFilter, 30);
    }

    public BoundServiceClient(@NonNull Context context, @NonNull String targetServiceClassName, @NonNull String targetServiceIntentFilter, int timeOutInSeconds) {
        this.mContext = context;
        this.mTimeOutInSeconds = timeOutInSeconds;
        this.mTargetServiceClassName = targetServiceClassName;
        this.mTargetServiceIntentFilter = targetServiceIntentFilter;
    }

    @Nullable
    public Bundle performOperation(@NonNull BrokerOperationBundle inputBundle) throws RemoteException, BrokerCommunicationException, InterruptedException, ExecutionException, TimeoutException {
        T aidlInterface = this.connect(inputBundle.getTargetBrokerAppPackageName());
        return this.performOperationInternal(inputBundle, aidlInterface);
    }

    @NonNull
    protected T connect(@NonNull String targetServicePackageName) throws BrokerCommunicationException, InterruptedException, TimeoutException, ExecutionException {
        String methodTag = TAG + ":connect";
        if (!this.isBoundServiceSupported(targetServicePackageName)) {
            String errorMessage = "Bound service is not supported.";
            Logger.info(methodTag, "Bound service is not supported.");
            throw new BrokerCommunicationException(BrokerCommunicationException.Category.OPERATION_NOT_SUPPORTED_ON_SERVER_SIDE, IIpcStrategy.Type.BOUND_SERVICE, "Bound service is not supported.", null);
        }
        ResultFuture future = new ResultFuture();
        this.mConnection = new BoundServiceConnection((ResultFuture<IBinder>)future);
        this.mHasStartedBinding = this.mContext.bindService(this.getIntentForBoundService(targetServicePackageName), (ServiceConnection)this.mConnection, 1);
        if (!this.mHasStartedBinding) {
            String errorMessage = "failed to bind. The service is not available.";
            Logger.info(methodTag, "failed to bind. The service is not available.");
            throw new BrokerCommunicationException(BrokerCommunicationException.Category.OPERATION_NOT_SUPPORTED_ON_SERVER_SIDE, IIpcStrategy.Type.BOUND_SERVICE, "failed to bind. The service is not available.", null);
        }
        Logger.info(methodTag, "Android is establishing the bound service connection.");
        IBinder binder = (IBinder)future.get((long)this.mTimeOutInSeconds, TimeUnit.SECONDS);
        return this.getInterfaceFromIBinder(binder);
    }

    public void disconnect() {
        if (this.mHasStartedBinding) {
            this.mContext.unbindService((ServiceConnection)this.mConnection);
            this.mHasStartedBinding = false;
        }
    }

    public boolean isBoundServiceSupported(@NonNull String targetServicePackageName) {
        List info = this.mContext.getPackageManager().queryIntentServices(this.getIntentForBoundService(targetServicePackageName), 0);
        return info != null && info.size() > 0;
    }

    @NonNull
    private Intent getIntentForBoundService(@NonNull String targetServicePackageName) {
        Intent boundServiceIntent = new Intent(this.mTargetServiceIntentFilter);
        boundServiceIntent.setPackage(targetServicePackageName);
        boundServiceIntent.setClassName(targetServicePackageName, this.mTargetServiceClassName);
        return boundServiceIntent;
    }
}

