/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.crypto;

import android.content.Context;
import com.microsoft.identity.common.adal.internal.AuthenticationSettings;
import com.microsoft.identity.common.crypto.AndroidWrappedKeyLoader;
import com.microsoft.identity.common.java.crypto.StorageEncryptionManager;
import com.microsoft.identity.common.java.crypto.key.AES256KeyLoader;
import com.microsoft.identity.common.java.crypto.key.AbstractSecretKeyLoader;
import com.microsoft.identity.common.java.crypto.key.PredefinedKeyLoader;
import com.microsoft.identity.common.java.telemetry.ITelemetryCallback;
import com.microsoft.identity.common.logging.Logger;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Collections;
import java.util.List;
import lombok.NonNull;

public class AndroidAuthSdkStorageEncryptionManager
extends StorageEncryptionManager {
    private static final String TAG = AndroidAuthSdkStorageEncryptionManager.class.getSimpleName();
    static final String KEY_STORE_ALIAS = "AdalKey";
    private final PredefinedKeyLoader mPredefinedKeyLoader;
    private final AndroidWrappedKeyLoader mKeyStoreKeyLoader;

    public AndroidAuthSdkStorageEncryptionManager(@NonNull Context context, @Nullable ITelemetryCallback telemetryCallback) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        this.mPredefinedKeyLoader = AuthenticationSettings.INSTANCE.getSecretKeyData() == null ? null : new PredefinedKeyLoader("USER_DEFINED_KEY", AuthenticationSettings.INSTANCE.getSecretKeyData());
        this.mKeyStoreKeyLoader = new AndroidWrappedKeyLoader(KEY_STORE_ALIAS, context, telemetryCallback);
    }

    @NonNull
    public AES256KeyLoader getKeyLoaderForEncryption() {
        if (this.mPredefinedKeyLoader != null) {
            return this.mPredefinedKeyLoader;
        }
        return this.mKeyStoreKeyLoader;
    }

    @NonNull
    public List<AbstractSecretKeyLoader> getKeyLoaderForDecryption(@NonNull byte[] cipherText) {
        if (cipherText == null) {
            throw new NullPointerException("cipherText is marked non-null but is null");
        }
        String methodTag = TAG + ":getKeyLoaderForDecryption";
        if (this.mPredefinedKeyLoader != null && AndroidAuthSdkStorageEncryptionManager.isEncryptedByThisKeyIdentifier((byte[])cipherText, (String)"U001")) {
            return Collections.singletonList(this.mPredefinedKeyLoader);
        }
        if (AndroidAuthSdkStorageEncryptionManager.isEncryptedByThisKeyIdentifier((byte[])cipherText, (String)"A001")) {
            return Collections.singletonList(this.mKeyStoreKeyLoader);
        }
        Logger.warn(methodTag, "Cannot find a matching key to decrypt the given blob");
        return Collections.emptyList();
    }
}

