/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common;

import android.app.Activity;
import android.content.Context;
import android.content.SharedPreferences;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import com.microsoft.identity.common.crypto.AndroidAuthSdkStorageEncryptionManager;
import com.microsoft.identity.common.crypto.AndroidBrokerStorageEncryptionManager;
import com.microsoft.identity.common.internal.cache.SharedPreferencesFileManager;
import com.microsoft.identity.common.internal.net.cache.HttpCache;
import com.microsoft.identity.common.internal.platform.AndroidDeviceMetadata;
import com.microsoft.identity.common.internal.platform.AndroidPlatformUtil;
import com.microsoft.identity.common.internal.platform.DevicePopManager;
import com.microsoft.identity.common.internal.providers.oauth2.AndroidTaskStateGenerator;
import com.microsoft.identity.common.internal.ui.AndroidAuthorizationStrategyFactory;
import com.microsoft.identity.common.internal.util.ProcessUtil;
import com.microsoft.identity.common.internal.util.SharedPrefStringNameValueStorage;
import com.microsoft.identity.common.internal.util.SharedPreferenceLongStorage;
import com.microsoft.identity.common.java.cache.IMultiTypeNameValueStorage;
import com.microsoft.identity.common.java.crypto.IDevicePopManager;
import com.microsoft.identity.common.java.crypto.IKeyAccessor;
import com.microsoft.identity.common.java.exception.ClientException;
import com.microsoft.identity.common.java.interfaces.IHttpClientWrapper;
import com.microsoft.identity.common.java.interfaces.INameValueStorage;
import com.microsoft.identity.common.java.interfaces.IPlatformComponents;
import com.microsoft.identity.common.java.net.DefaultHttpClientWrapper;
import com.microsoft.identity.common.java.platform.Device;
import com.microsoft.identity.common.java.platform.IDeviceMetadata;
import com.microsoft.identity.common.java.providers.oauth2.IStateGenerator;
import com.microsoft.identity.common.java.strategies.IAuthorizationStrategyFactory;
import com.microsoft.identity.common.java.util.ClockSkewManager;
import com.microsoft.identity.common.java.util.IClockSkewManager;
import com.microsoft.identity.common.java.util.IPlatformUtil;
import com.microsoft.identity.common.java.util.ported.Predicate;
import com.microsoft.identity.common.logging.Logger;
import java.io.File;
import java.io.IOException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.Iterator;
import java.util.Map;
import lombok.NonNull;

public class AndroidPlatformComponents
implements IPlatformComponents {
    private static final String TAG = AndroidPlatformComponents.class.getSimpleName();
    private static final String SKEW_PREFERENCES_FILENAME = "com.microsoft.identity.client.clock_correction";
    @NonNull
    protected final Context mContext;
    @Nullable
    protected final Activity mActivity;
    @Nullable
    protected final Fragment mFragment;
    private IClockSkewManager mClockSkewManager;
    private IDevicePopManager mDefaultDevicePoPManager;
    private static boolean sInitialized = false;

    private static synchronized void initializeStaticClasses(@NonNull Context context) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        String methodTag = TAG + ":initializeStaticClasses";
        if (!sInitialized) {
            Device.setDeviceMetadata((IDeviceMetadata)new AndroidDeviceMetadata());
            Logger.setAndroidLogger();
            File cacheDir = context.getCacheDir();
            if (cacheDir != null) {
                HttpCache.initialize(cacheDir);
            } else {
                Logger.warn(methodTag, "Http caching is not enabled because the cache dir is null");
            }
            sInitialized = true;
        }
    }

    public static AndroidPlatformComponents createFromContext(@NonNull Context context) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        return new AndroidPlatformComponents(context, null, null);
    }

    public static AndroidPlatformComponents createFromActivity(@NonNull Activity activity, @Nullable Fragment fragment) {
        if (activity == null) {
            throw new NullPointerException("activity is marked non-null but is null");
        }
        return new AndroidPlatformComponents(activity.getApplicationContext(), activity, fragment);
    }

    protected AndroidPlatformComponents(@NonNull Context applicationContext, @Nullable Activity activity, @Nullable Fragment fragment) {
        if (applicationContext == null) {
            throw new NullPointerException("applicationContext is marked non-null but is null");
        }
        this.mContext = applicationContext;
        this.mActivity = activity;
        this.mFragment = fragment;
        AndroidPlatformComponents.initializeStaticClasses(applicationContext);
    }

    @NonNull
    public IKeyAccessor getStorageEncryptionManager() {
        String methodTag = TAG + ":getStorageEncryptionManager";
        if (ProcessUtil.isBrokerProcess(this.mContext)) {
            Logger.info(methodTag, "Returning AndroidBrokerStorageEncryptionManager");
            return new AndroidBrokerStorageEncryptionManager(this.mContext, null);
        }
        Logger.info(methodTag, "Returning AndroidAuthSdkStorageEncryptionManager");
        return new AndroidAuthSdkStorageEncryptionManager(this.mContext, null);
    }

    @NonNull
    public synchronized IClockSkewManager getClockSkewManager() {
        if (null == this.mClockSkewManager) {
            this.mClockSkewManager = new ClockSkewManager((INameValueStorage)new SharedPreferenceLongStorage(SharedPreferencesFileManager.getSharedPreferences(this.mContext, SKEW_PREFERENCES_FILENAME, null)));
        }
        return this.mClockSkewManager;
    }

    @NonNull
    public synchronized IDevicePopManager getDefaultDevicePopManager() throws ClientException {
        if (this.mDefaultDevicePoPManager == null) {
            this.mDefaultDevicePoPManager = this.getDevicePopManager(null);
        }
        return this.mDefaultDevicePoPManager;
    }

    @NonNull
    public IDevicePopManager getDevicePopManager(@Nullable String alias) throws ClientException {
        String errCode;
        Exception exception;
        try {
            if (alias == null) {
                return new DevicePopManager(this.mContext);
            }
            return new DevicePopManager(this.mContext, alias);
        }
        catch (KeyStoreException e) {
            exception = e;
            errCode = "keystore_not_initialized";
        }
        catch (CertificateException e) {
            exception = e;
            errCode = "certificate_load_failure";
        }
        catch (NoSuchAlgorithmException e) {
            exception = e;
            errCode = "no_such_algorithm";
        }
        catch (IOException e) {
            exception = e;
            errCode = "io_error";
        }
        throw new ClientException(errCode, "Failed to initialize DevicePoPManager = " + exception.getMessage(), (Throwable)exception);
    }

    public <T> INameValueStorage<T> getNameValueStore(@NonNull String storeName, @NonNull Class<T> clazz) {
        if (storeName == null) {
            throw new NullPointerException("storeName is marked non-null but is null");
        }
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        return this.getEncryptedNameValueStore(storeName, null, clazz);
    }

    public <T> INameValueStorage<T> getEncryptedNameValueStore(@NonNull String storeName, @Nullable IKeyAccessor helper, @NonNull Class<T> clazz) {
        if (storeName == null) {
            throw new NullPointerException("storeName is marked non-null but is null");
        }
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        SharedPreferencesFileManager mgr = SharedPreferencesFileManager.getSharedPreferences(this.mContext, storeName, helper);
        if (Long.class.isAssignableFrom(clazz)) {
            SharedPreferenceLongStorage store = new SharedPreferenceLongStorage(mgr);
            return store;
        }
        if (String.class.isAssignableFrom(clazz)) {
            SharedPrefStringNameValueStorage store = new SharedPrefStringNameValueStorage(mgr);
            return store;
        }
        throw new UnsupportedOperationException("Only Long and String are natively supported as types");
    }

    public IMultiTypeNameValueStorage getEncryptedFileStore(@NonNull String storeName, @NonNull IKeyAccessor helper) {
        if (storeName == null) {
            throw new NullPointerException("storeName is marked non-null but is null");
        }
        if (helper == null) {
            throw new NullPointerException("helper is marked non-null but is null");
        }
        return SharedPreferencesFileManager.getSharedPreferences(this.mContext, storeName, helper);
    }

    public IMultiTypeNameValueStorage getFileStore(@NonNull String storeName) {
        if (storeName == null) {
            throw new NullPointerException("storeName is marked non-null but is null");
        }
        return SharedPreferencesFileManager.getSharedPreferences(this.mContext, storeName, null);
    }

    public INameValueStorage<String> getMultiProcessStringStore(@NonNull String storeName) {
        if (storeName == null) {
            throw new NullPointerException("storeName is marked non-null but is null");
        }
        final SharedPreferences sharedPreferences = this.mContext.getSharedPreferences(storeName, 4);
        return new SharedPrefStringNameValueStorage(new IMultiTypeNameValueStorage(){

            public void putString(String key, String value) {
                sharedPreferences.edit().putString(key, value).apply();
            }

            public String getString(String key) {
                return sharedPreferences.getString(key, null);
            }

            public void putLong(String key, long value) {
                sharedPreferences.edit().putString(key, Long.toString(value)).apply();
            }

            public long getLong(String key) {
                try {
                    if (!sharedPreferences.contains(key)) {
                        return 0L;
                    }
                    return Long.parseLong(sharedPreferences.getString(key, "0"));
                }
                catch (NumberFormatException nfe) {
                    return 0L;
                }
            }

            public Map<String, String> getAll() {
                return sharedPreferences.getAll();
            }

            public Iterator<Map.Entry<String, String>> getAllFilteredByKey(Predicate<String> keyFilter) {
                return null;
            }

            public boolean contains(String key) {
                return sharedPreferences.contains(key);
            }

            public void clear() {
                sharedPreferences.edit().clear().commit();
            }

            public void remove(String key) {
                sharedPreferences.edit().remove(key).commit();
            }
        });
    }

    @NonNull
    public IAuthorizationStrategyFactory getAuthorizationStrategyFactory() {
        return AndroidAuthorizationStrategyFactory.builder().context(this.mContext).activity(this.mActivity).fragment(this.mFragment).build();
    }

    @NonNull
    public IStateGenerator getStateGenerator() {
        if (this.mActivity == null) {
            throw new IllegalStateException("StateGenerator requires an activity");
        }
        return new AndroidTaskStateGenerator(this.mActivity.getTaskId());
    }

    @NonNull
    public IPlatformUtil getPlatformUtil() {
        return new AndroidPlatformUtil(this.mContext, this.mActivity);
    }

    @NonNull
    public IHttpClientWrapper getHttpClientWrapper() {
        return new DefaultHttpClientWrapper();
    }
}

